/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.credentials.models;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class Credentials {
    private String remoteSpaceKey;
    private Long remoteSpaceId;

    protected Credentials(Map<String, Object> map) {
        this.remoteSpaceKey = (String)map.get("space");
        this.remoteSpaceId = (Long)map.get("remoteSpaceId");
    }

    public void validate() throws NoSuchFieldException {
        this.validate(this.remoteSpaceKey, "space");
    }

    public void override(Map<String, Object> parameters) {
        Object value = parameters.get("space");
        if (value != null) {
            this.remoteSpaceKey = (String)value;
        }
        if ((value = parameters.get("remoteSpaceId")) != null) {
            this.remoteSpaceId = (Long)value;
        }
    }

    protected void validate(String value, String name) throws NoSuchFieldException {
        if (!StringUtils.isNotBlank((CharSequence)value)) {
            throw new NoSuchFieldException(name + " not set");
        }
    }

    public boolean needsRemoteSpaceId() {
        return this.isCloudConfluenceEnvironment() && null == this.remoteSpaceId;
    }

    public boolean isCloudConfluenceEnvironment() {
        return "cloud".equalsIgnoreCase(this.getConfluenceEnvironment());
    }

    public abstract String getConfluenceEnvironment();

    protected Credentials(CredentialsBuilder<?, ?> b) {
        this.remoteSpaceKey = ((CredentialsBuilder)b).remoteSpaceKey;
        this.remoteSpaceId = ((CredentialsBuilder)b).remoteSpaceId;
    }

    public String getRemoteSpaceKey() {
        return this.remoteSpaceKey;
    }

    public Long getRemoteSpaceId() {
        return this.remoteSpaceId;
    }

    public void setRemoteSpaceKey(String remoteSpaceKey) {
        this.remoteSpaceKey = remoteSpaceKey;
    }

    public void setRemoteSpaceId(Long remoteSpaceId) {
        this.remoteSpaceId = remoteSpaceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$remoteSpaceId = this.getRemoteSpaceId();
        Long other$remoteSpaceId = other.getRemoteSpaceId();
        if (this$remoteSpaceId == null ? other$remoteSpaceId != null : !((Object)this$remoteSpaceId).equals(other$remoteSpaceId)) {
            return false;
        }
        String this$remoteSpaceKey = this.getRemoteSpaceKey();
        String other$remoteSpaceKey = other.getRemoteSpaceKey();
        return !(this$remoteSpaceKey == null ? other$remoteSpaceKey != null : !this$remoteSpaceKey.equals(other$remoteSpaceKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Credentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $remoteSpaceId = this.getRemoteSpaceId();
        result = result * 59 + ($remoteSpaceId == null ? 43 : ((Object)$remoteSpaceId).hashCode());
        String $remoteSpaceKey = this.getRemoteSpaceKey();
        result = result * 59 + ($remoteSpaceKey == null ? 43 : $remoteSpaceKey.hashCode());
        return result;
    }

    public String toString() {
        return "Credentials(remoteSpaceKey=" + this.getRemoteSpaceKey() + ", remoteSpaceId=" + this.getRemoteSpaceId() + ")";
    }

    public Credentials() {
    }

    public static abstract class CredentialsBuilder<C extends Credentials, B extends CredentialsBuilder<C, B>> {
        private String remoteSpaceKey;
        private Long remoteSpaceId;

        protected abstract B self();

        public abstract C build();

        public B remoteSpaceKey(String remoteSpaceKey) {
            this.remoteSpaceKey = remoteSpaceKey;
            return this.self();
        }

        public B remoteSpaceId(Long remoteSpaceId) {
            this.remoteSpaceId = remoteSpaceId;
            return this.self();
        }

        public String toString() {
            return "Credentials.CredentialsBuilder(remoteSpaceKey=" + this.remoteSpaceKey + ", remoteSpaceId=" + this.remoteSpaceId + ")";
        }
    }
}

