/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence.manifest;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.comalatech.confluence.remotepublishing.confluence.manifest.RemoteManifestOperation;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceCloudRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceContentType;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceDCRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceRestAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class LabelManifestOperation
implements RemoteManifestOperation {
    private final RemotePageManifest remotePageManifest;
    private final ApiAction apiAction;
    private final Credentials credentials;
    private final String type;

    public LabelManifestOperation(ApiAction apiAction, RemotePageManifest remotePageManifest, Credentials credentials, String type) {
        this.apiAction = apiAction;
        this.remotePageManifest = remotePageManifest;
        this.credentials = credentials;
        this.type = type;
    }

    @Override
    public void add() {
        Enum apiUrlOperation = ConfluenceDCRestApi.GET_LABEL;
        if (this.credentials.isCloudConfluenceEnvironment()) {
            apiUrlOperation = ConfluenceContentType.isPage(this.type) ? ConfluenceCloudRestApi.GET_PAGE_LABELS : ConfluenceCloudRestApi.GET_BLOGPOSTS_LABELS;
        }
        JsonObject response = this.apiAction.httpGetPetition((ConfluenceRestAPI)((Object)apiUrlOperation), true, false, new String[]{this.remotePageManifest.getPageId()});
        ArrayList<Label> remoteLabelList = new ArrayList<Label>();
        JsonElement labelResults = response.get("results");
        if (labelResults != null) {
            JsonArray labels = labelResults.getAsJsonArray();
            for (JsonElement label : labels) {
                remoteLabelList.add(this.buildRemoteLabelManifest(label));
            }
            this.remotePageManifest.setLabels(remoteLabelList);
        }
    }

    private Label buildRemoteLabelManifest(JsonElement label) {
        String prefix = label.getAsJsonObject().get("prefix").getAsString();
        String name = label.getAsJsonObject().get("name").getAsString();
        return new Label(name, Namespace.getNamespace((String)prefix));
    }
}

