/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence.manifest;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.remotepublishing.confluence.manifest.RemoteManifestOperation;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceCloudRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceContentType;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceDCRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceRestAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;

public class AttachmentManifestOperation
implements RemoteManifestOperation {
    private final RemotePageManifest remotePageManifest;
    private final ApiAction apiAction;
    private final Credentials credentials;
    private final String type;

    public AttachmentManifestOperation(ApiAction apiAction, RemotePageManifest remotePageManifest, Credentials credentials, String type) {
        this.apiAction = apiAction;
        this.remotePageManifest = remotePageManifest;
        this.credentials = credentials;
        this.type = type;
    }

    @Override
    public void add() {
        JsonObject response;
        Enum apiUrlOperation = ConfluenceDCRestApi.CONTENT_ATTACHMENTS;
        if (this.credentials.isCloudConfluenceEnvironment()) {
            apiUrlOperation = ConfluenceContentType.isPage(this.type) ? ConfluenceCloudRestApi.GET_PAGE_ATTACHMENTS : ConfluenceCloudRestApi.GET_BLOGPOST_ATTACHMENTS;
            response = this.apiAction.httpGetPetition((ConfluenceRestAPI)((Object)apiUrlOperation), true, false, new String[]{this.remotePageManifest.getPageId()});
        } else {
            response = this.apiAction.httpGetPetition((ConfluenceRestAPI)((Object)apiUrlOperation), true, false, new String[]{this.remotePageManifest.getPageId(), "0", "50"});
        }
        if (response != null) {
            boolean hasMore = response.get("_links").getAsJsonObject().has("next");
            JsonArray attachments = response.get("results").getAsJsonArray();
            for (JsonElement attachment : attachments) {
                this.remotePageManifest.addAttachment(this.buildRemoteAttachmentManifest(attachment, this.remotePageManifest.getPageId()));
            }
            while (hasMore) {
                response = this.apiAction.httpGetPetition(response.get("_links").getAsJsonObject().get("next").getAsString(), true, false, new String[0]);
                attachments = response.get("results").getAsJsonArray();
                for (JsonElement attachment : attachments) {
                    this.remotePageManifest.addAttachment(this.buildRemoteAttachmentManifest(attachment, this.remotePageManifest.getPageId()));
                }
                hasMore = response.get("_links").getAsJsonObject().has("next");
            }
        }
    }

    private RemoteAttachmentManifest buildRemoteAttachmentManifest(JsonElement attachment, String manifestPageId) {
        if (this.credentials.isCloudConfluenceEnvironment()) {
            return this.buildCloudRemoteAttachmentManifest(attachment);
        }
        return this.buildDataCenterRemoteAttachmentManifest(manifestPageId, attachment);
    }

    private RemoteAttachmentManifest buildCloudRemoteAttachmentManifest(JsonElement attachment) {
        String id = this.getAttachmentId(attachment);
        String fileName = attachment.getAsJsonObject().get("title").getAsString();
        int fileSize = attachment.getAsJsonObject().get("fileSize").getAsInt();
        ArrayList<Label> labelList = new ArrayList<Label>();
        JsonObject remoteAttachmentData = this.apiAction.httpGetPetition(ConfluenceCloudRestApi.GET_ATTACHMENT_BY_ID, true, false, id);
        if (remoteAttachmentData != null) {
            JsonObject attachmentsLabelsResponse = this.apiAction.httpGetPetition(ConfluenceCloudRestApi.GET_LABEL_ATTACHMENTS, true, false, id);
            JsonElement results = attachmentsLabelsResponse.getAsJsonObject().get("results");
            this.setAttachmentLabels(labelList, results);
        }
        return new RemoteAttachmentManifest(id, fileName, this.getAttachmentVersion(remoteAttachmentData), fileSize, this.getAttachmentCreatedDate(remoteAttachmentData), this.getAttachmentComment(remoteAttachmentData), labelList);
    }

    private RemoteAttachmentManifest buildDataCenterRemoteAttachmentManifest(String remotePageId, JsonElement attachment) {
        String fileName = this.getAttachmentFilename(attachment);
        int fileSize = attachment.getAsJsonObject().get("extensions").getAsJsonObject().get("fileSize").getAsInt();
        JsonObject responseRemoteAttachmentData = this.apiAction.httpGetPetition(ConfluenceDCRestApi.ATTACHMENT_DATA, true, false, remotePageId, fileName);
        Date createdDate = null;
        String comment = null;
        int version = 0;
        ArrayList<Label> labelList = new ArrayList<Label>();
        if (responseRemoteAttachmentData != null) {
            JsonObject remoteAttachmentData = responseRemoteAttachmentData.get("results").getAsJsonArray().get(0).getAsJsonObject();
            version = this.getAttachmentVersion(remoteAttachmentData);
            String createdDateString = remoteAttachmentData.get("history").getAsJsonObject().get("createdDate").getAsString();
            createdDate = DateTime.parse((String)createdDateString).toDate();
            JsonObject metadata = attachment.getAsJsonObject().get("metadata").getAsJsonObject();
            comment = "";
            if (metadata != null) {
                JsonElement labels;
                JsonElement commentJson = metadata.get("comment");
                if (commentJson != null) {
                    comment = commentJson.getAsString();
                }
                if ((labels = metadata.get("labels")) != null) {
                    JsonElement results = labels.getAsJsonObject().get("results");
                    this.setAttachmentLabels(labelList, results);
                }
            }
        }
        return new RemoteAttachmentManifest(this.getAttachmentId(attachment), fileName, version, fileSize, createdDate, comment, labelList);
    }

    private void setAttachmentLabels(List<Label> labels, JsonElement results) {
        if (results != null) {
            JsonArray labelsJson = results.getAsJsonArray();
            labelsJson.forEach(l -> labels.add(new Label(l.getAsJsonObject().get("name").getAsString(), l.getAsJsonObject().get("prefix").getAsString())));
        }
    }

    private int getAttachmentVersion(JsonObject attachmentData) {
        if (attachmentData == null || attachmentData.get("version") == null || attachmentData.get("version").getAsJsonObject().get("number") == null) {
            return 0;
        }
        return attachmentData.get("version").getAsJsonObject().get("number").getAsInt();
    }

    private Date getAttachmentCreatedDate(JsonObject attachmentData) {
        if (attachmentData == null || attachmentData.get("version") == null || attachmentData.get("version").getAsJsonObject().get("createdAt") == null) {
            return null;
        }
        String createdDateString = attachmentData.get("version").getAsJsonObject().get("createdAt").getAsString();
        return DateTime.parse((String)createdDateString).toDate();
    }

    private String getAttachmentComment(JsonObject attachmentData) {
        if (attachmentData == null || attachmentData.get("comment") == null || attachmentData.get("version").getAsJsonObject().get("number") == null) {
            return null;
        }
        return attachmentData.get("comment").getAsString();
    }

    private String getAttachmentId(JsonElement attachmentData) {
        if (attachmentData == null || attachmentData.getAsJsonObject().get("id") == null) {
            return null;
        }
        return attachmentData.getAsJsonObject().get("id").getAsString();
    }

    private String getAttachmentFilename(JsonElement attachmentData) {
        if (attachmentData == null || attachmentData.getAsJsonObject().get("title") == null) {
            return null;
        }
        return attachmentData.getAsJsonObject().get("title").getAsString();
    }
}

