/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence.manifest;

import com.comalatech.confluence.remotepublishing.confluence.manifest.RemoteManifestOperation;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceCloudRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceDCRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceRestAPI;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class AncestorManifestOperation
implements RemoteManifestOperation {
    private final RemotePageManifest remotePageManifest;
    private final ApiAction apiAction;
    private final Credentials credentials;

    public AncestorManifestOperation(ApiAction apiAction, RemotePageManifest remotePageManifest, Credentials credentials) {
        this.apiAction = apiAction;
        this.remotePageManifest = remotePageManifest;
        this.credentials = credentials;
    }

    @Override
    public void add() {
        JsonObject response = this.apiAction.httpGetPetition((ConfluenceRestAPI)((Object)(this.credentials.isCloudConfluenceEnvironment() ? ConfluenceCloudRestApi.GET_PAGE_ANCESTORS : ConfluenceDCRestApi.CONTENT_ANCESTORS)), true, false, this.remotePageManifest.getPageId());
        if (this.credentials.isCloudConfluenceEnvironment()) {
            this.buildCloudRemoteAttachmentManifest(response);
        } else {
            this.buildDataCenterRemoteAttachmentManifest(response);
        }
    }

    private void buildDataCenterRemoteAttachmentManifest(JsonObject ancestorResponse) {
        int totalAncestors;
        JsonElement ancestors = ancestorResponse.get("ancestors");
        int n = totalAncestors = ancestors != null ? ancestors.getAsJsonArray().size() : 0;
        if (totalAncestors != 0) {
            this.remotePageManifest.setParentId(ancestors.getAsJsonArray().get(totalAncestors - 1).getAsJsonObject().get("id").getAsString());
            this.remotePageManifest.setParentTitle(ancestors.getAsJsonArray().get(totalAncestors - 1).getAsJsonObject().get("title").getAsString());
        } else {
            this.remotePageManifest.setParentId("0");
            this.remotePageManifest.setParentTitle(null);
        }
    }

    private void buildCloudRemoteAttachmentManifest(JsonObject ancestorResponse) {
        int totalAncestors;
        JsonElement ancestors = ancestorResponse.get("results");
        int n = totalAncestors = ancestors != null ? ancestors.getAsJsonArray().size() : 0;
        if (totalAncestors != 0) {
            String parentId = ancestors.getAsJsonArray().get(totalAncestors - 1).getAsJsonObject().get("id").getAsString();
            this.remotePageManifest.setParentId(parentId);
            JsonObject parentResponse = this.apiAction.httpGetPetition(ConfluenceCloudRestApi.GET_PAGE, true, false, parentId);
            JsonElement parentTitle = parentResponse.get("title");
            this.remotePageManifest.setParentTitle(parentTitle != null ? parentTitle.getAsString() : null);
        } else {
            this.remotePageManifest.setParentId("0");
            this.remotePageManifest.setParentTitle(null);
        }
    }
}

