/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.util.HtmlUtil;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfigurationManager;
import com.comalatech.confluence.remotepublishing.confluence.RemotePublisherService;
import com.comalatech.confluence.remotepublishing.confluence.RestModelComponent;
import com.comalatech.confluence.remotepublishing.confluence.manifest.AncestorManifestOperation;
import com.comalatech.confluence.remotepublishing.confluence.manifest.AttachmentManifestOperation;
import com.comalatech.confluence.remotepublishing.confluence.manifest.LabelManifestOperation;
import com.comalatech.confluence.remotepublishing.confluence.manifest.RemoteManifestOperationExecutor;
import com.comalatech.confluence.remotepublishing.credentials.models.Credentials;
import com.comalatech.confluence.remotepublishing.credentials.models.UserCredentials;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceCloudRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceContentType;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceDCRestApi;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceRestAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonRemotePublisherService
implements RemotePublisherService {
    private static final Logger log = LoggerFactory.getLogger(CommonRemotePublisherService.class);
    protected final RemotePublishingConfigurationManager remotePublishingConfigurationManager;
    protected final RestModelComponent restModelComponent;
    private final RemoteManifestOperationExecutor remoteManifestOperationExecutor;
    private static final String POSITION = "position";
    protected static final String RESULTS = "results";
    private static final String POSITION_APPEND = "append";
    private static final String POSITION_BELOW = "below";
    protected Credentials credentials;
    protected String spaceKey;
    protected ApiAction apiAction;

    public CommonRemotePublisherService(RemotePublishingConfigurationManager remotePublishingConfigurationManager) {
        this.remotePublishingConfigurationManager = remotePublishingConfigurationManager;
        this.restModelComponent = new RestModelComponent();
        this.remoteManifestOperationExecutor = new RemoteManifestOperationExecutor();
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
        this.apiAction.setRemoteCredentials(credentials, this.spaceKey);
    }

    @Override
    public void setCredentials(Credentials credentials, String spaceKey, String configName) {
        this.setCredentials(credentials);
        this.spaceKey = spaceKey;
        if (credentials.needsRemoteSpaceId()) {
            credentials.setRemoteSpaceId(this.getSpaceIdBySpaceKey(credentials.getRemoteSpaceKey()));
            this.remotePublishingConfigurationManager.putSpaceConfiguration(spaceKey, new RemotePublishingConfiguration(configName, credentials));
        }
    }

    @Override
    public void checkRemoteSpace() {
        JsonObject response = this.apiAction.httpGetPetition(ConfluenceDCRestApi.CHECK_SPACE, false, false, this.credentials.getRemoteSpaceKey());
        if (response == null) {
            throw new RemotePublishingException("space with key '" + HtmlUtil.htmlEncode((String)this.credentials.getRemoteSpaceKey()) + "' does not exist, or user not allowed to view the space");
        }
    }

    private long getSpaceIdBySpaceKey(String spaceKey) {
        JsonObject response = this.apiAction.httpGetPetition(ConfluenceCloudRestApi.GET_SPACES, true, false, spaceKey);
        return response.get(RESULTS).getAsJsonArray().get(0).getAsJsonObject().get("id").getAsLong();
    }

    @Override
    public RemotePageManifest createRemote(AbstractPage absPage) {
        RemotePageManifest manifest = null;
        log.debug("Adding '" + absPage.getTitle() + "'(" + absPage.getSpaceKey() + ")");
        if (absPage instanceof Page) {
            manifest = this.createRemotePage((Page)absPage);
        } else if (absPage instanceof BlogPost) {
            manifest = this.createRemoteBlogPost((BlogPost)absPage);
        }
        if (manifest == null) {
            throw new RemotePublishingException("create remote blogpost failed");
        }
        return manifest;
    }

    protected RemotePageManifest createRemotePage(Page page) {
        List<Page> remotePublishedChildList;
        JsonObject response;
        long remoteParentPageId = 0L;
        if (!page.getAncestors().isEmpty()) {
            remoteParentPageId = this.getRemotePageId(((Page)page.getAncestors().get(page.getAncestors().size() - 1)).getTitle(), ConfluenceContentType.getTypeFromAbstractPage((AbstractPage)page).getContentTypeName());
        }
        if ((response = this.createPageContent((AbstractPage)page, remoteParentPageId)) == null || !response.has("id")) {
            return null;
        }
        if (!page.getLabels().isEmpty()) {
            this.addRemoteLabels(response.get("id").getAsString(), page.getLabels());
        }
        if (!(remotePublishedChildList = this.getRemotePublishedChildren(page)).isEmpty()) {
            this.changeParentForPublishedChildren(remotePublishedChildList, response.get("id").getAsLong());
            this.reorderPagesInRemote(page, remotePublishedChildList, response.get("id").getAsString());
        }
        if (page.getParent() != null) {
            this.reorderParentPagesAfterPageUpdate(page.getParent());
        }
        return this.restModelComponent.createRemotePageManifest(page, response, this.credentials);
    }

    protected long getRemotePageId(String title, String type) {
        JsonObject response;
        if (this.credentials.isCloudConfluenceEnvironment() ? (response = this.apiAction.httpGetPetition(ConfluenceCloudRestApi.PAGE_CONTENT_EXIST, true, false, String.valueOf(this.credentials.getRemoteSpaceId()), title)) == null || response.get(RESULTS) == null || response.get(RESULTS).getAsJsonArray().isEmpty() : (response = this.apiAction.httpGetPetition(ConfluenceDCRestApi.CONTENT_EXIST, true, false, this.credentials.getRemoteSpaceKey(), title, type)) == null || !response.has("size") || response.get("size").getAsInt() == 0) {
            return 0L;
        }
        return response.get(RESULTS).getAsJsonArray().get(0).getAsJsonObject().get("id").getAsLong();
    }

    protected long getRemotePageVersion(String pageTitle) {
        JsonObject response;
        if (this.credentials.isCloudConfluenceEnvironment() ? (response = this.apiAction.httpGetPetition(ConfluenceCloudRestApi.PAGE_CONTENT_EXIST, true, false, String.valueOf(this.credentials.getRemoteSpaceId()), pageTitle)) == null || response.get(RESULTS) == null || response.get(RESULTS).getAsJsonArray().isEmpty() : (response = this.apiAction.httpGetPetition(ConfluenceDCRestApi.CONTENT_VERSION, true, false, this.credentials.getRemoteSpaceKey(), pageTitle)) == null || !response.has("size") || response.get("size").getAsInt() == 0) {
            return 0L;
        }
        return response.get(RESULTS).getAsJsonArray().get(0).getAsJsonObject().get("version").getAsJsonObject().get("number").getAsLong();
    }

    private JsonObject createPageContent(AbstractPage page, long remoteParentPageId) {
        StringEntity stringEntity = new StringEntity(this.credentials.isCloudConfluenceEnvironment() ? this.restModelComponent.generateCreatePageV2Payload((Page)page, remoteParentPageId, this.credentials) : this.restModelComponent.generatePageForCreation(page.getTitle(), page.getBodyAsString(), remoteParentPageId, this.credentials), ContentType.APPLICATION_JSON);
        return this.apiAction.httpPostPetition(stringEntity, (ConfluenceRestAPI)((Object)(this.credentials.isCloudConfluenceEnvironment() ? ConfluenceCloudRestApi.CREATE_PAGE : ConfluenceDCRestApi.CREATE_CONTENT)), true, false, new String[0]);
    }

    private JsonObject createBlogContent(BlogPost blog) {
        StringEntity stringEntity = new StringEntity(this.credentials.isCloudConfluenceEnvironment() ? this.restModelComponent.generateCreateBlogPostV2Payload(blog, this.credentials) : this.generateBlogForCreation(blog.getTitle(), blog.getBodyAsString()), ContentType.APPLICATION_JSON);
        return this.apiAction.httpPostPetition(stringEntity, (ConfluenceRestAPI)((Object)(this.credentials.isCloudConfluenceEnvironment() ? ConfluenceCloudRestApi.CREATE_BLOG_POST : ConfluenceDCRestApi.CREATE_CONTENT)), true, false, new String[0]);
    }

    private void addRemoteLabels(String remoteContentId, List<Label> labelList) {
        if (log.isDebugEnabled()) {
            log.debug("Adding labels of '" + remoteContentId);
        }
        if (labelList.isEmpty()) {
            return;
        }
        JsonArray labelArray = new JsonArray();
        for (Label label : this.restModelComponent.filterPersonalLabels(labelList)) {
            labelArray.add((JsonElement)this.generateLabelToAdd(label));
        }
        if (labelArray.isEmpty()) {
            return;
        }
        StringEntity stringEntity = new StringEntity(labelArray.toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.apiAction.httpPostPetition(stringEntity, (ConfluenceRestAPI)ConfluenceDCRestApi.ADD_LABEL, true, false, remoteContentId);
        if (response == null) {
            log.error("add labels failed");
        }
    }

    protected void changeParentForPublishedChildren(List<Page> publishedChildPages, long remoteParentPageId) {
        for (Page child : publishedChildPages) {
            StringEntity stringEntity = new StringEntity(this.restModelComponent.generatePageToUpdateAncestors(this.getRemotePageVersion(child.getTitle()) + 1L, remoteParentPageId, child.getTitle()).toString(), ContentType.APPLICATION_JSON);
            String pageId = String.valueOf(this.getRemotePageId(child.getTitle(), ConfluenceContentType.getTypeFromAbstractPage((AbstractPage)child).getContentTypeName()));
            if (pageId.equals("0")) continue;
            this.apiAction.httpPutPetition(stringEntity, (ConfluenceRestAPI)((Object)(this.credentials.isCloudConfluenceEnvironment() ? ConfluenceCloudRestApi.UPDATE_PAGE : ConfluenceDCRestApi.UPDATE_CONTENT)), pageId);
        }
    }

    protected RemotePageManifest createRemoteBlogPost(BlogPost blog) {
        JsonObject response = this.createBlogContent(blog);
        if (!blog.getLabels().isEmpty() && response != null && response.has("id")) {
            try {
                this.addRemoteLabels(response.get("id").getAsString(), blog.getLabels());
            }
            catch (RemotePublishingException e) {
                log.error(e.getMessage(), e.getCause());
            }
        }
        RemotePageManifest manifest = this.restModelComponent.createRemoteBlogManifest(response, this.credentials);
        manifest.setLabels(this.restModelComponent.filterPersonalLabels(blog.getLabels()));
        return manifest;
    }

    @Override
    public void checkRemoteSpacePermissions() {
        Page page = new Page();
        page.setTitle("Remote Publishing Permission Test Page");
        page.setBodyAsString("");
        JsonObject response = this.createPageContent((AbstractPage)page, 0L);
        if (response == null || !response.has("id")) {
            throw new RemotePublishingException("user '" + HtmlUtil.htmlEncode((String)((UserCredentials)this.credentials).getLoginUserName()) + "' cannot create pages in space '" + HtmlUtil.htmlEncode((String)(this.credentials.getRemoteSpaceKey() + "'")));
        }
        this.removeRemotePage(response.get("id").getAsString(), true);
    }

    @Override
    public void removeRemotePage(String pageId, boolean purgeFromTrash) throws RemotePublishingException {
        log.debug("Removing '" + pageId + "'(purge from trash: " + purgeFromTrash + ")");
        Enum deleteUrl = ConfluenceDCRestApi.DELETE_CONTENT;
        Enum deleteFromTrashURL = ConfluenceDCRestApi.REMOVE_FROM_TRASH;
        if (this.credentials.isCloudConfluenceEnvironment()) {
            deleteUrl = ConfluenceCloudRestApi.DELETE_PAGE;
            deleteFromTrashURL = ConfluenceCloudRestApi.DELETE_PAGE_FROM_TRASH;
        }
        this.removeContent(pageId, purgeFromTrash, (ConfluenceRestAPI)((Object)deleteUrl), (ConfluenceRestAPI)((Object)deleteFromTrashURL));
    }

    @Override
    public void removeRemoteBlogpost(String blogpostId, boolean purgeFromTrash) throws RemotePublishingException {
        log.debug("Removing '" + blogpostId + "'(purge from trash: " + purgeFromTrash + ")");
        Enum deleteUrl = ConfluenceDCRestApi.DELETE_CONTENT;
        Enum deleteTrashUrl = ConfluenceDCRestApi.REMOVE_FROM_TRASH;
        if (this.credentials.isCloudConfluenceEnvironment()) {
            deleteUrl = ConfluenceCloudRestApi.DELETE_BLOGPOST;
            deleteTrashUrl = ConfluenceCloudRestApi.DELETE_BLOGPOST_FROM_TRASH;
        }
        this.removeContent(blogpostId, purgeFromTrash, (ConfluenceRestAPI)((Object)deleteUrl), (ConfluenceRestAPI)((Object)deleteTrashUrl));
    }

    private void removeContent(String contentId, boolean purgeFromTrash, ConfluenceRestAPI deleteUrl, ConfluenceRestAPI deleteFromTrashURL) {
        JsonObject response = this.apiAction.httpDeletePetition(deleteUrl, false, contentId);
        if (purgeFromTrash && response != null) {
            response = this.apiAction.httpDeletePetition(deleteFromTrashURL, false, contentId);
        }
        if (response == null) {
            throw new RemotePublishingException("remove remote failed");
        }
    }

    protected List<Page> getRemotePublishedChildren(Page page) {
        ArrayList<Page> remotePublishedChilds = new ArrayList<Page>();
        for (Page child : page.getChildren()) {
            if (!this.remotePageExists(child.getTitle())) continue;
            remotePublishedChilds.add(child);
        }
        return remotePublishedChilds;
    }

    protected boolean remotePageExists(String title) {
        if (this.credentials.isCloudConfluenceEnvironment()) {
            JsonObject response = this.apiAction.httpGetPetition(ConfluenceCloudRestApi.PAGE_CONTENT_EXIST, true, false, String.valueOf(this.credentials.getRemoteSpaceId()), title);
            return response != null && response.get(RESULTS) != null && !response.get(RESULTS).getAsJsonArray().isEmpty();
        }
        JsonObject response = this.apiAction.httpGetPetition(ConfluenceDCRestApi.CONTENT_EXIST, true, false, this.credentials.getRemoteSpaceKey(), title, ConfluenceContentType.PAGE.getContentTypeName());
        return response != null && response.get("size") != null && response.get("size").getAsLong() != 0L;
    }

    protected void reorderParentPagesAfterPageUpdate(Page page) {
        List<Page> remotePublishedChildren = this.getRemotePublishedChildren(page);
        long parentId = this.getRemotePageId(page.getTitle(), ConfluenceContentType.getTypeFromAbstractPage((AbstractPage)page).getContentTypeName());
        if (parentId != 0L) {
            this.reorderPagesInRemote(page, remotePublishedChildren, String.valueOf(parentId));
        }
    }

    protected void reorderPagesInRemote(Page page, List<Page> remotePublishedChildList, String parentId) {
        String lastSortedPageId = null;
        List<Page> sortedPublishedPages = this.getSortedPublishedPages(page, remotePublishedChildList);
        for (Page child : sortedPublishedPages) {
            lastSortedPageId = lastSortedPageId == null ? this.appendPage(child, parentId) : this.putPageBelow(child, lastSortedPageId);
        }
    }

    private String appendPage(Page page, String parentId) {
        String lastSortedPageId = String.valueOf(this.getRemotePageId(page.getTitle(), ConfluenceContentType.getTypeFromAbstractPage((AbstractPage)page).getContentTypeName()));
        String positionInRemote = this.getRemotePosition(page, lastSortedPageId, true, false);
        if (positionInRemote != null && Integer.parseInt(positionInRemote) != page.getParent().getSortedChildren().indexOf(page)) {
            this.moveRemotePage(lastSortedPageId, parentId, POSITION_APPEND);
        }
        return lastSortedPageId;
    }

    private String putPageBelow(Page page, String lastSortedPageId) {
        String pageToMoveId = String.valueOf(this.getRemotePageId(page.getTitle(), ConfluenceContentType.getTypeFromAbstractPage((AbstractPage)page).getContentTypeName()));
        String positionInRemote = this.getRemotePosition(page, pageToMoveId, false, true);
        RemotePageManifest manifest = this.getRemoteContentManifest((AbstractPage)page);
        if (manifest != null && positionInRemote != null && (Integer.parseInt(positionInRemote) != page.getParent().getSortedChildren().indexOf(page) || manifest.getParentTitle() != null && !manifest.getParentTitle().equals(page.getParent().getTitle()))) {
            this.moveRemotePage(pageToMoveId, lastSortedPageId, POSITION_BELOW);
        }
        return pageToMoveId;
    }

    protected void moveRemotePage(String pageToMoveId, String parentId, String position) {
        JsonObject response = this.apiAction.httpPostPetition(this.movePageRequestBody(pageToMoveId, parentId, position), ConfluenceDCRestApi.MOVE_PAGE, true, true);
        if (response == null) {
            log.error("There has been an error moving the page " + pageToMoveId);
        }
    }

    private List<Page> getSortedPublishedPages(Page page, List<Page> remotePublishedChildList) {
        List sortedPublishedPages = page.getSortedChildren();
        for (Page child : page.getSortedChildren()) {
            if (remotePublishedChildList.contains(child)) continue;
            sortedPublishedPages.remove(child);
        }
        return sortedPublishedPages;
    }

    @Override
    public RemotePageManifest getRemoteContentManifest(AbstractPage abstractPage, RemotePageManifest publishHistoryInfo) {
        RemotePageManifest remotePageManifest = null;
        if (publishHistoryInfo != null) {
            long remotePageId;
            String type = ConfluenceContentType.getTypeFromAbstractPage(abstractPage).getContentTypeName();
            remotePageManifest = this.getRemoteContentManifest(publishHistoryInfo.getPageId(), type);
            if (!(remotePageManifest != null && remotePageManifest.getTitle().equals(publishHistoryInfo.getTitle()) || (remotePageId = this.getRemotePageId(publishHistoryInfo.getTitle(), type)) == 0L)) {
                remotePageManifest = this.getRemoteContentManifest(String.valueOf(remotePageId), type);
            }
        }
        if (remotePageManifest == null) {
            remotePageManifest = this.getRemoteContentManifest(abstractPage);
        }
        return remotePageManifest;
    }

    private RemotePageManifest getRemoteContentManifest(AbstractPage absPage) {
        log.debug("Getting content from '" + absPage.getTitle() + "'(" + absPage.getSpaceKey() + ")");
        String type = ConfluenceContentType.getTypeFromAbstractPage(absPage).getContentTypeName();
        return this.getRemoteContentManifest(String.valueOf(this.getRemotePageId(absPage.getTitle(), type)), type);
    }

    protected RemotePageManifest getRemoteContentManifest(String pageId, String type) {
        JsonObject response;
        if (log.isDebugEnabled()) {
            log.debug("Getting content from {} - type {} - isCloud {}", new Object[]{pageId, type, this.credentials.isCloudConfluenceEnvironment()});
        }
        if ((response = this.getRemoteContentResponse(pageId, type)) == null || !response.has("id")) {
            return null;
        }
        RemotePageManifest manifest = this.restModelComponent.generatePageOrBlogManifest(response, this.credentials);
        this.remoteManifestOperationExecutor.addOperation(new LabelManifestOperation(this.apiAction, manifest, this.credentials, type));
        this.remoteManifestOperationExecutor.addOperation(new AttachmentManifestOperation(this.apiAction, manifest, this.credentials, type));
        if (ConfluenceContentType.isPage(type)) {
            this.remoteManifestOperationExecutor.addOperation(new AncestorManifestOperation(this.apiAction, manifest, this.credentials));
        }
        return manifest;
    }

    protected String getRemotePosition(Page page, String lastSortedPageId, boolean appendPage, boolean putPageBelow) {
        JsonObject response = this.getRemoteContentResponse(lastSortedPageId, ConfluenceContentType.PAGE.getContentTypeName());
        String positionInRemote = this.credentials.isCloudConfluenceEnvironment() ? response.get(POSITION).getAsString() : response.get("extensions").getAsJsonObject().get(POSITION).getAsString();
        if (appendPage) {
            return positionInRemote.equals("none") || page.getAncestors() == null ? "-1" : positionInRemote;
        }
        if (putPageBelow) {
            return positionInRemote.equals("none") ? "0" : positionInRemote;
        }
        return null;
    }

    private JsonObject getRemoteContentResponse(String pageId, String type) {
        Enum apiUrlOperation = ConfluenceDCRestApi.CONTENT_INFO;
        if (this.credentials.isCloudConfluenceEnvironment()) {
            apiUrlOperation = ConfluenceContentType.isPage(type) ? ConfluenceCloudRestApi.GET_PAGE : ConfluenceCloudRestApi.GET_BLOGPOST;
        }
        return this.apiAction.httpGetPetition((ConfluenceRestAPI)((Object)apiUrlOperation), true, false, new String[]{pageId});
    }

    protected RemoteAttachmentManifest createRemoteAttachmentManifest(Attachment attachment, JsonObject remoteAttachment) {
        String id = remoteAttachment.get(RESULTS).getAsJsonArray().get(0).getAsJsonObject().get("id").getAsString();
        String fileName = attachment.getFileName();
        String fileSize = String.valueOf(attachment.getFileSize());
        RemoteAttachmentManifest remoteAttachmentManifest = new RemoteAttachmentManifest(id, fileName, 1, Integer.parseInt(fileSize), attachment.getCreationDate(), attachment.getVersionComment(), attachment.getLabels());
        remoteAttachmentManifest.setLocalId(String.valueOf(attachment.getId()));
        return remoteAttachmentManifest;
    }

    protected MultipartEntityBuilder generateAttachmentForUpload(Attachment attachment, byte[] data) {
        MultipartEntityBuilder multiPartEntityBuilder = MultipartEntityBuilder.create();
        multiPartEntityBuilder.addBinaryBody("file", data, ContentType.DEFAULT_BINARY, attachment.getFileName());
        return multiPartEntityBuilder;
    }

    protected List<NameValuePair> movePageRequestBody(String pageId, String targetId, String position) {
        ArrayList<NameValuePair> form = new ArrayList<NameValuePair>();
        form.add((NameValuePair)new BasicNameValuePair("pageId", pageId));
        form.add((NameValuePair)new BasicNameValuePair("targetId", targetId));
        form.add((NameValuePair)new BasicNameValuePair(POSITION, position));
        return form;
    }

    @Override
    public RemotePageManifest updateRemote(AbstractPage absPage, RemotePageManifest manifest) throws RemotePublishingException {
        if (log.isDebugEnabled()) {
            log.debug("Updating: " + absPage);
            log.debug("Current Publishing Info: " + manifest);
        }
        if (absPage instanceof Page) {
            RemotePageManifest updatedManifest = this.updateRemotePage((Page)absPage, manifest);
            if (updatedManifest != null) {
                return updatedManifest;
            }
            throw new RemotePublishingException("update remote page failed");
        }
        if (absPage instanceof BlogPost) {
            RemotePageManifest updatedManifest = this.updateRemoteBlogPost((BlogPost)absPage, manifest);
            if (updatedManifest != null) {
                return updatedManifest;
            }
            throw new RemotePublishingException("update remote blogpost failed");
        }
        return null;
    }

    protected String getRemoteParent(Page page, RemotePageManifest manifest) {
        if (Objects.isNull(page.getParent())) {
            return "0";
        }
        if (!page.getParent().getTitle().equals(manifest.getParentTitle())) {
            long parentId = this.getRemotePageId(page.getParent().getTitle(), ConfluenceContentType.getTypeFromAbstractPage((AbstractPage)page).getContentTypeName());
            if (parentId != 0L) {
                return String.valueOf(parentId);
            }
        } else {
            return manifest.getParentId();
        }
        return "0";
    }

    protected RemotePageManifest updateRemotePage(Page page, RemotePageManifest manifest) {
        String remotePageId = manifest.getPageId();
        String remoteParentPageId = this.getRemoteParent(page, manifest);
        manifest.setParentId(remoteParentPageId);
        JsonObject response = this.updateRemoteContent((AbstractPage)page, remotePageId, manifest);
        if (response == null || !response.has("id")) {
            return null;
        }
        this.updateLabels(remotePageId, page.getLabels(), manifest.getLabels());
        List<Page> remotePublishedChildList = this.getRemotePublishedChildren(page);
        if (!remotePublishedChildList.isEmpty()) {
            this.reorderPagesInRemote(page, remotePublishedChildList, remotePageId);
        }
        if (page.getParent() != null) {
            this.reorderParentPagesAfterPageUpdate(page.getParent());
        }
        return this.restModelComponent.updateRemotePageManifest(page, manifest);
    }

    protected RemotePageManifest updateRemoteBlogPost(BlogPost blog, RemotePageManifest manifest) {
        String remotePageId = manifest.getPageId();
        JsonObject response = this.updateRemoteContent((AbstractPage)blog, remotePageId, manifest);
        if (response == null) {
            return null;
        }
        this.updateLabels(remotePageId, blog.getLabels(), manifest.getLabels());
        return this.restModelComponent.updateRemoteBlogManifest(blog, manifest);
    }

    private JsonObject updateRemoteContent(AbstractPage pageOrBlog, String remotePageId, RemotePageManifest manifest) {
        Enum type = ConfluenceDCRestApi.UPDATE_CONTENT;
        boolean isPage = ConfluenceContentType.isPage(pageOrBlog.getType());
        StringEntity stringEntity = new StringEntity(this.restModelComponent.generateUpdateObject(this.credentials, manifest.getVersion(), pageOrBlog.getTitle(), pageOrBlog.getBodyAsString(), isPage ? "page" : "blogpost", isPage ? manifest.getParentId() : null, pageOrBlog.getContentStatus(), remotePageId, manifest.getSpaceId()).toString(), ContentType.APPLICATION_JSON);
        if (this.credentials.isCloudConfluenceEnvironment()) {
            type = isPage ? ConfluenceCloudRestApi.UPDATE_PAGE : ConfluenceCloudRestApi.UPDATE_BLOGPOST;
        }
        return this.apiAction.httpPutPetition(stringEntity, (ConfluenceRestAPI)((Object)type), new String[]{remotePageId});
    }

    protected void updateLabels(String pageId, List<Label> draftLabels, List<Label> publishedLabels) {
        log.debug("Updating labels of '" + pageId);
        if (draftLabels != null && !draftLabels.isEmpty()) {
            this.addRemoteLabels(pageId, this.getLabelsToAddList(draftLabels, publishedLabels));
        }
        if (publishedLabels != null && !publishedLabels.isEmpty()) {
            this.removeRemoteLabels(pageId, this.getLabelsToRemoveList(draftLabels, publishedLabels));
        }
    }

    private void removeRemoteLabels(String remoteContentId, List<Label> labelsToRemove) throws RemotePublishingException {
        log.debug("Removing labels of '" + remoteContentId);
        if (labelsToRemove.isEmpty()) {
            return;
        }
        for (Label label : labelsToRemove) {
            JsonObject response = this.apiAction.httpDeletePetition(ConfluenceDCRestApi.REMOVE_LABEL, false, remoteContentId, label.getName());
            if (response != null) continue;
            throw new RemotePublishingException("remove labels failed");
        }
    }

    private List<Label> getLabelsToAddList(List<Label> draftLabels, List<Label> publishedLabels) {
        ArrayList<Label> labelsToAdd = new ArrayList<Label>();
        for (Label label : draftLabels) {
            if (publishedLabels.contains(label)) continue;
            labelsToAdd.add(label);
        }
        return labelsToAdd;
    }

    private List<Label> getLabelsToRemoveList(List<Label> draftLabels, List<Label> publishedLabels) {
        ArrayList<Label> labelsToRemove = new ArrayList<Label>();
        for (Label label : this.restModelComponent.filterPersonalLabels(publishedLabels)) {
            if (draftLabels.contains(label)) continue;
            labelsToRemove.add(label);
        }
        return labelsToRemove;
    }

    @Override
    public void updateAttachment(String pageId, Attachment attachment, RemoteAttachmentManifest attachmentManifest, byte[] data) {
        JsonObject response;
        log.debug("Updating attachment " + attachment.getFileName() + " to page with id " + pageId);
        if (attachment.getVersion() != attachmentManifest.getVersion() || attachment.getFileSize() != attachmentManifest.getSize()) {
            response = this.attachmentDataUpdate(attachment, data, pageId, attachmentManifest);
            if (response == null) {
                throw new RemotePublishingException("update attachment data failed");
            }
            attachmentManifest.setVersion(attachment.getVersion() + 1);
            attachmentManifest.setSize(attachment.getFileSize());
        }
        if (!attachment.getFileName().equals(attachmentManifest.getFilename()) || attachment.getVersionComment() != null && !attachment.getVersionComment().equals(attachmentManifest.getComment()) || attachment.getVersionComment() == null && attachmentManifest.getComment() != null) {
            response = this.attachmentFileNameAndCommentUpdate(pageId, attachment, attachmentManifest);
            if (response == null) {
                throw new RemotePublishingException("update attachment properties failed");
            }
            attachmentManifest.setComment(attachment.getVersionComment());
            attachmentManifest.setFilename(attachment.getFileName());
        }
        if (!attachment.getLabels().equals(attachmentManifest.getLabels())) {
            this.updateLabels(attachmentManifest.getId(), attachment.getLabels(), attachmentManifest.getLabels());
            attachmentManifest.setLabels(attachment.getLabels());
        }
        if (attachment.getId() != 0L) {
            attachmentManifest.setLocalId(String.valueOf(attachment.getId()));
        }
    }

    private JsonObject attachmentDataUpdate(Attachment attachment, byte[] data, String pageId, RemoteAttachmentManifest attachmentManifest) {
        return this.apiAction.httpPostPetition(this.generateAttachmentDataUpdateForUpload(attachment, data), (ConfluenceRestAPI)ConfluenceDCRestApi.UPDATE_ATTACHMENT_DATA, true, true, attachment, pageId, attachmentManifest.getId());
    }

    private JsonObject attachmentFileNameAndCommentUpdate(String pageId, Attachment attachment, RemoteAttachmentManifest attachmentManifest) {
        StringEntity stringEntity = new StringEntity(this.generateUpdatesForAttachment(attachment, String.valueOf(attachmentManifest.getVersion()), String.valueOf(attachmentManifest.getId())).toString(), ContentType.APPLICATION_JSON);
        return this.apiAction.httpPutPetition(stringEntity, ConfluenceDCRestApi.UPDATE_ATTACHMENT_PROPERTIES, pageId, String.valueOf(attachmentManifest.getId()));
    }

    protected String generateBlogForCreation(String blogTitle, String pageContent) {
        JsonObject newBlog = new JsonObject();
        newBlog.addProperty("type", "blogpost");
        newBlog.addProperty("title", blogTitle);
        JsonObject spaceObj = new JsonObject();
        spaceObj.addProperty("key", this.credentials.getRemoteSpaceKey());
        newBlog.add("space", (JsonElement)spaceObj);
        JsonObject storageObj = new JsonObject();
        storageObj.addProperty("value", pageContent);
        storageObj.addProperty("representation", "storage");
        JsonObject bodyObj = new JsonObject();
        bodyObj.add("storage", (JsonElement)storageObj);
        newBlog.add("body", (JsonElement)bodyObj);
        return newBlog.toString();
    }

    protected MultipartEntityBuilder generateAttachmentDataUpdateForUpload(Attachment attachment, byte[] data) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addBinaryBody("file", data, ContentType.DEFAULT_BINARY, attachment.getFileName());
        return multipartEntityBuilder;
    }

    protected JsonObject generateUpdatesForAttachment(Attachment attachment, String remoteVersion, String remoteId) {
        JsonObject updatedAttachment = new JsonObject();
        updatedAttachment.addProperty("id", remoteId);
        updatedAttachment.addProperty("title", attachment.getFileName());
        JsonObject version = new JsonObject();
        version.addProperty("number", remoteVersion);
        updatedAttachment.add("version", (JsonElement)version);
        JsonObject metadata = new JsonObject();
        metadata.addProperty("comment", attachment.getVersionComment());
        updatedAttachment.add("metadata", (JsonElement)metadata);
        return updatedAttachment;
    }

    @Override
    public RemoteAttachmentManifest addAttachment(String pageId, Attachment attachment, byte[] data) {
        log.debug("Adding attachment " + attachment.getFileName() + " to page with id " + pageId);
        MultipartEntityBuilder multipartEntityBuilder = this.generateAttachmentForUpload(attachment, data);
        JsonObject response = this.createAttachment(multipartEntityBuilder, pageId, attachment);
        if (response != null && !response.has("statusCode")) {
            RemoteAttachmentManifest attachmentManifest = this.createRemoteAttachmentManifest(attachment, response);
            this.attachmentFileNameAndCommentUpdate(pageId, attachment, attachmentManifest);
            this.addRemoteLabels(attachmentManifest.getId(), attachment.getLabels());
            return attachmentManifest;
        }
        String message = "Check attachment size limit in Confluence's remote instance.";
        if (response != null && response.has("message")) {
            message = response.get("message").getAsString();
        }
        throw new RemotePublishingException("Adding attachment failed: " + attachment.getFileName() + " (" + attachment.getFileSize() + " bytes). " + message);
    }

    private JsonObject createAttachment(MultipartEntityBuilder multipartEntityBuilder, String pageId, Attachment attachment) {
        return this.apiAction.httpPostPetition(multipartEntityBuilder, (ConfluenceRestAPI)ConfluenceDCRestApi.CREATE_ATTACHMENT, true, true, attachment, pageId);
    }

    @Override
    public void deleteAttachment(String attachmentId) {
        log.debug("Deleting attachment {} - env {} ", (Object)attachmentId, (Object)this.credentials.getConfluenceEnvironment());
        JsonObject response = this.apiAction.httpDeletePetition((ConfluenceRestAPI)((Object)(this.credentials.isCloudConfluenceEnvironment() ? ConfluenceCloudRestApi.DELETE_ATTACHMENT : ConfluenceDCRestApi.DELETE_CONTENT)), false, attachmentId);
        if (response == null) {
            throw new RemotePublishingException("delete attachment failed");
        }
    }

    protected JsonObject generateLabelToAdd(Label label) {
        JsonObject labelJson = new JsonObject();
        labelJson.addProperty("prefix", label.getNamespace().getPrefix());
        labelJson.addProperty("name", label.getName());
        return labelJson;
    }
}

