/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.applink;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.applinks.api.application.confluence.ConfluenceSpaceEntityType;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.remotepublishing.applink.AppLinkService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class ConfluenceAppLinkService
implements AppLinkService {
    private final ApplicationLinkService applicationLinkService;
    private final EntityLinkService entityLinkService;
    private final SpaceManager spaceManager;

    public ConfluenceAppLinkService(ApplicationLinkService applicationLinkService, EntityLinkService entityLinkService, SpaceManager spaceManager) {
        this.applicationLinkService = applicationLinkService;
        this.entityLinkService = entityLinkService;
        this.spaceManager = spaceManager;
    }

    @Override
    public List<ApplicationLink> getAppConnections() {
        ArrayList<ApplicationLink> applicationLinkList = new ArrayList<ApplicationLink>();
        this.applicationLinkService.getApplicationLinks(ConfluenceApplicationType.class).forEach(applicationLinkList::add);
        return applicationLinkList;
    }

    @Override
    public ApplicationLink getAppConnection(String appLinkID) {
        return this.getAppConnections().stream().filter(applicationLink -> applicationLink.getId().get().equals(appLinkID)).findFirst().orElse(null);
    }

    @Override
    public EntityLink getEntityLinkForSpaceAndKey(String spaceKey, String entityLinkKey) {
        ArrayList entityList = Lists.newArrayList(this.getEntityLinks(this.spaceManager.getSpace(spaceKey)));
        return entityList.stream().filter(entityLink -> entityLink.getKey().equals(entityLinkKey)).findFirst().orElse(null);
    }

    @Override
    public EntityLink getPrimaryEntityLink(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.entityLinkService.getPrimaryEntityLink((Object)space, ConfluenceSpaceEntityType.class);
    }

    @Override
    public List<EntityLink> getSpaceEntityLinks(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        return Lists.newArrayList(this.getEntityLinks(space));
    }

    private Iterable<EntityLink> getEntityLinks(Space space) {
        return this.entityLinkService.getEntityLinks((Object)space, ConfluenceSpaceEntityType.class);
    }
}

