/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.utils;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.license.DefaultRemotePublishingLicenseManager;
import com.comalatech.confluence.remotepublishing.utils.EncryptableConfig;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.stream.Stream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESEncrypter
implements EncryptableConfig {
    private static final Logger log = LoggerFactory.getLogger(AESEncrypter.class);
    private static final Integer KEY_256 = 256;
    private static final Integer DEFAULT_KEYS_SIZE = 128;
    private static final String ALGORITHM = "AES";
    private static final String SECRET_FACTORY = "PBKDF2WithHmacSHA256";
    private static final Integer ITERATION_COUNT = 65536;
    private final String SALT_KEY;
    private final String ENCRYPT_KEY;
    private final byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final IvParameterSpec ivspec = new IvParameterSpec(this.iv);

    public AESEncrypter(DefaultRemotePublishingLicenseManager licenseManager, SystemInformationService systemInformationService) {
        this.SALT_KEY = licenseManager.getPluginKey();
        this.ENCRYPT_KEY = systemInformationService.getConfluenceInfo().getServerId();
    }

    @Override
    public RemotePublishingConfiguration encryptRemotePublishingConfiguration(RemotePublishingConfiguration config) {
        RemotePublishingConfiguration encryptConfig = new RemotePublishingConfiguration();
        encryptConfig.setName(config.getName());
        encryptConfig.setCredentials(config.getCredentials());
        if (config.getCredentials() != null) {
            String loginUserName = config.getCredentials().getLoginUserName();
            String password = config.getCredentials().getPassword();
            String remoteUser = config.getCredentials().getRemoteUserName();
            if (Stream.of(loginUserName, password, remoteUser).noneMatch(StringUtils::isBlank)) {
                String encryptedLoginUserName = this.encrypt(loginUserName);
                String encryptedPassword = this.encrypt(password);
                String encryptedRemoteUser = this.encrypt(remoteUser);
                encryptConfig.getCredentials().setLoginUserName(encryptedLoginUserName);
                encryptConfig.getCredentials().setPassword(encryptedPassword);
                encryptConfig.getCredentials().setRemoteUserName(encryptedRemoteUser);
            } else {
                throw new RemotePublishingException("The configuration credentials can't be empty");
            }
        }
        return encryptConfig;
    }

    @Override
    public RemotePublishingConfiguration decryptRemotePublishingConfiguration(RemotePublishingConfiguration encryptedConfig) {
        RemotePublishingConfiguration decryptConfig = new RemotePublishingConfiguration();
        decryptConfig.setName(encryptedConfig.getName());
        decryptConfig.setCredentials(encryptedConfig.getCredentials());
        if (encryptedConfig.getCredentials() != null) {
            String encryptedLoginUserName = encryptedConfig.getCredentials().getLoginUserName();
            String encryptedPassword = encryptedConfig.getCredentials().getPassword();
            String encryptedRemoteUser = encryptedConfig.getCredentials().getRemoteUserName();
            String decryptedLoginUserName = this.decrypt(encryptedLoginUserName);
            String decryptedPassword = this.decrypt(encryptedPassword);
            String decryptedRemoteUser = this.decrypt(encryptedRemoteUser);
            if (Stream.of(decryptedLoginUserName, decryptedPassword, decryptedRemoteUser).noneMatch(StringUtils::isBlank)) {
                decryptConfig.getCredentials().setLoginUserName(decryptedLoginUserName);
                decryptConfig.getCredentials().setPassword(decryptedPassword);
                decryptConfig.getCredentials().setRemoteUserName(decryptedRemoteUser);
            } else {
                throw new RemotePublishingException("The configuration could not be decrypted");
            }
        }
        return decryptConfig;
    }

    public String encrypt(String strToEncrypt) {
        try {
            SecretKeySpec secretKey = this.prepareKeysSpec(DEFAULT_KEYS_SIZE);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)secretKey, this.ivspec);
            return Base64.getEncoder().encodeToString(cipher.doFinal(strToEncrypt.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RemotePublishingException("Error while encrypting one of the credentials", e);
        }
    }

    public String decrypt(String strToDecrypt) {
        try {
            SecretKeySpec secretKey = this.prepareKeysSpec(DEFAULT_KEYS_SIZE);
            return this.getDecodedKey(strToDecrypt, secretKey);
        }
        catch (IllegalArgumentException | IllegalBlockSizeException e) {
            return strToDecrypt;
        }
        catch (BadPaddingException badPadding) {
            try {
                SecretKeySpec secretKey256 = this.prepareKeysSpec(KEY_256);
                return this.getDecodedKey(strToDecrypt, secretKey256);
            }
            catch (BadPaddingException badKey) {
                log.error("Bad padding after trying to decrypt 256 key", (Throwable)badKey);
                return "";
            }
            catch (Exception e) {
                throw new RemotePublishingException("Error while decrypting one of the credentials", e);
            }
        }
        catch (Exception e) {
            throw new RemotePublishingException("Error while decrypting one of the credentials", e);
        }
    }

    public SecretKeySpec prepareKeysSpec(Integer keySize) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(SECRET_FACTORY);
        PBEKeySpec spec = new PBEKeySpec(this.ENCRYPT_KEY.toCharArray(), this.SALT_KEY.getBytes(), ITERATION_COUNT, keySize);
        SecretKey tmp = factory.generateSecret(spec);
        return new SecretKeySpec(tmp.getEncoded(), ALGORITHM);
    }

    public String getDecodedKey(String strToDecrypt, SecretKeySpec secretKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)secretKey, this.ivspec);
        return new String(cipher.doFinal(Base64.getDecoder().decode(strToDecrypt)));
    }
}

