/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.comalatech.confluence.remotepublishing.PublishHistoryManager;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.RemotePublishingManager;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.confluence.ConfluenceRestRemotePublisher;
import com.comalatech.confluence.remotepublishing.credentials.Credentials;
import com.comalatech.confluence.remotepublishing.diagrams.DiagramProcessor;
import com.comalatech.confluence.remotepublishing.diagrams.DrawIoProcessor;
import com.comalatech.confluence.remotepublishing.model.PublishHistoryInfo;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.enums.ConfluenceContentType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemotePublishingManager
implements RemotePublishingManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultRemotePublishingManager.class);
    private static final String DRAW_IO_MACRO_NAME = "drawio";
    private static final String DRAW_IO_TAG = "ac:name=\"drawio\"";
    private final AttachmentManager attachmentManager;
    private final PublishHistoryManager publishHistoryManager;
    private final XhtmlContent xhtmlContent;
    private final ConfluenceRestRemotePublisher confluenceRestRemotePublisher;

    public DefaultRemotePublishingManager(AttachmentManager attachmentManager, PublishHistoryManager publishHistoryManager, XhtmlContent xhtmlContent, ConfluenceRestRemotePublisher confluenceRestRemotePublisher) {
        this.attachmentManager = attachmentManager;
        this.publishHistoryManager = publishHistoryManager;
        this.xhtmlContent = xhtmlContent;
        this.confluenceRestRemotePublisher = confluenceRestRemotePublisher;
    }

    @Override
    public void unpublish(RemotePublishingConfiguration config, AbstractPage page, boolean purgeFromTrash) throws RemotePublishingException {
        log.debug("Unpublishing '" + page.getTitle() + "'(" + page.getSpaceKey() + ") " + purgeFromTrash);
        this.validateCredentialsAndSetDefaults(config);
        this.confluenceRestRemotePublisher.setCredentials(config, page.getSpaceKey());
        try {
            this.confluenceRestRemotePublisher.doLogin();
            RemotePageManifest manifest = this.getPreviousPublishPageManifest(page, config.getName(), config.getCredentials());
            if (manifest != null) {
                if (ConfluenceContentType.isPage(page.getType())) {
                    this.confluenceRestRemotePublisher.removeRemotePage(manifest.getPageId(), purgeFromTrash);
                } else {
                    this.confluenceRestRemotePublisher.removeRemoteBlogpost(manifest.getPageId(), purgeFromTrash);
                }
            }
        }
        catch (Exception e) {
            throw new RemotePublishingException("unpublishing error", e);
        }
        finally {
            try {
                this.confluenceRestRemotePublisher.doLogout();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void validateCredentialsAndSetDefaults(RemotePublishingConfiguration config) {
        if (config.getCredentials().getRemoteUserName() == null) {
            config.getCredentials().setRemoteUserName(AuthenticatedUserThreadLocal.getUsername());
        }
        try {
            config.getCredentials().validate();
        }
        catch (Exception e) {
            throw new RemotePublishingException("Invalid publishing credentials: " + e.getMessage());
        }
    }

    @Override
    public void publish(RemotePublishingConfiguration config, AbstractPage absPage) throws RemotePublishingException {
        log.debug("Publishing page or blogpost '" + absPage.getTitle() + "'(" + absPage.getSpaceKey() + ")");
        log.debug("Credentials: " + config.getCredentials());
        this.validateCredentialsAndSetDefaults(config);
        this.confluenceRestRemotePublisher.setCredentials(config, absPage.getSpaceKey());
        try {
            this.confluenceRestRemotePublisher.doLogin();
            RemotePageManifest manifest = this.getValidManifest(absPage, config.getName(), config.getCredentials());
            if (manifest != null) {
                String bodyContent = absPage.getBodyAsString();
                if (this.isDiagramMacro(bodyContent, body -> body.contains(DRAW_IO_TAG)) && this.getDiagramProcessor().isPresent()) {
                    String diagramBodyContent = ((DrawIoProcessor)this.getDiagramProcessor().get()).updateDrawIODiagramBodyContent(absPage, manifest);
                    absPage.setBodyAsString(diagramBodyContent);
                    manifest = this.confluenceRestRemotePublisher.updateRemote(absPage, manifest);
                    absPage.setBodyAsString(bodyContent);
                } else {
                    manifest = this.confluenceRestRemotePublisher.updateRemote(absPage, manifest);
                }
            } else {
                manifest = this.confluenceRestRemotePublisher.createRemote(absPage);
            }
            this.publishAttachments(manifest, this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)absPage));
            PublishHistoryInfo publishInfo = new PublishHistoryInfo(manifest, config.getCredentials().getUrl());
            this.publishHistoryManager.addPublishHistoryInfo(absPage, config.getName(), publishInfo);
        }
        catch (Exception e) {
            throw new RemotePublishingException("There was an error while publishing content", e);
        }
        finally {
            try {
                this.confluenceRestRemotePublisher.doLogout();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private RemotePageManifest getValidManifest(AbstractPage absPage, String configName, Credentials credentials) {
        RemotePageManifest manifest = this.getPreviousPublishPageManifest(absPage, configName, credentials);
        RemotePageManifest remoteManifest = this.confluenceRestRemotePublisher.getRemoteContentManifest(absPage, manifest);
        if (remoteManifest == null) {
            return null;
        }
        if (manifest == null || manifest.getSpaceId() == null || !manifest.equals(remoteManifest)) {
            List<RemoteAttachmentManifest> localAttachments;
            if (manifest != null && Objects.nonNull(localAttachments = manifest.getAttachments()) && Objects.nonNull(remoteManifest.getAttachments())) {
                for (RemoteAttachmentManifest remoteAttachmentManifest : remoteManifest.getAttachments()) {
                    localAttachments.stream().filter(localManifest -> localManifest.getId().equals(remoteAttachmentManifest.getId())).findFirst().ifPresent(attachmentManifest -> remoteAttachmentManifest.setLocalId(attachmentManifest.getLocalId()));
                }
            }
            return remoteManifest;
        }
        return manifest;
    }

    private RemotePageManifest getPreviousPublishPageManifest(AbstractPage page, String configName, Credentials credentials) {
        PublishHistoryInfo publishHistoryInfo;
        if ((page instanceof Page || page instanceof BlogPost) && (publishHistoryInfo = this.publishHistoryManager.getLatestPublishHistoryInfo(page, configName)) != null && StringUtils.equals((CharSequence)credentials.getRemoteSpaceKey(), (CharSequence)publishHistoryInfo.getPage().getSpaceKey())) {
            return publishHistoryInfo.getPage();
        }
        return null;
    }

    private void publishAttachments(RemotePageManifest pageManifest, List<Attachment> attachments) throws RemotePublishingException, IOException {
        log.debug("Publishing attachments for absPage '" + pageManifest.getTitle() + "'(" + pageManifest.getSpaceKey() + ")");
        this.updateOrAddAttachments(pageManifest, attachments);
        this.removeRemoteAttachments(pageManifest, attachments);
    }

    private void removeRemoteAttachments(RemotePageManifest pageManifest, List<Attachment> attachments) throws RemotePublishingException {
        ArrayList<RemoteAttachmentManifest> attachmentsToRemove = new ArrayList<RemoteAttachmentManifest>();
        List<RemoteAttachmentManifest> pageManifestAttachments = pageManifest.getAttachments();
        if (Objects.isNull(pageManifestAttachments)) {
            return;
        }
        for (RemoteAttachmentManifest remoteAttachment : pageManifestAttachments) {
            Optional<Attachment> currentAttachment = attachments.stream().filter(attachment -> attachment.getFileName().equals(remoteAttachment.getFilename())).findFirst();
            if (currentAttachment.isPresent()) continue;
            this.confluenceRestRemotePublisher.deleteAttachment(remoteAttachment.getId());
            attachmentsToRemove.add(remoteAttachment);
        }
        pageManifestAttachments.removeAll(attachmentsToRemove);
    }

    private void updateOrAddAttachments(RemotePageManifest pageManifest, List<Attachment> attachments) throws IOException, RemotePublishingException {
        for (Attachment currentAttachment : attachments) {
            RemoteAttachmentManifest remoteAttachment = pageManifest.getAttachments().stream().filter(remoteAttachmentManifest -> currentAttachment.getIdAsString().equals(remoteAttachmentManifest.getLocalId())).findFirst().orElse(null);
            if (remoteAttachment == null) {
                remoteAttachment = pageManifest.getAttachments().stream().filter(remoteAttachmentManifest -> currentAttachment.getFileName().equals(remoteAttachmentManifest.getFilename())).findFirst().orElse(null);
            }
            if (remoteAttachment != null) {
                remoteAttachment.setLocalId(currentAttachment.getIdAsString());
                if (remoteAttachment.equalsAttachment(currentAttachment)) continue;
                this.confluenceRestRemotePublisher.updateAttachment(pageManifest.getPageId(), currentAttachment, remoteAttachment, this.getAttachmentData(currentAttachment));
                continue;
            }
            RemoteAttachmentManifest remoteAttachmentManifest2 = this.confluenceRestRemotePublisher.addAttachment(pageManifest.getPageId(), currentAttachment, this.getAttachmentData(currentAttachment));
            pageManifest.addAttachment(remoteAttachmentManifest2);
        }
    }

    private byte[] getAttachmentData(Attachment attachment) throws IOException {
        int len;
        InputStream is;
        byte[] data = new byte[(int)attachment.getFileSize()];
        try {
            is = this.attachmentManager.getAttachmentData(attachment);
        }
        catch (Exception e) {
            throw new IOException();
        }
        if (is == null) {
            throw new IOException();
        }
        int offset = 0;
        while ((len = is.available()) > 0) {
            int read = is.read(data, offset, len);
            offset += read;
        }
        return data;
    }

    @Override
    public void checkCredentials(RemotePublishingConfiguration config, String spaceKey) {
        try {
            this.confluenceRestRemotePublisher.setCredentials(config, spaceKey);
        }
        catch (Exception e) {
            throw new RemotePublishingException("Invalid publishing credentials: check your configuration.");
        }
        this.confluenceRestRemotePublisher.doLogin();
        try {
            this.confluenceRestRemotePublisher.doLogout();
        }
        catch (Exception e) {
            log.error(config.getCredentials().toString(), (Throwable)e);
        }
        this.confluenceRestRemotePublisher.checkRemoteSpace();
        this.confluenceRestRemotePublisher.checkRemoteSpacePermissions();
    }

    private Optional<DiagramProcessor> getDiagramProcessor() {
        if (StringUtils.containsIgnoreCase((CharSequence)DRAW_IO_TAG, (CharSequence)DRAW_IO_MACRO_NAME)) {
            return Optional.of(new DrawIoProcessor(this.attachmentManager, this.xhtmlContent));
        }
        return Optional.empty();
    }

    private boolean isDiagramMacro(String body, Predicate<String> macroCheck) {
        if (body == null) {
            return false;
        }
        return macroCheck.test(body);
    }
}

