/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.license;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.comalatech.confluence.remotepublishing.license.RemotePublishingLicenseManager;
import java.io.Serializable;
import java.util.Map;

public class DefaultRemotePublishingLicenseManager
implements RemotePublishingLicenseManager {
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager licenseManager;
    private static final String LICENSE_MSG_TEMPLATE = "templates/licenseMessage.vm";

    public DefaultRemotePublishingLicenseManager(I18nResolver i18nResolver, PluginLicenseManager licenseManager) {
        this.i18nResolver = i18nResolver;
        this.licenseManager = licenseManager;
    }

    @Override
    public boolean isLicensed() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            return !pluginLicense.getError().isDefined();
        }
        return false;
    }

    @Override
    public Option<PluginLicense> getLicense() {
        return this.licenseManager.getLicense();
    }

    @Override
    public String getLicenseMessage() {
        String licenseMessage;
        Option<PluginLicense> license = this.getLicense();
        if (license.isDefined()) {
            String validityText = ((PluginLicense)license.get()).isValid() ? "valid" : "invalid";
            String typeText = ((PluginLicense)license.get()).isEvaluation() ? "eval" : "noneval";
            String statusKey = "plugin.license.storage.admin.license.attribute.status." + validityText + "." + typeText;
            String licenseTypeKey = "plugin.license.storage.admin.license.type." + ((PluginLicense)license.get()).getLicenseType().name();
            if (((PluginLicense)license.get()).getError().isDefined()) {
                String errorKey = "plugin.license.storage.admin.license.error." + ((LicenseError)((PluginLicense)license.get()).getError().get()).name();
                licenseMessage = this.i18nResolver.getText(statusKey, new Serializable[]{this.i18nResolver.getText(licenseTypeKey), this.i18nResolver.getText(errorKey)});
            } else {
                licenseMessage = this.i18nResolver.getText(statusKey, new Serializable[]{this.i18nResolver.getText(licenseTypeKey)});
            }
        } else {
            licenseMessage = this.i18nResolver.getText("plugin.license.storage.admin.license.attribute.status.unlicensed");
        }
        return licenseMessage;
    }

    @Override
    public String getLicenseErrorMessageHtml() {
        if (!this.isLicensed()) {
            Map contextMap = MacroUtils.defaultVelocityContext();
            contextMap.put("i18nResolver", this.i18nResolver);
            contextMap.put("licenseMessage", this.getLicenseMessage());
            return VelocityUtils.getRenderedTemplate((String)LICENSE_MSG_TEMPLATE, (Map)contextMap);
        }
        return "";
    }

    @Override
    public String getPluginKey() {
        return this.licenseManager.getPluginKey();
    }
}

