/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.config;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseProtocolException;
import com.atlassian.sal.api.net.ResponseTransportException;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.RemotePublishingManager;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfigurationManager;
import com.comalatech.confluence.remotepublishing.credentials.Credentials;
import com.comalatech.confluence.remotepublishing.license.RemotePublishingLicenseManager;
import com.opensymphony.util.TextUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceConfigurationAction
extends SpaceAdminAction {
    private static final Logger log = LoggerFactory.getLogger(SpaceConfigurationAction.class);
    private RemotePublishingConfigurationManager remotePublishingConfigurationManager;
    private RemotePublishingManager remotePublishingManager;
    private RemotePublishingLicenseManager licenseManager;
    private RequestFactory<?> requestFactory;
    private String configurationName;
    private String configurationUrl;
    private String configurationUser;
    private String configurationPassword;
    private String configurationSpace;
    private String testConfigName;
    private String testErrorMessage;
    private String editConfigName;

    @ReadOnlyAccessAllowed
    public String viewSpaceConfiguration() {
        return "success";
    }

    public String removeSpaceConfiguration() {
        this.remotePublishingConfigurationManager.removeSpaceConfiguration(this.getSpaceKey(), this.configurationName);
        return "success";
    }

    public String addSpaceConfiguration() {
        if (!this.validateNewConfigurationParameters()) {
            return "input";
        }
        Credentials credentials = new Credentials(this.configurationUrl, this.configurationUser, this.configurationPassword, this.configurationSpace, this.configurationUser);
        RemotePublishingConfiguration config = new RemotePublishingConfiguration(this.configurationName, credentials);
        try {
            this.remotePublishingConfigurationManager.putSpaceConfiguration(this.getSpaceKey(), config);
            return "success";
        }
        catch (Exception e) {
            log.error(e.getMessage(), e.getCause() != null ? e.getCause() : e);
            this.addFieldError("unexpectedError", e.getMessage());
            return "input";
        }
    }

    @ReadOnlyAccessAllowed
    public String testSpaceConfiguration() {
        String spaceKey = this.getSpaceKey();
        RemotePublishingConfiguration config = this.remotePublishingConfigurationManager.getSpaceConfiguration(spaceKey, this.testConfigName);
        if (config != null) {
            try {
                this.checkUrl(config);
                this.remotePublishingManager.checkCredentials(config, spaceKey);
            }
            catch (ResponseProtocolException | ResponseTransportException e) {
                this.testErrorMessage = this.getText("remotepublishing.space.config.test.malformedUrl", new Object[]{config.getCredentials().getUrl(), e.getMessage()});
                log.error(this.testErrorMessage, e.getCause() != null ? e.getCause() : e);
            }
            catch (ResponseException e) {
                this.testErrorMessage = this.getText("remotepublishing.space.config.test.urlCannotConnect", new Object[]{config.getCredentials().getUrl(), e.getMessage()});
                log.error(this.testErrorMessage, e.getCause() != null ? e.getCause() : e);
            }
            catch (RemotePublishingException e) {
                this.testErrorMessage = e.getMessage();
                log.error(this.testErrorMessage, e.getCause() != null ? e.getCause() : e);
            }
        }
        return "success";
    }

    private void checkUrl(RemotePublishingConfiguration config) throws ResponseException {
        Request request = this.requestFactory.createRequest(Request.MethodType.HEAD, config.getCredentials().getUrl());
        request.execute(response -> log.info("CheckUrl response {}", (Object)response));
    }

    protected boolean validateNewConfigurationParameters() {
        if (!TextUtils.stringSet((String)this.configurationName)) {
            this.addFieldError("configurationName", this.getText("remotepublishing.space.config.name.emptyError"));
        } else {
            this.configurationName = this.configurationName.trim();
            if (this.configurationName.contains(" ")) {
                this.addFieldError("configurationName", this.getText("remotepublishing.space.config.name.containsSpacesError"));
            }
        }
        if (!TextUtils.stringSet((String)this.configurationUrl)) {
            this.addFieldError("configurationUrl", this.getText("remotepublishing.space.config.url.emptyError"));
        }
        if (!TextUtils.stringSet((String)this.configurationUser)) {
            this.addFieldError("configurationUser", this.getText("remotepublishing.space.config.user.emptyError"));
        }
        if (!TextUtils.stringSet((String)this.configurationPassword)) {
            this.addFieldError("configurationPassword", this.getText("remotepublishing.space.config.password.emptyError"));
        }
        return !this.hasActionErrors() && !this.hasFieldErrors();
    }

    public void setRemotePublishingConfigurationManager(RemotePublishingConfigurationManager remotePublishingConfigurationManager) {
        this.remotePublishingConfigurationManager = remotePublishingConfigurationManager;
    }

    public List<RemotePublishingConfiguration> getConfigurations() {
        return this.remotePublishingConfigurationManager.getSpaceConfigurations(this.getSpaceKey());
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    @ParameterSafe
    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getConfigurationUrl() {
        return this.configurationUrl;
    }

    @ParameterSafe
    public void setConfigurationUrl(String configurationUrl) {
        this.configurationUrl = configurationUrl;
    }

    public String getConfigurationUser() {
        return this.configurationUser;
    }

    @ParameterSafe
    public void setConfigurationUser(String configurationUser) {
        this.configurationUser = configurationUser;
    }

    public String getConfigurationPassword() {
        return this.configurationPassword;
    }

    @ParameterSafe
    public void setConfigurationPassword(String configurationPassword) {
        this.configurationPassword = configurationPassword;
    }

    public String getConfigurationSpace() {
        return this.configurationSpace;
    }

    @ParameterSafe
    public void setConfigurationSpace(String configurationSpace) {
        this.configurationSpace = configurationSpace;
    }

    public RemotePublishingManager getRemotePublishingManager() {
        return this.remotePublishingManager;
    }

    public void setRemotePublishingManager(RemotePublishingManager remotePublishingManager) {
        this.remotePublishingManager = remotePublishingManager;
    }

    public String getTestConfigName() {
        return this.testConfigName;
    }

    @ParameterSafe
    public void setTestConfigName(String testConfigName) {
        this.testConfigName = testConfigName;
    }

    public String getTestErrorMessage() {
        return this.testErrorMessage;
    }

    public String getEditConfigName() {
        return this.editConfigName;
    }

    @ParameterSafe
    public void setEditConfigName(String editConfigName) {
        this.editConfigName = editConfigName;
    }

    public RemotePublishingLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(RemotePublishingLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setRequestFactory(RequestFactory<?> requestFactory) {
        this.requestFactory = requestFactory;
    }
}

