/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Attachment;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAttachmentManifest
implements Comparable {
    private static final Logger log = LoggerFactory.getLogger(RemoteAttachmentManifest.class);
    private String id;
    private String localId;
    private String filename;
    private int version;
    private long size;
    private List<Label> labels;
    private String comment;
    private Date createdDate;

    public RemoteAttachmentManifest() {
    }

    public RemoteAttachmentManifest(String id, String filename, int version, long size, Date createdDate, String comment, List<Label> labels) {
        this.id = id;
        this.filename = filename;
        this.version = version;
        this.size = size;
        this.createdDate = createdDate;
        this.comment = comment;
        this.labels = labels;
    }

    public int compareTo(Object o) {
        if (o instanceof RemoteAttachmentManifest) {
            RemoteAttachmentManifest manifest = (RemoteAttachmentManifest)o;
            return this.filename.compareTo(manifest.filename);
        }
        if (o instanceof String) {
            return this.filename.compareTo((String)o);
        }
        return -1;
    }

    public String getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getVersion() {
        return this.version;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public boolean equalsAttachment(Attachment attachment) {
        log.debug("Remote attachment filename: " + this.getFilename() + " Local attachment filename: " + attachment.getFileName());
        log.debug("Remote attachment size: " + this.getSize() + " Local attachment size: " + attachment.getFileSize());
        log.debug("Remote attachment version: " + this.getVersion() + " Local attachment version: " + attachment.getVersion());
        log.debug("Remote attachment creation date: " + this.getCreatedDate() + " Local attachment creation date: " + attachment.getCreationDate());
        return this.getFilename().equals(attachment.getFileName()) && this.getSize() == attachment.getFileSize() && this.getVersion() == attachment.getVersion() && this.getCreatedDate().after(attachment.getCreationDate()) && this.hasSameLabels(attachment) && Objects.equals(this.getComment(), attachment.getVersionComment());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteAttachmentManifest that = (RemoteAttachmentManifest)o;
        return this.id.equals(that.id) && this.version == that.version && Objects.equals(this.filename, that.filename) && this.size == that.size && Objects.equals(this.comment, that.comment) && Objects.equals(this.labels, that.labels);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.filename, this.version, this.size, this.comment, this.labels);
    }

    private boolean hasSameLabels(Attachment attachment) {
        List localLabels = attachment.getLabels();
        List<Label> remoteLabels = this.getLabels();
        if (localLabels == null && remoteLabels == null || localLabels == null && remoteLabels.isEmpty() || remoteLabels == null && localLabels.isEmpty()) {
            return true;
        }
        return localLabels != null && localLabels.equals(remoteLabels);
    }
}

