/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.diagrams;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DiagramProcessor {
    public void setAttachmentMacroVersion(AbstractPage var1, RemotePageManifest var2, MacroDefinition var3, AttachmentManager var4);

    default public void setAttachmentMacroVersion(AbstractPage source, RemotePageManifest destination, String macroAttachmentName, String versionParamName, MacroDefinition macroDefinition, AttachmentManager attachmentManager) {
        Logger log = LoggerFactory.getLogger(DiagramProcessor.class);
        Map typedParameters = macroDefinition.getTypedParameters();
        Map parameters = macroDefinition.getParameters();
        try {
            String attachmentName = (String)typedParameters.get(macroAttachmentName);
            Attachment sourceAttachment = attachmentManager.getAttachment((ContentEntityObject)source, attachmentName);
            RemoteAttachmentManifest destinationAttachment = destination.getAttachment(attachmentName);
            if (null == destinationAttachment) {
                typedParameters.put(versionParamName, 1);
                parameters.put(versionParamName, "1");
            } else if (sourceAttachment.getVersion() != destinationAttachment.getVersion()) {
                typedParameters.put(versionParamName, destinationAttachment.getVersion() + 1);
                parameters.put(versionParamName, destinationAttachment.getVersion() + 1 + "");
            }
        }
        catch (Exception e) {
            log.debug("Something wrong with attachment related macro:{}", (Object)parameters);
            log.debug("{}", (Object)e.getMessage());
        }
        macroDefinition.setTypedParameters(typedParameters);
        macroDefinition.setParameters(parameters);
    }
}

