/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.credentials;

import com.opensymphony.util.TextUtils;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Credentials
implements Cloneable {
    private String url;
    private String loginUserName;
    private String password;
    private String remoteSpaceKey;
    private String remoteUserName;
    private Long remoteSpaceId;

    public Credentials() {
    }

    public Credentials(String url, String loginUserName, String password, String remoteSpaceKey, String remoteUserName) {
        this.url = url;
        this.loginUserName = loginUserName;
        this.password = password;
        this.remoteSpaceKey = remoteSpaceKey;
        this.remoteUserName = remoteUserName;
    }

    public Credentials(Map<String, Object> map) {
        this.url = (String)map.get("url");
        this.loginUserName = (String)map.get("user");
        this.password = (String)map.get("password");
        this.remoteSpaceKey = (String)map.get("space");
        this.remoteUserName = (String)map.get("remoteuser");
        this.remoteSpaceId = (Long)map.get("remoteSpaceId");
    }

    public boolean needsRemoteSpaceId() {
        return this.isCloudConfluenceEnvironment() && null == this.remoteSpaceId;
    }

    public void validate() throws Exception {
        this.validate(this.url, "url");
        this.validate(this.loginUserName, "user");
        this.validate(this.password, "password");
        this.validate(this.remoteSpaceKey, "space");
        this.validate(this.remoteUserName, "remoteuser");
    }

    public void override(Map parameters) {
        Long remoteSpaceId;
        String value = (String)parameters.get("url");
        if (value != null) {
            this.url = value;
        }
        if ((value = (String)parameters.get("user")) != null) {
            this.loginUserName = value;
        }
        if ((value = (String)parameters.get("password")) != null) {
            this.password = value;
        }
        if ((value = (String)parameters.get("space")) != null) {
            this.remoteSpaceKey = value;
        }
        if ((value = (String)parameters.get("remoteuser")) != null) {
            this.remoteUserName = value;
        }
        if (!TextUtils.stringSet((String)this.remoteUserName)) {
            this.remoteUserName = this.loginUserName;
        }
        if ((remoteSpaceId = (Long)parameters.get("remoteSpaceId")) != null) {
            this.remoteSpaceId = remoteSpaceId;
        }
    }

    private void validate(String value, String name) throws Exception {
        if (!TextUtils.stringSet((String)value)) {
            throw new Exception(name + " not set");
        }
    }

    public String getConfluenceEnvironment() {
        String regex = "ATATT3xFfGF0.*=.{8}";
        Matcher matcher = Pattern.compile(regex).matcher(this.password);
        return matcher.matches() ? "cloud" : "server";
    }

    public boolean isCloudConfluenceEnvironment() {
        return "cloud".equalsIgnoreCase(this.getConfluenceEnvironment());
    }

    public void setLoginUserName(String loginUserName) {
        this.loginUserName = loginUserName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRemoteUserName(String remoteUserName) {
        this.remoteUserName = remoteUserName;
    }

    public void setRemoteSpaceId(long remoteSpaceId) {
        this.remoteSpaceId = remoteSpaceId;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        try {
            Credentials clone = (Credentials)this.clone();
            clone.setPassword("*****");
            return ToStringBuilder.reflectionToString((Object)clone);
        }
        catch (CloneNotSupportedException e) {
            return "Credentials(" + this.url + "," + this.loginUserName + ")";
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getLoginUserName() {
        return this.loginUserName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRemoteSpaceKey() {
        return this.remoteSpaceKey;
    }

    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    public Long getRemoteSpaceId() {
        return this.remoteSpaceId;
    }
}

