/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.utils;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.RequestFilePart;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.comalatech.confluence.remotepublishing.credentials.Credentials;
import com.comalatech.confluence.remotepublishing.utils.RestApiAction;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedRestApiAction
implements ApiAction {
    private static final Logger log = LoggerFactory.getLogger(ProxiedRestApiAction.class);
    private final RequestFactory<?> requestFactory;
    private String hostUrl = "";
    private Credentials credentials;
    private String atlassianToken = null;
    private final AttachmentManager attachmentManager;

    public ProxiedRestApiAction(RequestFactory<?> requestFactory, AttachmentManager attachmentManager) {
        this.requestFactory = requestFactory;
        this.attachmentManager = attachmentManager;
    }

    @Override
    public void setRemoteCredentials(Credentials credentials) {
        this.credentials = credentials;
        this.hostUrl = credentials.getUrl();
    }

    @Override
    public JsonObject httpGetPetition(RestApiAction petitionType, boolean getJson, boolean useToken, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doGetRequest(formattedUrl, getJson, useToken);
    }

    @Override
    public JsonObject httpGetPetition(String url, boolean getJson, boolean useToken, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(url, urlParameters);
        return this.doGetRequest(formattedUrl, getJson, useToken);
    }

    @Override
    public JsonObject httpPostPetition(RestApiAction petitionType, boolean getJson, boolean removeAtlassianTokenCheck, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doPostRequest(formattedUrl, getJson, null, null, null);
    }

    @Override
    public JsonObject httpPostPetition(StringEntity stringEntity, RestApiAction petitionType, boolean getJson, boolean removeAtlassianTokenCheck, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doPostRequest(formattedUrl, getJson, stringEntity, null, null);
    }

    @Override
    public JsonObject httpPostPetition(List<NameValuePair> form, RestApiAction petitionType, boolean getJson, boolean useToken) {
        UrlEncodedFormEntity stringEntity = new UrlEncodedFormEntity(form, StandardCharsets.UTF_8);
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), new String[0]);
        return this.doPostRequest(formattedUrl, getJson, (StringEntity)stringEntity, null, null, "application/x-www-form-urlencoded");
    }

    @Override
    public JsonObject httpPostPetition(MultipartEntityBuilder multipartEntityBuilder, RestApiAction petitionType, boolean getJson, boolean removeAtlassianTokenCheck, Attachment attachment, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doPostRequest(formattedUrl, getJson, null, multipartEntityBuilder, attachment);
    }

    @Override
    public JsonObject httpPutPetition(StringEntity stringEntity, RestApiAction petitionType, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doPutRequest(formattedUrl, stringEntity);
    }

    @Override
    public JsonObject httpDeletePetition(RestApiAction petitionType, boolean getJson, String ... urlParameters) {
        String formattedUrl = this.generatePageUrl(petitionType.getUrl(), urlParameters);
        return this.doDeleteRequest(formattedUrl, getJson);
    }

    private JsonObject doGetRequest(String url, boolean getJson, boolean useAtlassianToken) {
        try {
            Request request = this.requestFactory.createRequest(Request.MethodType.GET, url);
            request.addBasicAuthentication(this.getHostName(url), this.credentials.getRemoteUserName(), this.credentials.getPassword());
            log.debug("calling GET to {} ,transformBoolean {}", (Object)url, (Object)getJson);
            if (useAtlassianToken) {
                url = this.checkUrlContainsToken(url);
                request.setUrl(url);
                request.setHeader("x-atlassian-token", "no-check");
            }
            if (getJson) {
                return (JsonObject)request.executeAndReturn(this::getJsonFromResponse);
            }
            return (JsonObject)request.executeAndReturn(this::checkStatusCode);
        }
        catch (ResponseException | URISyntaxException e) {
            log.error("error making post call to  {}", (Object)url, (Object)e);
            return null;
        }
    }

    private JsonObject doPostRequest(String url, boolean getJson, StringEntity stringEntity, MultipartEntityBuilder multipartEntityBuilder, Attachment attachment) {
        return this.doPostRequest(url, getJson, stringEntity, multipartEntityBuilder, attachment, "application/json");
    }

    private JsonObject doPostRequest(String url, boolean getJson, StringEntity stringEntity, MultipartEntityBuilder multipartEntityBuilder, Attachment attachment, String contentType) {
        try {
            Request request = this.requestFactory.createRequest(Request.MethodType.POST, url);
            request.addBasicAuthentication(this.getHostName(url), this.credentials.getRemoteUserName(), this.credentials.getPassword());
            if (multipartEntityBuilder != null && attachment != null) {
                List<RequestFilePart> requestFileParts = this.generateFilePartFromMultipartEntityBuilder(attachment);
                request.setFiles(requestFileParts);
                request.setHeader("x-atlassian-token", "no-check");
            }
            log.debug("calling Post to {},transformBoolean {}, Request Headers {}", new Object[]{url, getJson, request.getHeaders()});
            if (contentType.equals("application/x-www-form-urlencoded")) {
                request.setHeader("X-Atlassian-Token", "no-check");
            }
            if (stringEntity != null) {
                request.setRequestBody(IOUtils.toString((InputStream)stringEntity.getContent(), (Charset)StandardCharsets.UTF_8), contentType);
            }
            if (getJson) {
                return (JsonObject)request.executeAndReturn(this::getJsonFromResponse);
            }
            return (JsonObject)request.executeAndReturn(this::checkStatusCode);
        }
        catch (ResponseException | IOException | URISyntaxException e) {
            log.error("Error doing Post request to {}", (Object)url, (Object)e);
            return null;
        }
    }

    private JsonObject doPutRequest(String url, StringEntity stringEntity) {
        try {
            Request request = this.requestFactory.createRequest(Request.MethodType.PUT, url);
            log.debug("calling Put to {} , Request headers {}", (Object)url, (Object)request.getHeaders());
            request.addBasicAuthentication(this.getHostName(url), this.credentials.getRemoteUserName(), this.credentials.getPassword());
            if (stringEntity != null) {
                request.setRequestBody(IOUtils.toString((InputStream)stringEntity.getContent(), (Charset)StandardCharsets.UTF_8), "application/json");
            }
            return (JsonObject)request.executeAndReturn(this::getJsonFromResponse);
        }
        catch (ResponseException | IOException | URISyntaxException ex) {
            log.error("error on post request {}", (Object)url, (Object)ex);
            return null;
        }
    }

    private JsonObject doDeleteRequest(String url, boolean getJson) {
        try {
            Request request = this.requestFactory.createRequest(Request.MethodType.DELETE, url);
            log.debug("calling Delete to {} , Request headers {}", (Object)url, (Object)request.getHeaders());
            request.addBasicAuthentication(this.getHostName(url), this.credentials.getRemoteUserName(), this.credentials.getPassword());
            if (getJson) {
                return (JsonObject)request.executeAndReturn(this::getJsonFromResponse);
            }
            return (JsonObject)request.executeAndReturn(this::checkStatusCode);
        }
        catch (ResponseException | URISyntaxException e) {
            log.error("error making post call to  {}", (Object)url, (Object)e);
            return null;
        }
    }

    private JsonObject getJsonFromResponse(Response response) {
        try {
            String jsonString = response.getResponseBodyAsString();
            log.debug("Response status {} , Response Headers {} ,ResponseBody {} ,", new Object[]{response.getStatusCode(), response.getHeaders(), jsonString});
            JsonParser parser = new JsonParser();
            JsonElement resultObject = parser.parse(jsonString);
            if (resultObject instanceof JsonObject) {
                return (JsonObject)resultObject;
            }
            return null;
        }
        catch (Exception e) {
            log.error("error getting json from entity", e.getCause());
            return null;
        }
    }

    private JsonObject checkStatusCode(Response response) {
        int statusCode = response.getStatusCode();
        if (statusCode != 200 && statusCode != 202 && statusCode != 204 && statusCode != 302) {
            return null;
        }
        return new JsonObject();
    }

    private String getHostName(String url) throws URISyntaxException {
        URI uri = new URI(url);
        String hostname = uri.getHost();
        if (hostname != null) {
            return hostname.startsWith("www.") ? hostname.substring(4) : hostname;
        }
        log.warn("Could not get hostname for {}", (Object)url);
        return "";
    }

    private void encodeParameters(String ... urlParameters) {
        try {
            for (int i = 0; i < urlParameters.length; ++i) {
                urlParameters[i] = URLEncoder.encode(urlParameters[i], "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Could not encode parameters", (Throwable)e);
        }
    }

    private String generatePageUrl(String urlFormat, String ... urlParameters) {
        if (urlParameters.length > 0) {
            this.encodeParameters(urlParameters);
            MessageFormat messageFormat = new MessageFormat(urlFormat);
            return this.hostUrl + messageFormat.format(urlParameters);
        }
        return this.hostUrl + urlFormat;
    }

    private String getAtlassianToken() {
        try {
            Request request = this.requestFactory.createRequest(Request.MethodType.GET, this.hostUrl);
            request.addBasicAuthentication(this.getHostName(this.hostUrl), this.credentials.getRemoteUserName(), this.credentials.getPassword());
            request.setHeader("Content-Type", "text/html");
            this.atlassianToken = (String)request.executeAndReturn(response -> StringUtils.substringBetween((String)response.getResponseBodyAsString(), (String)"name=\"atlassian-token\" content=\"", (String)"\">"));
        }
        catch (ResponseException | URISyntaxException e) {
            log.error("Error getting the atlassian-token", e);
        }
        return this.atlassianToken;
    }

    private String checkUrlContainsToken(String url) {
        return url + this.getAtlassianToken();
    }

    private List<RequestFilePart> generateFilePartFromMultipartEntityBuilder(Attachment attachment) throws IOException {
        File file = File.createTempFile("attachment", ".tmp");
        InputStream attachmentData = this.attachmentManager.getAttachmentData(attachment);
        log.debug("Adding file to request ,{}", (Object)file.getAbsolutePath());
        try (FileOutputStream fo = new FileOutputStream(file);){
            IOUtils.copy((InputStream)attachmentData, (OutputStream)fo);
            RequestFilePart filePart = new RequestFilePart(attachment.getMediaType(), attachment.getFileName(), file, "file");
            List<RequestFilePart> list = Collections.singletonList(filePart);
            return list;
        }
    }
}

