/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.compat.setup.xstream.XStreamManagerCompat;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.comalatech.confluence.remotepublishing.PublishHistoryManager;
import com.comalatech.confluence.remotepublishing.confluence.xstream.NamespaceConverter;
import com.comalatech.confluence.remotepublishing.model.PublishHistoryInfo;
import com.comalatech.confluence.remotepublishing.utils.PluginContainerManager;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BandanaPublishHistoryManager
implements PublishHistoryManager {
    private static final Logger log = LoggerFactory.getLogger(BandanaPublishHistoryManager.class);
    private static final String PUBLISH_HISTORY_BANDANA_KEY_PREFIX = "com.comalatech.confluence.remotepublishing.publishHistory-";
    private final BandanaManager bandanaManager;
    private XStreamManagerCompat xStreamManagerCompat;

    public BandanaPublishHistoryManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Override
    public PublishHistoryInfo getLatestPublishHistoryInfo(AbstractPage localPage, String publishConfiguration) {
        List<PublishHistoryInfo> configurationPublishHistories;
        Map<String, List<PublishHistoryInfo>> publishHistoryMap = this.getBandanaPublishHistoryInfo(localPage);
        if (publishHistoryMap.containsKey(publishConfiguration) && (configurationPublishHistories = publishHistoryMap.get(publishConfiguration)).size() > 0) {
            return configurationPublishHistories.get(configurationPublishHistories.size() - 1);
        }
        return null;
    }

    @Override
    public void addPublishHistoryInfo(AbstractPage localPage, String publishConfiguration, PublishHistoryInfo publishHistoryInfo) {
        if (publishHistoryInfo != null && localPage != null) {
            Map<String, List<PublishHistoryInfo>> publishHistoryMap = this.getBandanaPublishHistoryInfo(localPage);
            List<Object> configurationPublishHistories = publishHistoryMap.containsKey(publishConfiguration) ? publishHistoryMap.get(publishConfiguration) : new ArrayList();
            configurationPublishHistories.add(publishHistoryInfo);
            publishHistoryMap.put(publishConfiguration, configurationPublishHistories);
            this.saveBandanaPublishHistoryInfoSpaceConfigs(localPage, publishHistoryMap);
        }
    }

    protected Map<String, List<PublishHistoryInfo>> getBandanaPublishHistoryInfo(AbstractPage localPage) {
        Object bandanaValue = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(localPage.getSpaceKey()), this.getBandanaKey(localPage));
        Map<String, List<PublishHistoryInfo>> publishHistories = new HashMap<String, List<PublishHistoryInfo>>();
        if (bandanaValue != null && ((String)bandanaValue).length() > 0) {
            Object xstreamObject;
            if (this.xStreamManagerCompat == null) {
                this.initXStreamManagerCompat();
            }
            if ((xstreamObject = this.xStreamManagerCompat.fromXML((String)bandanaValue)) instanceof Map) {
                publishHistories = (Map)xstreamObject;
            }
        }
        return publishHistories;
    }

    protected void saveBandanaPublishHistoryInfoSpaceConfigs(AbstractPage localPage, Map<String, List<PublishHistoryInfo>> publishHistories) {
        String saveData = null;
        if (publishHistories != null) {
            if (this.xStreamManagerCompat == null) {
                this.initXStreamManagerCompat();
            }
            saveData = this.xStreamManagerCompat.toXML(publishHistories);
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(localPage.getSpaceKey()), this.getBandanaKey(localPage), (Object)saveData);
    }

    protected String getBandanaKey(AbstractPage page) {
        return PUBLISH_HISTORY_BANDANA_KEY_PREFIX + page.getIdAsString();
    }

    private void initXStreamManagerCompat() {
        this.xStreamManagerCompat = PluginContainerManager.getComponent("xStreamManagerCompat", XStreamManagerCompat.class);
        if (this.xStreamManagerCompat != null) {
            this.xStreamManagerCompat.getXStream().registerConverter((Converter)new NamespaceConverter());
        } else {
            log.error("Could not load XStream Manager Compat.");
        }
    }
}

