/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.macro;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.RemotePublishingManager;
import com.comalatech.confluence.remotepublishing.credentials.Credentials;
import com.comalatech.confluence.remotepublishing.macro.AbstractRemotePublishingNoBodyBaseMacro;
import com.comalatech.confluence.remotepublishing.macro.RemotePublishingMacroHelper;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePublishingTestMacro
extends AbstractRemotePublishingNoBodyBaseMacro {
    private static final Logger log = LoggerFactory.getLogger(RemotePublishingTestMacro.class);
    private RemotePublishingManager remotePublishingManager;
    private SubRenderer subRenderer;

    @Override
    public String doExecute(Map parameters, RenderContext renderContext) throws MacroException {
        Map credentialsMap = (Map)renderContext.getParam((Object)"com.comalatech.workflow.properties.publishing");
        if (credentialsMap == null) {
            throw new MacroException("need to define remote publishing credentials");
        }
        Credentials credentials = new Credentials(credentialsMap);
        try {
            this.remotePublishingManager.checkCredentials(credentials);
            return this.subRenderer.render("{tip:title=success!}logged into " + credentials.getUrl() + " as {{" + credentials.getLoginUserName() + "}}, confirmed that the user can write into space _" + credentials.getRemoteSpaceKey() + "_" + (TextUtils.stringSet((String)credentials.getRemoteUserName()) ? " and that user {{" + credentials.getRemoteUserName() + "}} exists " : "") + "{tip}", renderContext);
        }
        catch (RemotePublishingException e) {
            return this.subRenderer.render("{warning}" + e.getMessage() + "{warning}", renderContext);
        }
        catch (Exception e) {
            RemotePublishingMacroHelper.logErrorMessageToWorkflowEngine(e.toString(), renderContext);
            log.error(e.getMessage(), (Throwable)e);
            throw new MacroException(e.getMessage());
        }
    }

    public void setRemotePublishingManager(RemotePublishingManager remotePublishingManager) {
        this.remotePublishingManager = remotePublishingManager;
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }
}

