/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence.xstream;

import com.atlassian.confluence.labels.Namespace;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class NamespaceConverter
implements Converter {
    public boolean canConvert(Class aClass) {
        return aClass.equals(Namespace.class);
    }

    public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Namespace namespace = (Namespace)o;
        hierarchicalStreamWriter.startNode("namespacePrefix");
        hierarchicalStreamWriter.setValue(namespace.getPrefix());
        hierarchicalStreamWriter.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        hierarchicalStreamReader.moveDown();
        String namespacePrefix = hierarchicalStreamReader.getValue();
        hierarchicalStreamReader.moveUp();
        if (namespacePrefix.equals("my")) {
            return Namespace.PERSONAL;
        }
        if (namespacePrefix.equals("team")) {
            return Namespace.TEAM;
        }
        if (namespacePrefix.equals("global")) {
            return Namespace.GLOBAL;
        }
        return Namespace.SYSTEM;
    }
}

