/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence.manifest;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.comalatech.confluence.remotepublishing.confluence.manifest.RemoteManifestOperation;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.RestApiAction;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class LabelManifestOperation
implements RemoteManifestOperation {
    private RemotePageManifest remotePageManifest;
    private String pageId;
    private ApiAction restApiAction;

    public LabelManifestOperation(ApiAction apiAction, RemotePageManifest remotePageManifest, String pageId) {
        this.restApiAction = apiAction;
        this.remotePageManifest = remotePageManifest;
        this.pageId = pageId;
    }

    @Override
    public void add() {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.GET_LABEL, true, false, this.pageId);
        ArrayList<Label> remoteLabelList = new ArrayList<Label>();
        JsonArray labels = response.get("results").getAsJsonArray();
        for (JsonElement label : labels) {
            remoteLabelList.add(this.buildRemoteLabelManifest(label));
        }
        this.remotePageManifest.setLabels(remoteLabelList);
    }

    private Label buildRemoteLabelManifest(JsonElement label) {
        String prefix = label.getAsJsonObject().get("prefix").getAsString();
        String name = label.getAsJsonObject().get("name").getAsString();
        return new Label(name, Namespace.getNamespace((String)prefix));
    }
}

