/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.remotepublishing.credentials.Credentials;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RestModelComponent {
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private static final String NUMBER = "number";
    private static final String VERSION = "version";
    private static final String ID = "id";
    private static final String ANCESTORS = "ancestors";
    private static final String SPACE = "space";
    private static final String STORAGE = "storage";
    private static final String LINKS = "_links";
    private static final String WEBUI = "webui";
    private static final String STATUS = "status";
    public static final String VALUE = "value";
    public static final String REPRESENTATION = "representation";

    public JsonObject generateUpdateObject(String environment, String version, String pageTitle, String pageContent, String pageType, String parentPageId, String status, String remotePageId, String spaceId) {
        JsonObject updatedPage = "cloud".equals(environment) ? this.getUpdatedPageCloud(version, pageTitle, pageContent, pageType, parentPageId, status, remotePageId) : this.getUpdatedPageServer(version, pageTitle, pageContent, pageType, parentPageId, spaceId);
        return updatedPage;
    }

    private JsonObject getUpdatedPageCloud(String version, String pageTitle, String pageContent, String pageType, String parentPageId, String status, String remotePageId) {
        JsonObject updatedPage = new JsonObject();
        updatedPage.addProperty(ID, remotePageId);
        updatedPage.addProperty(TITLE, pageTitle);
        updatedPage.addProperty(STATUS, status);
        this.setVersionNumber(version, updatedPage);
        if ("page".equals(pageType) && Objects.nonNull(parentPageId) && !"0".equals(parentPageId)) {
            updatedPage.addProperty("parentId", parentPageId);
        }
        JsonObject bodyJson = new JsonObject();
        bodyJson.addProperty(VALUE, pageContent);
        bodyJson.addProperty(REPRESENTATION, STORAGE);
        updatedPage.add("body", (JsonElement)bodyJson);
        return updatedPage;
    }

    private JsonObject getUpdatedPageServer(String version, String pageTitle, String pageContent, String pageType, String parentPageId, String spaceId) {
        JsonObject updatedPage = new JsonObject();
        updatedPage.addProperty(TYPE, pageType);
        updatedPage.addProperty(TITLE, pageTitle);
        this.setVersionNumber(version, updatedPage);
        if ("page".equals(pageType)) {
            String parentForUpdatingPage = Objects.nonNull(parentPageId) && !"0".equals(parentPageId) ? parentPageId : spaceId;
            JsonArray parentPageArray = new JsonArray();
            JsonObject parentPage = new JsonObject();
            parentPage.addProperty(ID, parentForUpdatingPage);
            parentPageArray.add((JsonElement)parentPage);
            updatedPage.add(ANCESTORS, (JsonElement)parentPageArray);
        }
        JsonObject bodyJson = new JsonObject();
        JsonObject storageJson = new JsonObject();
        storageJson.addProperty(VALUE, pageContent);
        storageJson.addProperty(REPRESENTATION, STORAGE);
        bodyJson.add(STORAGE, (JsonElement)storageJson);
        updatedPage.add("body", (JsonElement)bodyJson);
        return updatedPage;
    }

    private void setVersionNumber(String version, JsonObject updatedPage) {
        JsonObject versionNumber = new JsonObject();
        long newVersion = (long)Integer.parseInt(version) + 1L;
        versionNumber.addProperty(NUMBER, (Number)newVersion);
        updatedPage.add(VERSION, (JsonElement)versionNumber);
    }

    public JsonObject generatePageToUpdateAncestors(long version, long parentPageId, String childPageTitle) {
        JsonObject updatedPage = new JsonObject();
        JsonObject versionNumber = new JsonObject();
        versionNumber.addProperty(NUMBER, (Number)version);
        updatedPage.add(VERSION, (JsonElement)versionNumber);
        JsonArray parentPageArray = new JsonArray();
        JsonObject parentPage = new JsonObject();
        parentPage.addProperty(ID, (Number)parentPageId);
        parentPageArray.add((JsonElement)parentPage);
        updatedPage.add(ANCESTORS, (JsonElement)parentPageArray);
        updatedPage.addProperty(TITLE, childPageTitle);
        updatedPage.addProperty(TYPE, "page");
        return updatedPage;
    }

    public JsonObject generatePageForCreation(String pageTitle, String pageContent, long remoteParentPageId, Credentials credentials) {
        JsonObject newPage = new JsonObject();
        newPage.addProperty(TYPE, "page");
        newPage.addProperty(TITLE, pageTitle);
        JsonObject parentPage = new JsonObject();
        parentPage.addProperty(TYPE, "page");
        parentPage.addProperty(ID, (Number)remoteParentPageId);
        JsonArray parentPageArray = new JsonArray();
        parentPageArray.add((JsonElement)parentPage);
        newPage.add(ANCESTORS, (JsonElement)parentPageArray);
        JsonObject spaceObj = new JsonObject();
        spaceObj.addProperty("key", credentials.getRemoteSpaceKey());
        newPage.add(SPACE, (JsonElement)spaceObj);
        JsonObject storageObj = new JsonObject();
        storageObj.addProperty(VALUE, pageContent);
        storageObj.addProperty(REPRESENTATION, STORAGE);
        JsonObject bodyObj = new JsonObject();
        bodyObj.add(STORAGE, (JsonElement)storageObj);
        newPage.add("body", (JsonElement)bodyObj);
        return newPage;
    }

    public RemotePageManifest createRemotePageManifest(Page page, JsonObject response, Credentials credentials) {
        String parentId = "0";
        String parentTitle = null;
        if (response.getAsJsonArray(ANCESTORS).size() != 0) {
            parentId = response.getAsJsonArray(ANCESTORS).get(0).getAsJsonObject().get(ID).getAsString();
            parentTitle = response.getAsJsonArray(ANCESTORS).get(0).getAsJsonObject().get(TITLE).getAsString();
        }
        return this.getRemotePageManifestBuilder(response, credentials).parentId(parentId).parentTitle(parentTitle).labels(this.filterPersonalLabels(page.getLabels())).build();
    }

    public RemotePageManifest generatePageManifest(JsonObject response, Credentials credentials) {
        return this.getRemotePageManifestBuilder(response, credentials).build();
    }

    private RemotePageManifest.RemotePageManifestBuilder getRemotePageManifestBuilder(JsonObject response, Credentials credentials) {
        return RemotePageManifest.builder().version(response.get(VERSION).getAsJsonObject().get(NUMBER).getAsString()).title(response.get(TITLE).getAsString()).spaceId(response.getAsJsonObject(SPACE).get(ID).getAsString()).pageId(response.get(ID).getAsString()).spaceKey(credentials.getRemoteSpaceKey()).url(response.get(LINKS).getAsJsonObject().get(WEBUI).getAsString()).attachments(new ArrayList<RemoteAttachmentManifest>());
    }

    public RemotePageManifest updateRemotePageManifest(Page page, RemotePageManifest manifest) {
        manifest.setTitle(page.getTitle());
        String version = String.valueOf(Integer.parseInt(manifest.getVersion()) + 1);
        manifest.setVersion(version);
        if (page.getParent() != null && manifest.getParentId() != null && !manifest.getParentId().equals("0")) {
            manifest.setParentTitle(page.getParent().getTitle());
        } else {
            manifest.setParentTitle(null);
        }
        manifest.setLabels(this.filterPersonalLabels(page.getLabels()));
        return manifest;
    }

    public RemotePageManifest createRemoteBlogManifest(JsonObject response, Credentials credentials) {
        return this.getRemotePageManifestBuilder(response, credentials).build();
    }

    public RemotePageManifest updateRemoteBlogManifest(BlogPost blog, RemotePageManifest manifest) {
        manifest.setTitle(blog.getTitle());
        String version = String.valueOf(Integer.parseInt(manifest.getVersion()) + 1);
        manifest.setVersion(version);
        manifest.setLabels(this.filterPersonalLabels(blog.getLabels()));
        return manifest;
    }

    public List<Label> filterPersonalLabels(List<Label> labels) {
        ArrayList<Label> ret = new ArrayList<Label>();
        for (Label label : labels) {
            if (this.isPersonalLabel(label)) continue;
            ret.add(label);
        }
        return ret;
    }

    private boolean isPersonalLabel(Label label) {
        return this.isPersonalLabel(label.getNamespace().getPrefix());
    }

    private boolean isPersonalLabel(String prefix) {
        return Namespace.PERSONAL.getPrefix().equals(prefix);
    }
}

