/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.util.HtmlUtil;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.confluence.ConfluenceRestRemotePublisher;
import com.comalatech.confluence.remotepublishing.confluence.RestModelComponent;
import com.comalatech.confluence.remotepublishing.confluence.manifest.AncestorManifestOperation;
import com.comalatech.confluence.remotepublishing.confluence.manifest.AttachmentManifestOperation;
import com.comalatech.confluence.remotepublishing.confluence.manifest.LabelManifestOperation;
import com.comalatech.confluence.remotepublishing.confluence.manifest.RemoteManifestOperationExecutor;
import com.comalatech.confluence.remotepublishing.credentials.Credentials;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.RestApiAction;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.comalatech.confluence.remotepublishing.utils.factory.ApiActionFactory;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfluenceRestRemotePublisher
implements ConfluenceRestRemotePublisher {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfluenceRestRemotePublisher.class);
    private static final String POSITION = "position";
    private static final String RESULTS = "results";
    private Credentials credentials;
    private final ApiAction restApiAction;
    private final RemoteManifestOperationExecutor remoteManifestOperationExecutor;
    private final RestModelComponent restModelComponent;

    public DefaultConfluenceRestRemotePublisher(ApiActionFactory apiActionFactory) {
        this.restApiAction = apiActionFactory.getApiAction();
        this.remoteManifestOperationExecutor = new RemoteManifestOperationExecutor();
        this.restModelComponent = new RestModelComponent();
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
        this.restApiAction.setRemoteCredentials(credentials);
    }

    @Override
    public RemotePageManifest createRemote(AbstractPage absPage) {
        log.debug("Adding '" + absPage.getTitle() + "'(" + absPage.getSpaceKey() + ")");
        if (absPage instanceof Page) {
            RemotePageManifest manifest = this.createRemotePage((Page)absPage);
            if (manifest != null) {
                return manifest;
            }
            throw new RemotePublishingException("create remote page failed");
        }
        if (absPage instanceof BlogPost) {
            RemotePageManifest manifest = this.createRemoteBlogPost((BlogPost)absPage);
            if (manifest != null) {
                return manifest;
            }
            throw new RemotePublishingException("create remote blogpost failed");
        }
        return null;
    }

    private RemotePageManifest createRemotePage(Page page) {
        List<Page> remotePublishedChildList;
        long remoteParentPageId = 0L;
        if (!page.getAncestors().isEmpty()) {
            remoteParentPageId = this.getRemotePageId(((Page)page.getAncestors().get(page.getAncestors().size() - 1)).getTitle());
        }
        String bodyContent = page.getBodyAsString();
        StringEntity stringEntity = new StringEntity(this.restModelComponent.generatePageForCreation(page.getTitle(), bodyContent, remoteParentPageId, this.credentials).toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPostPetition(stringEntity, RestApiAction.CREATE_CONTENT, true, false, new String[0]);
        if (response == null || !response.has("id")) {
            return null;
        }
        if (!page.getLabels().isEmpty()) {
            this.addRemoteLabels(response.get("id").getAsString(), page.getLabels());
        }
        if (!(remotePublishedChildList = this.getRemotePublishedChilds(page)).isEmpty()) {
            this.changeParentForPublishedChildren(remotePublishedChildList, response.get("id").getAsLong());
            this.reorderPagesInRemote(page, remotePublishedChildList, response.get("id").getAsString());
        }
        if (page.getParent() != null) {
            this.reorderParentPagesAfterPageUpdate(page.getParent());
        }
        return this.restModelComponent.createRemotePageManifest(page, response, this.credentials);
    }

    private void reorderPagesInRemote(Page page, List<Page> remotePublishedChildList, String parentId) {
        String lastSortedPageId = null;
        List<Page> sortedPublishedPages = this.getSortedPublishedPages(page, remotePublishedChildList);
        for (Page child : sortedPublishedPages) {
            lastSortedPageId = lastSortedPageId == null ? this.appendPage(child, parentId) : this.putPageBelow(child, lastSortedPageId);
        }
    }

    private List<Page> getSortedPublishedPages(Page page, List<Page> remotePublishedChildList) {
        List sortedPublishedPages = page.getSortedChildren();
        for (Page child : page.getSortedChildren()) {
            if (remotePublishedChildList.contains(child)) continue;
            sortedPublishedPages.remove(child);
        }
        return sortedPublishedPages;
    }

    private String appendPage(Page page, String parentId) {
        String lastSortedPageId = String.valueOf(this.getRemotePageId(page.getTitle()));
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_INFO, true, false, lastSortedPageId);
        String positionInRemote = response.get("extensions").getAsJsonObject().get(POSITION).getAsString();
        String string = positionInRemote = positionInRemote.equals("none") || page.getAncestors() == null ? "-1" : positionInRemote;
        if (Integer.parseInt(positionInRemote) != page.getParent().getSortedChildren().indexOf(page) && (response = this.restApiAction.httpPostPetition(this.movePageRequestBody(lastSortedPageId, parentId, "append"), RestApiAction.MOVE_PAGE, true, true)) == null) {
            log.error("There has been an error moving the page " + lastSortedPageId);
        }
        return lastSortedPageId;
    }

    private String putPageBelow(Page page, String lastSortedPageId) {
        String pageToMoveId = String.valueOf(this.getRemotePageId(page.getTitle()));
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_INFO, true, false, pageToMoveId);
        String positionInRemote = response.get("extensions").getAsJsonObject().get(POSITION).getAsString();
        positionInRemote = positionInRemote.equals("none") ? "0" : positionInRemote;
        RemotePageManifest manifest = this.getRemoteContentManifest((AbstractPage)page);
        if (manifest != null && (Integer.parseInt(positionInRemote) != page.getParent().getSortedChildren().indexOf(page) || manifest.getParentTitle() != null && !manifest.getParentTitle().equals(page.getParent().getTitle())) && (response = this.restApiAction.httpPostPetition(this.movePageRequestBody(pageToMoveId, lastSortedPageId, "below"), RestApiAction.MOVE_PAGE, true, true)) == null) {
            log.error("There has been an error moving the page " + pageToMoveId);
        }
        return pageToMoveId;
    }

    private RemotePageManifest createRemoteBlogPost(BlogPost blog) {
        String bodyContent = blog.getBodyAsString();
        StringEntity stringEntity = new StringEntity(this.generateBlogForCreation(blog.getTitle(), bodyContent).toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPostPetition(stringEntity, RestApiAction.CREATE_CONTENT, true, false, new String[0]);
        if (!blog.getLabels().isEmpty() && response != null && response.has("id")) {
            try {
                this.addRemoteLabels(response.get("id").getAsString(), blog.getLabels());
            }
            catch (RemotePublishingException e) {
                log.error(e.getMessage(), e.getCause());
            }
        }
        RemotePageManifest manifest = this.restModelComponent.createRemoteBlogManifest(response, this.credentials);
        manifest.setLabels(this.restModelComponent.filterPersonalLabels(blog.getLabels()));
        return manifest;
    }

    @Override
    public RemotePageManifest updateRemote(AbstractPage absPage, RemotePageManifest manifest) throws RemotePublishingException {
        if (log.isDebugEnabled()) {
            log.debug("Updating: " + absPage);
            log.debug("Current Publishing Info: " + manifest);
        }
        if (absPage instanceof Page) {
            RemotePageManifest updatedManifest = this.updateRemotePage((Page)absPage, manifest);
            if (updatedManifest != null) {
                return updatedManifest;
            }
            throw new RemotePublishingException("update remote page failed");
        }
        if (absPage instanceof BlogPost) {
            RemotePageManifest updatedManifest = this.updateRemoteBlogPost((BlogPost)absPage, manifest);
            if (updatedManifest != null) {
                return updatedManifest;
            }
            throw new RemotePublishingException("update remote blogpost failed");
        }
        return null;
    }

    private RemotePageManifest updateRemotePage(Page page, RemotePageManifest manifest) {
        String remotePageId = manifest.getPageId();
        String remoteParentPageId = this.getRemoteParent(page, manifest);
        manifest.setParentId(remoteParentPageId);
        StringEntity stringEntity = new StringEntity(this.restModelComponent.generateUpdateObject(this.credentials.getConfluenceEnvironment(), manifest.getVersion(), page.getTitle(), page.getBodyAsString(), "page", remoteParentPageId, page.getContentStatus(), remotePageId, manifest.getSpaceId()).toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPutPetition(stringEntity, "cloud".equals(this.credentials.getConfluenceEnvironment()) ? RestApiAction.UPDATE_PAGE : RestApiAction.UPDATE_CONTENT, remotePageId);
        if (response == null || !response.has("id")) {
            return null;
        }
        this.updateLabels(manifest.getPageId(), page.getLabels(), manifest.getLabels());
        List<Page> remotePublishedChildList = this.getRemotePublishedChilds(page);
        if (!remotePublishedChildList.isEmpty()) {
            this.reorderPagesInRemote(page, remotePublishedChildList, manifest.getPageId());
        }
        if (page.getParent() != null) {
            this.reorderParentPagesAfterPageUpdate(page.getParent());
        }
        return this.restModelComponent.updateRemotePageManifest(page, manifest);
    }

    private String getRemoteParent(Page page, RemotePageManifest manifest) {
        if (Objects.isNull(page.getParent())) {
            return "0";
        }
        if (!page.getParent().getTitle().equals(manifest.getParentTitle())) {
            long parentId = this.getRemotePageId(page.getParent().getTitle());
            if (parentId != 0L) {
                return String.valueOf(parentId);
            }
        } else {
            return manifest.getParentId();
        }
        return "0";
    }

    private void reorderParentPagesAfterPageUpdate(Page page) {
        List<Page> remotePublishedChilds = this.getRemotePublishedChilds(page);
        long parentId = this.getRemotePageId(page.getTitle());
        if (parentId != 0L) {
            this.reorderPagesInRemote(page, remotePublishedChilds, String.valueOf(parentId));
        }
    }

    private RemotePageManifest updateRemoteBlogPost(BlogPost blog, RemotePageManifest manifest) {
        String remotePageId = manifest.getPageId();
        String bodyContent = blog.getBodyAsString();
        StringEntity stringEntity = new StringEntity(this.restModelComponent.generateUpdateObject(this.credentials.getConfluenceEnvironment(), manifest.getVersion(), blog.getTitle(), bodyContent, "blogpost", null, blog.getContentStatus(), remotePageId, manifest.getSpaceId()).toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPutPetition(stringEntity, "cloud".equals(this.credentials.getConfluenceEnvironment()) ? RestApiAction.UPDATE_BLOGPOST : RestApiAction.UPDATE_CONTENT, remotePageId);
        if (response == null) {
            return null;
        }
        this.updateLabels(manifest.getPageId(), blog.getLabels(), manifest.getLabels());
        return this.restModelComponent.updateRemoteBlogManifest(blog, manifest);
    }

    @Override
    public RemotePageManifest getRemoteContentManifest(AbstractPage abstractPage, RemotePageManifest publishHistoryInfo) {
        long remotePageId;
        RemotePageManifest remotePageManifest = null;
        if (!(publishHistoryInfo == null || (remotePageManifest = this.getRemoteContentManifest(publishHistoryInfo.getPageId())) != null && remotePageManifest.getTitle().equals(publishHistoryInfo.getTitle()) || (remotePageId = this.getRemotePageId(publishHistoryInfo.getTitle())) == 0L)) {
            remotePageManifest = this.getRemoteContentManifest(String.valueOf(remotePageId));
        }
        if (remotePageManifest == null) {
            remotePageManifest = this.getRemoteContentManifest(abstractPage);
        }
        return remotePageManifest;
    }

    private RemotePageManifest getRemoteContentManifest(AbstractPage absPage) {
        log.debug("Getting content from '" + absPage.getTitle() + "'(" + absPage.getSpaceKey() + ")");
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_EXIST, true, false, this.credentials.getRemoteSpaceKey(), absPage.getTitle());
        if (response != null) {
            if (!response.has("size") || response.get("size").getAsInt() == 0) {
                return null;
            }
            String contentId = response.get(RESULTS).getAsJsonArray().get(0).getAsJsonObject().get("id").getAsString();
            if (absPage instanceof Page) {
                return this.getRemoteContentManifest(contentId);
            }
            if (absPage instanceof BlogPost) {
                RemotePageManifest manifest = this.restModelComponent.createRemoteBlogManifest(response, this.credentials);
                this.remoteManifestOperationExecutor.addOperation(new LabelManifestOperation(this.restApiAction, manifest, contentId));
                return manifest;
            }
        }
        return null;
    }

    private RemotePageManifest getRemoteContentManifest(String pageId) {
        log.debug("Getting content from '" + pageId);
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_INFO, true, false, pageId);
        if (response != null && response.has("id")) {
            if (response.get("type").getAsString().equals("page")) {
                RemotePageManifest manifest = this.restModelComponent.generatePageManifest(response, this.credentials);
                this.remoteManifestOperationExecutor.addOperation(new AncestorManifestOperation(this.restApiAction, manifest, pageId));
                this.remoteManifestOperationExecutor.addOperation(new LabelManifestOperation(this.restApiAction, manifest, pageId));
                this.remoteManifestOperationExecutor.addOperation(new AttachmentManifestOperation(this.restApiAction, manifest));
                return manifest;
            }
            RemotePageManifest manifest = this.restModelComponent.createRemoteBlogManifest(response, this.credentials);
            this.remoteManifestOperationExecutor.addOperation(new LabelManifestOperation(this.restApiAction, manifest, pageId));
            this.remoteManifestOperationExecutor.addOperation(new AttachmentManifestOperation(this.restApiAction, manifest));
            return manifest;
        }
        return null;
    }

    private void addRemoteLabels(String remoteContentId, List<Label> labelList) {
        log.debug("Adding labels of '" + remoteContentId);
        if (labelList.isEmpty()) {
            return;
        }
        JsonArray labelArray = new JsonArray();
        for (Label label : this.restModelComponent.filterPersonalLabels(labelList)) {
            labelArray.add((JsonElement)this.generateLabelToAdd(label));
        }
        if (labelArray.size() == 0) {
            return;
        }
        StringEntity stringEntity = new StringEntity(labelArray.toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPostPetition(stringEntity, RestApiAction.ADD_LABEL, true, false, remoteContentId);
        if (response == null) {
            log.error("add labels failed");
        }
    }

    private void updateLabels(String pageId, List<Label> draftLabels, List<Label> publishedLabels) {
        log.debug("Updating labels of '" + pageId);
        if (draftLabels != null && !draftLabels.isEmpty()) {
            this.addRemoteLabels(pageId, this.getLabelsToAddList(draftLabels, publishedLabels));
        }
        if (publishedLabels != null && !publishedLabels.isEmpty()) {
            this.removeRemoteLabels(pageId, this.getLabelsToRemoveList(draftLabels, publishedLabels));
        }
    }

    private void removeRemoteLabels(String remoteContentId, List<Label> labelsToRemove) throws RemotePublishingException {
        log.debug("Removing labels of '" + remoteContentId);
        if (labelsToRemove.isEmpty()) {
            return;
        }
        for (Label label : labelsToRemove) {
            JsonObject response = this.restApiAction.httpDeletePetition(RestApiAction.REMOVE_LABEL, false, remoteContentId, label.getName());
            if (response != null) continue;
            throw new RemotePublishingException("remove labels failed");
        }
    }

    private JsonObject generateLabelToAdd(Label label) {
        JsonObject labelJson = new JsonObject();
        labelJson.addProperty("prefix", label.getNamespace().getPrefix());
        labelJson.addProperty("name", label.getName());
        return labelJson;
    }

    private List<Label> getLabelsToAddList(List<Label> draftLabels, List<Label> publishedLabels) {
        ArrayList<Label> labelsToAdd = new ArrayList<Label>();
        for (Label label : draftLabels) {
            if (publishedLabels.contains(label)) continue;
            labelsToAdd.add(label);
        }
        return labelsToAdd;
    }

    private List<Label> getLabelsToRemoveList(List<Label> draftLabels, List<Label> publishedLabels) {
        ArrayList<Label> labelsToRemove = new ArrayList<Label>();
        for (Label label : this.restModelComponent.filterPersonalLabels(publishedLabels)) {
            if (draftLabels.contains(label)) continue;
            labelsToRemove.add(label);
        }
        return labelsToRemove;
    }

    private void changeParentForPublishedChildren(List<Page> publishedChildPages, long remoteParentPageId) {
        for (Page child : publishedChildPages) {
            StringEntity stringEntity = new StringEntity(this.restModelComponent.generatePageToUpdateAncestors(this.getRemotePageVersion(child.getTitle()) + 1L, remoteParentPageId, child.getTitle()).toString(), ContentType.APPLICATION_JSON);
            String pageId = String.valueOf(this.getRemotePageId(child.getTitle()));
            if (pageId.equals("0")) continue;
            this.restApiAction.httpPutPetition(stringEntity, RestApiAction.UPDATE_PAGE, pageId);
        }
    }

    @Override
    public void removeRemote(String pageId, boolean purgeFromTrash) throws RemotePublishingException {
        log.debug("Removing '" + pageId + "'(purge from trash: " + purgeFromTrash + ")");
        JsonObject response = this.restApiAction.httpDeletePetition(RestApiAction.DELETE_CONTENT, false, pageId);
        if (purgeFromTrash && response != null) {
            response = this.restApiAction.httpDeletePetition(RestApiAction.REMOVE_FROM_TRASH, false, pageId);
        }
        if (response == null) {
            throw new RemotePublishingException("remove remote failed");
        }
    }

    private List<Page> getRemotePublishedChilds(Page page) {
        ArrayList<Page> remotePublishedChilds = new ArrayList<Page>();
        for (Page child : page.getChildren()) {
            if (!this.remotePageExists(child.getTitle())) continue;
            remotePublishedChilds.add(child);
        }
        return remotePublishedChilds;
    }

    private boolean remotePageExists(String title) {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_EXIST, true, false, this.credentials.getRemoteSpaceKey(), title);
        return response.get("size").getAsLong() != 0L;
    }

    private long getRemotePageId(String pageTitle) {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_EXIST, true, false, this.credentials.getRemoteSpaceKey(), pageTitle);
        if (response == null) {
            return 0L;
        }
        if (response.get("size").getAsInt() == 0 || !response.has(RESULTS)) {
            return 0L;
        }
        return response.get(RESULTS).getAsJsonArray().get(0).getAsJsonObject().get("id").getAsLong();
    }

    private long getRemotePageVersion(String pageTitle) {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_VERSION, true, false, this.credentials.getRemoteSpaceKey(), pageTitle);
        return response.get(RESULTS).getAsJsonArray().get(0).getAsJsonObject().get("version").getAsJsonObject().get("number").getAsLong();
    }

    private JsonObject generateBlogForCreation(String blogTitle, String pageContent) {
        JsonObject newBlog = new JsonObject();
        newBlog.addProperty("type", "blogpost");
        newBlog.addProperty("title", blogTitle);
        JsonObject spaceObj = new JsonObject();
        spaceObj.addProperty("key", this.credentials.getRemoteSpaceKey());
        newBlog.add("space", (JsonElement)spaceObj);
        JsonObject storageObj = new JsonObject();
        storageObj.addProperty("value", pageContent);
        storageObj.addProperty("representation", "storage");
        JsonObject bodyObj = new JsonObject();
        bodyObj.add("storage", (JsonElement)storageObj);
        newBlog.add("body", (JsonElement)bodyObj);
        return newBlog;
    }

    @Override
    public RemoteAttachmentManifest addAttachment(String pageId, Attachment attachment, byte[] data) {
        log.debug("Adding attachment " + attachment.getFileName() + " to page with id " + pageId);
        MultipartEntityBuilder multipartEntityBuilder = this.generateAttachmentForUpload(attachment, data);
        JsonObject response = this.restApiAction.httpPostPetition(multipartEntityBuilder, RestApiAction.CREATE_ATTACHMENT, true, true, attachment, pageId);
        if (response != null && !response.has("statusCode")) {
            RemoteAttachmentManifest attachmentManifest = this.createRemoteAttachmentManifest(attachment, response);
            this.attachmentFileNameAndCommentUpdate(pageId, attachment, attachmentManifest);
            this.addRemoteLabels(attachmentManifest.getId(), attachment.getLabels());
            return attachmentManifest;
        }
        String message = "Check attachment size limit in Confluence's remote instance.";
        if (response != null && response.has("message")) {
            message = response.get("message").getAsString();
        }
        throw new RemotePublishingException("Adding attachment failed: " + attachment.getFileName() + " (" + attachment.getFileSize() + " bytes). " + message);
    }

    @Override
    public void updateAttachment(String pageId, Attachment attachment, RemoteAttachmentManifest attachmentManifest, byte[] data) {
        JsonObject response;
        log.debug("Updating attachment " + attachment.getFileName() + " to page with id " + pageId);
        if (attachment.getVersion() != attachmentManifest.getVersion() || attachment.getFileSize() != attachmentManifest.getSize()) {
            response = this.attachmentDataUpdate(attachment, data, pageId, attachmentManifest);
            if (response == null) {
                throw new RemotePublishingException("update attachment data failed");
            }
            attachmentManifest.setVersion(attachment.getVersion() + 1);
            attachmentManifest.setSize(attachment.getFileSize());
        }
        if (!attachment.getFileName().equals(attachmentManifest.getFilename()) || attachment.getVersionComment() != null && !attachment.getVersionComment().equals(attachmentManifest.getComment()) || attachment.getVersionComment() == null && attachmentManifest.getComment() != null) {
            response = this.attachmentFileNameAndCommentUpdate(pageId, attachment, attachmentManifest);
            if (response == null) {
                throw new RemotePublishingException("update attachment properties failed");
            }
            attachmentManifest.setComment(attachment.getVersionComment());
            attachmentManifest.setFilename(attachment.getFileName());
        }
        if (!attachment.getLabels().equals(attachmentManifest.getLabels())) {
            this.updateLabels(attachmentManifest.getId(), attachment.getLabels(), attachmentManifest.getLabels());
            attachmentManifest.setLabels(attachment.getLabels());
        }
        if (attachment.getId() != 0L) {
            attachmentManifest.setLocalId(String.valueOf(attachment.getId()));
        }
    }

    @Override
    public void deleteAttachment(String attachmentId) {
        log.debug("Deleting attachment " + attachmentId);
        JsonObject response = this.restApiAction.httpDeletePetition(RestApiAction.DELETE_CONTENT, false, attachmentId);
        if (response == null) {
            throw new RemotePublishingException("delete attachment failed");
        }
    }

    private RemoteAttachmentManifest createRemoteAttachmentManifest(Attachment attachment, JsonObject remoteAttachment) {
        String id = remoteAttachment.get(RESULTS).getAsJsonArray().get(0).getAsJsonObject().get("id").getAsString();
        String fileName = attachment.getFileName();
        String fileSize = String.valueOf(attachment.getFileSize());
        RemoteAttachmentManifest remoteAttachmentManifest = new RemoteAttachmentManifest(id, fileName, 1, Integer.parseInt(fileSize), attachment.getCreationDate(), attachment.getVersionComment(), attachment.getLabels());
        remoteAttachmentManifest.setLocalId(String.valueOf(attachment.getId()));
        return remoteAttachmentManifest;
    }

    private MultipartEntityBuilder generateAttachmentForUpload(Attachment attachment, byte[] data) {
        MultipartEntityBuilder multiPartEntityBuilder = MultipartEntityBuilder.create();
        multiPartEntityBuilder.addBinaryBody("file", data, ContentType.DEFAULT_BINARY, attachment.getFileName());
        return multiPartEntityBuilder;
    }

    private List<NameValuePair> movePageRequestBody(String pageId, String targetId, String position) {
        ArrayList<NameValuePair> form = new ArrayList<NameValuePair>();
        form.add((NameValuePair)new BasicNameValuePair("pageId", pageId));
        form.add((NameValuePair)new BasicNameValuePair("targetId", targetId));
        form.add((NameValuePair)new BasicNameValuePair(POSITION, position));
        return form;
    }

    private JsonObject generateUpdatesForAttachment(Attachment attachment, String remoteVersion, String remoteId) {
        JsonObject updatedAttachment = new JsonObject();
        updatedAttachment.addProperty("id", remoteId);
        updatedAttachment.addProperty("title", attachment.getFileName());
        JsonObject version = new JsonObject();
        version.addProperty("number", remoteVersion);
        updatedAttachment.add("version", (JsonElement)version);
        JsonObject metadata = new JsonObject();
        metadata.addProperty("comment", attachment.getVersionComment());
        updatedAttachment.add("metadata", (JsonElement)metadata);
        return updatedAttachment;
    }

    private MultipartEntityBuilder generateAttachmentDataUpdateForUpload(Attachment attachment, byte[] data) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addBinaryBody("file", data, ContentType.DEFAULT_BINARY, attachment.getFileName());
        return multipartEntityBuilder;
    }

    private JsonObject attachmentDataUpdate(Attachment attachment, byte[] data, String pageId, RemoteAttachmentManifest attachmentManifest) {
        return this.restApiAction.httpPostPetition(this.generateAttachmentDataUpdateForUpload(attachment, data), RestApiAction.UPDATE_ATTACHMENT_DATA, true, true, attachment, pageId, attachmentManifest.getId());
    }

    private JsonObject attachmentFileNameAndCommentUpdate(String pageId, Attachment attachment, RemoteAttachmentManifest attachmentManifest) {
        StringEntity stringEntity = new StringEntity(this.generateUpdatesForAttachment(attachment, String.valueOf(attachmentManifest.getVersion()), String.valueOf(attachmentManifest.getId())).toString(), ContentType.APPLICATION_JSON);
        return this.restApiAction.httpPutPetition(stringEntity, RestApiAction.UPDATE_ATTACHMENT_PROPERTIES, pageId, String.valueOf(attachmentManifest.getId()));
    }

    @Override
    public void doLogin() {
        JsonObject response = this.restApiAction.httpPostPetition(RestApiAction.LOGIN, false, false, new String[0]);
        if (response == null) {
            throw new RemotePublishingException("could not login as '" + HtmlUtil.htmlEncode((String)this.credentials.getLoginUserName()) + "' with the given password please check username and password combination");
        }
    }

    @Override
    public void doLogout() {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.LOGOUT, false, false, new String[0]);
        if (response == null) {
            throw new RemotePublishingException("could not do logout");
        }
    }

    @Override
    public void checkRemoteSpace() {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CHECK_SPACE, false, false, this.credentials.getRemoteSpaceKey());
        if (response == null) {
            throw new RemotePublishingException("space with key '" + HtmlUtil.htmlEncode((String)this.credentials.getRemoteSpaceKey()) + "' does not exist, or user not allowed to view the space");
        }
    }

    @Override
    public void checkRemoteSpacePermissions() {
        StringEntity stringEntity = new StringEntity(this.restModelComponent.generatePageForCreation("Remote Publishing Permission Test Page", "", 0L, this.credentials).toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPostPetition(stringEntity, RestApiAction.CREATE_CONTENT, true, false, new String[0]);
        if (response == null || !response.has("id")) {
            throw new RemotePublishingException("user '" + HtmlUtil.htmlEncode((String)this.credentials.getLoginUserName()) + "' cannot create pages in space '" + HtmlUtil.htmlEncode((String)(this.credentials.getRemoteSpaceKey() + "'")));
        }
        this.restApiAction.httpDeletePetition(RestApiAction.DELETE_CONTENT, false, response.get("id").getAsString());
        this.restApiAction.httpDeletePetition(RestApiAction.REMOVE_FROM_TRASH, false, response.get("id").getAsString());
    }
}

