/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.macro;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.RemotePublishingManager;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfigurationManager;
import com.comalatech.confluence.remotepublishing.macro.AbstractRemotePublishingNoBodyBaseMacro;
import com.comalatech.confluence.remotepublishing.macro.RemotePublishingMacroHelper;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRemovePageMacro
extends AbstractRemotePublishingNoBodyBaseMacro {
    private static final Logger log = LoggerFactory.getLogger(RemoteRemovePageMacro.class);
    private static final String PURGE_PARAM = "purgeFromTrash";
    private RemotePublishingManager remotePublishingManager;
    private RemotePublishingConfigurationManager remotePublishingConfigurationManager;

    @Override
    public String doExecute(Map parameters, RenderContext renderContext) throws MacroException {
        boolean purgeFromTrash = MapUtils.getBooleanValue((Map)parameters, (Object)PURGE_PARAM, (boolean)false);
        if (!RemotePublishingMacroHelper.inExecuteMode(renderContext)) {
            return "";
        }
        try {
            RemotePublishingConfiguration config = RemotePublishingMacroHelper.getRemoteCredentials(parameters, renderContext, this.remotePublishingConfigurationManager);
            if (config == null) {
                throw new MacroException("need to define remote publishing configuration before using remotepublishing macro");
            }
            AbstractPage page = this.getAbstractPage(renderContext);
            this.remotePublishingManager.unpublish(config, page, purgeFromTrash);
        }
        catch (RemotePublishingException e) {
            RemotePublishingMacroHelper.logErrorMessageToWorkflowEngine(e.getMessage(), renderContext);
            throw new MacroException(e.getMessage());
        }
        catch (Exception e) {
            RemotePublishingMacroHelper.logErrorMessageToWorkflowEngine(e.toString(), renderContext);
            log.error(e.getMessage(), (Throwable)e);
            throw new MacroException((Throwable)e);
        }
        return "";
    }

    public void setRemotePublishingManager(RemotePublishingManager remotePublishingManager) {
        this.remotePublishingManager = remotePublishingManager;
    }

    public void setRemotePublishingConfigurationManager(RemotePublishingConfigurationManager remotePublishingConfigurationManager) {
        this.remotePublishingConfigurationManager = remotePublishingConfigurationManager;
    }
}

