/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.macro;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfiguration;
import com.comalatech.confluence.remotepublishing.config.RemotePublishingConfigurationManager;
import com.comalatech.confluence.remotepublishing.credentials.Credentials;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class RemotePublishingMacroHelper {
    public static final String LOG_KEY = "com.comalatech.log";
    public static final String PROPERTIES_KEY = "com.comalatech.workflow.properties.publishing";
    public static final String EXECUTE_KEY = "com.comalatech.execute";

    public static RemotePublishingConfiguration getRemoteCredentials(Map parameters, RenderContext renderContext, RemotePublishingConfigurationManager remotePublishingConfigurationManager) {
        RemotePublishingConfiguration config = null;
        if (renderContext instanceof PageContext) {
            Map credentialsMap;
            PageContext pageContext = (PageContext)renderContext;
            String configName = (String)parameters.get("0");
            config = remotePublishingConfigurationManager.getSpaceConfiguration(pageContext.getSpaceKey(), configName);
            if (config == null && (credentialsMap = (Map)renderContext.getParam((Object)PROPERTIES_KEY)) != null) {
                Credentials credentials = new Credentials(credentialsMap);
                config = new RemotePublishingConfiguration("", credentials);
            }
            if (config != null && config.getCredentials() != null) {
                config.getCredentials().override(parameters);
            }
        }
        return config;
    }

    public static void logErrorMessageToWorkflowEngine(String message, RenderContext renderContext) {
        String existingMessage = (String)renderContext.getParam((Object)LOG_KEY);
        if (TextUtils.stringSet((String)existingMessage)) {
            message = existingMessage + "\n" + message;
        }
        renderContext.addParam((Object)LOG_KEY, (Object)message);
    }

    public static boolean inExecuteMode(RenderContext renderContext) {
        return renderContext.getParam((Object)EXECUTE_KEY) != null;
    }
}

