/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence.manifest;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.remotepublishing.confluence.manifest.RemoteManifestOperation;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.RestApiAction;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Date;
import org.joda.time.DateTime;

public class AttachmentManifestOperation
implements RemoteManifestOperation {
    private RemotePageManifest remotePageManifest;
    private ApiAction restApiAction;
    private String paginationStart = "0";
    private String paginationEnd = "50";

    public AttachmentManifestOperation(ApiAction apiAction, RemotePageManifest remotePageManifest) {
        this.restApiAction = apiAction;
        this.remotePageManifest = remotePageManifest;
    }

    @Override
    public void add() {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_ATTACHMENTS, true, false, this.remotePageManifest.getPageId(), this.paginationStart, this.paginationEnd);
        if (response != null) {
            boolean hasMore = response.get("_links").getAsJsonObject().has("next");
            JsonArray attachments = response.get("results").getAsJsonArray();
            for (JsonElement attachment : attachments) {
                this.remotePageManifest.addAttachment(this.buildRemoteAttachmentManifest(attachment, this.remotePageManifest.getPageId()));
            }
            while (hasMore) {
                response = this.restApiAction.httpGetPetition(response.get("_links").getAsJsonObject().get("next").getAsString(), true, false, new String[0]);
                attachments = response.get("results").getAsJsonArray();
                for (JsonElement attachment : attachments) {
                    this.remotePageManifest.addAttachment(this.buildRemoteAttachmentManifest(attachment, this.remotePageManifest.getPageId()));
                }
                hasMore = response.get("_links").getAsJsonObject().has("next");
            }
        }
    }

    private RemoteAttachmentManifest buildRemoteAttachmentManifest(JsonElement attachment, String manifestPageId) {
        String id = attachment.getAsJsonObject().get("id").getAsString();
        String fileName = attachment.getAsJsonObject().get("title").getAsString();
        int fileSize = attachment.getAsJsonObject().get("extensions").getAsJsonObject().get("fileSize").getAsInt();
        JsonObject requestRemoteAttachmentData = this.restApiAction.httpGetPetition(RestApiAction.ATTACHMENT_DATA, true, false, manifestPageId, fileName);
        JsonObject remoteAttachmentData = requestRemoteAttachmentData.get("results").getAsJsonArray().get(0).getAsJsonObject();
        String createdDateString = remoteAttachmentData.get("history").getAsJsonObject().get("createdDate").getAsString();
        Date createdDate = DateTime.parse((String)createdDateString).toDate();
        int version = remoteAttachmentData.get("version").getAsJsonObject().get("number").getAsInt();
        JsonObject metadata = attachment.getAsJsonObject().get("metadata").getAsJsonObject();
        String comment = "";
        ArrayList<Label> labelList = new ArrayList<Label>();
        if (metadata != null) {
            JsonElement results;
            JsonElement labels;
            JsonElement commentJson = metadata.get("comment");
            if (commentJson != null) {
                comment = commentJson.getAsString();
            }
            if ((labels = metadata.get("labels")) != null && (results = labels.getAsJsonObject().get("results")) != null) {
                JsonArray labelsJson = results.getAsJsonArray();
                labelsJson.forEach(l -> labelList.add(new Label(l.getAsJsonObject().get("name").getAsString(), l.getAsJsonObject().get("prefix").getAsString())));
            }
        }
        return new RemoteAttachmentManifest(id, fileName, version, fileSize, createdDate, comment, labelList);
    }
}

