/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.model;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemotePageManifest {
    String title;
    String version;
    String pageId;
    String parentId;
    String parentTitle;
    String url;
    String spaceKey;
    String spaceId;
    List<RemoteAttachmentManifest> attachments;
    List<Label> labels;

    public RemotePageManifest(String title, String version) {
        this.title = title;
        this.version = version;
        this.attachments = new ArrayList<RemoteAttachmentManifest>();
    }

    public RemotePageManifest() {
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setAttachments(List<RemoteAttachmentManifest> attachments) {
        this.attachments = attachments;
    }

    public RemoteAttachmentManifest getAttachment(String filename) {
        return this.attachments.stream().filter(a -> a.getFilename().equals(filename)).findFirst().orElse(null);
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public List<RemoteAttachmentManifest> getAttachments() {
        return this.attachments;
    }

    public void addAttachment(RemoteAttachmentManifest remoteAttachmentManifest) {
        this.attachments.add(remoteAttachmentManifest);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setParentTitle(String parentTitle) {
        this.parentTitle = parentTitle;
    }

    public String getParentTitle() {
        return this.parentTitle;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemotePageManifest that = (RemotePageManifest)o;
        return this.title.equals(that.title) && this.version.equals(that.version) && this.pageId.equals(that.pageId) && this.parentId.equals(that.parentId) && Objects.equals(this.parentTitle, that.parentTitle) && this.url.equals(that.url) && Objects.equals(this.spaceKey, that.spaceKey) && Objects.equals(this.spaceId, that.spaceId) && Objects.equals(this.attachments, that.attachments) && Objects.equals(this.labels, that.labels);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.version, this.pageId, this.parentId, this.parentTitle, this.url, this.spaceKey, this.spaceId, this.attachments, this.labels);
    }
}

