/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.credentials;

import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Credentials
implements Cloneable {
    public static final String URL = "url";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String SPACE_KEY = "space";
    public static final String REMOTE_USER = "remoteuser";
    private String url;
    private String loginUserName;
    private String password;
    private String remoteSpaceKey;
    private String remoteUserName;

    public Credentials(String url, String loginUserName, String password, String remoteSpaceKey, String remoteUserName) {
        this.url = url;
        this.loginUserName = loginUserName;
        this.password = password;
        this.remoteSpaceKey = remoteSpaceKey;
        this.remoteUserName = remoteUserName;
    }

    public Credentials(Map map) {
        this.url = (String)map.get(URL);
        this.loginUserName = (String)map.get(USER);
        this.password = (String)map.get(PASSWORD);
        this.remoteSpaceKey = (String)map.get(SPACE_KEY);
        this.remoteUserName = (String)map.get(REMOTE_USER);
    }

    public Credentials() {
    }

    public void validate() throws Exception {
        this.validate(this.url, URL);
        this.validate(this.loginUserName, USER);
        this.validate(this.password, PASSWORD);
        this.validate(this.remoteSpaceKey, SPACE_KEY);
        this.validate(this.remoteUserName, REMOTE_USER);
    }

    public void override(Map parameters) {
        String value = (String)parameters.get(URL);
        if (value != null) {
            this.url = value;
        }
        if ((value = (String)parameters.get(USER)) != null) {
            this.loginUserName = value;
        }
        if ((value = (String)parameters.get(PASSWORD)) != null) {
            this.password = value;
        }
        if ((value = (String)parameters.get(SPACE_KEY)) != null) {
            this.remoteSpaceKey = value;
        }
        if ((value = (String)parameters.get(REMOTE_USER)) != null) {
            this.remoteUserName = value;
        }
        if (!TextUtils.stringSet((String)this.remoteUserName)) {
            this.remoteUserName = this.loginUserName;
        }
    }

    private void validate(String value, String name) throws Exception {
        if (!TextUtils.stringSet((String)value)) {
            throw new Exception(name + " not set");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getLoginUserName() {
        return this.loginUserName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRemoteSpaceKey() {
        return this.remoteSpaceKey;
    }

    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setLoginUserName(String loginUserName) {
        this.loginUserName = loginUserName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRemoteSpaceKey(String remoteSpaceKey) {
        this.remoteSpaceKey = remoteSpaceKey;
    }

    public void setRemoteUserName(String remoteUserName) {
        this.remoteUserName = remoteUserName;
    }

    public Map toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(URL, this.url);
        map.put(USER, this.loginUserName);
        map.put(PASSWORD, this.password);
        map.put(SPACE_KEY, this.remoteSpaceKey);
        map.put(REMOTE_USER, this.remoteUserName);
        return map;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        try {
            Credentials clone = (Credentials)this.clone();
            clone.setPassword("*****");
            return ToStringBuilder.reflectionToString((Object)clone);
        }
        catch (CloneNotSupportedException var2) {
            return "Credentials(" + this.url + "," + this.loginUserName + ")";
        }
    }
}

