/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.remotepublishing.confluence;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.util.HtmlUtil;
import com.comalatech.confluence.remotepublishing.RemotePublishingException;
import com.comalatech.confluence.remotepublishing.confluence.ConfluenceRestRemotePublisher;
import com.comalatech.confluence.remotepublishing.confluence.manifest.AncestorManifestOperation;
import com.comalatech.confluence.remotepublishing.confluence.manifest.AttachmentManifestOperation;
import com.comalatech.confluence.remotepublishing.confluence.manifest.LabelManifestOperation;
import com.comalatech.confluence.remotepublishing.confluence.manifest.RemoteManifestOperationExecutor;
import com.comalatech.confluence.remotepublishing.credentials.Credentials;
import com.comalatech.confluence.remotepublishing.model.RemoteAttachmentManifest;
import com.comalatech.confluence.remotepublishing.model.RemotePageManifest;
import com.comalatech.confluence.remotepublishing.utils.RestApiAction;
import com.comalatech.confluence.remotepublishing.utils.contracts.ApiAction;
import com.comalatech.confluence.remotepublishing.utils.factory.ApiActionFactory;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfluenceRestRemotePublisher
implements ConfluenceRestRemotePublisher {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfluenceRestRemotePublisher.class);
    private Credentials credentials;
    private final ApiAction restApiAction;
    private final RemoteManifestOperationExecutor remoteManifestOperationExecutor;

    public DefaultConfluenceRestRemotePublisher(ApiActionFactory apiActionFactory) {
        this.restApiAction = apiActionFactory.getApiAction();
        this.remoteManifestOperationExecutor = new RemoteManifestOperationExecutor();
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
        this.restApiAction.setRemoteCredentials(credentials);
    }

    @Override
    public RemotePageManifest createRemote(AbstractPage absPage) {
        log.debug("Adding '" + absPage.getTitle() + "'(" + absPage.getSpaceKey() + ")");
        if (absPage instanceof Page) {
            RemotePageManifest manifest = this.createRemotePage((Page)absPage);
            if (manifest != null) {
                return manifest;
            }
            throw new RemotePublishingException("create remote page failed");
        }
        if (absPage instanceof BlogPost) {
            RemotePageManifest manifest = this.createRemoteBlogPost((BlogPost)absPage);
            if (manifest != null) {
                return manifest;
            }
            throw new RemotePublishingException("create remote blogpost failed");
        }
        return null;
    }

    private RemotePageManifest createRemotePage(Page page) {
        long remoteParentPageId = 0L;
        if (page.getAncestors().size() > 0) {
            remoteParentPageId = this.getRemotePageId(((Page)page.getAncestors().get(page.getAncestors().size() - 1)).getTitle());
        }
        String bodyContent = page.getBodyAsString();
        StringEntity stringEntity = new StringEntity(this.generatePageForCreation(page.getTitle(), bodyContent, remoteParentPageId).toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPostPetition(stringEntity, RestApiAction.CREATE_CONTENT, true, false, new String[0]);
        if (response != null && response.has("id")) {
            List<Page> remotePublishedChilds;
            if (!page.getLabels().isEmpty()) {
                this.addRemoteLabels(response.get("id").getAsString(), page.getLabels());
            }
            if ((remotePublishedChilds = this.getRemotePublishedChilds(page)).size() != 0) {
                this.changeParentForPublishedChilds(remotePublishedChilds, response.get("id").getAsLong());
                this.reorderPagesInRemote(page, remotePublishedChilds, response.get("id").getAsString());
            }
            if (page.getParent() != null) {
                this.reorderParentPagesAfterPageUpdate(page.getParent());
            }
            return this.createRemotePageManifest(page, response);
        }
        return null;
    }

    private void reorderPagesInRemote(Page page, List<Page> remotePublishedChilds, String parentId) {
        String lastSortedPageId = null;
        List<Page> sortedPublishedPages = this.getSortedPublishedPages(page, remotePublishedChilds);
        for (Page child : sortedPublishedPages) {
            lastSortedPageId = lastSortedPageId == null ? this.appendPage(child, parentId) : this.putPageBelow(child, lastSortedPageId);
        }
    }

    private List<Page> getSortedPublishedPages(Page page, List<Page> remotePublishedChilds) {
        List sortedPublishedPages = page.getSortedChildren();
        for (Page child : page.getSortedChildren()) {
            if (remotePublishedChilds.contains(child)) continue;
            sortedPublishedPages.remove(child);
        }
        return sortedPublishedPages;
    }

    private String appendPage(Page page, String parentId) {
        String lastSortedPageId = String.valueOf(this.getRemotePageId(page.getTitle()));
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_INFO, true, false, lastSortedPageId);
        String positionInRemote = response.get("extensions").getAsJsonObject().get("position").getAsString();
        String string = positionInRemote = positionInRemote.equals("none") || page.getAncestors() == null ? "-1" : positionInRemote;
        if (Integer.parseInt(positionInRemote) != page.getParent().getSortedChildren().indexOf(page) && (response = this.restApiAction.httpPostPetition(this.movePageRequestBody(lastSortedPageId, parentId, "append"), RestApiAction.MOVE_PAGE, true, true)) == null) {
            log.error("There has been an error moving the page " + lastSortedPageId);
        }
        return lastSortedPageId;
    }

    private String putPageBelow(Page page, String lastSortedPageId) {
        String pageToMoveId = String.valueOf(this.getRemotePageId(page.getTitle()));
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_INFO, true, false, pageToMoveId);
        String positionInRemote = response.get("extensions").getAsJsonObject().get("position").getAsString();
        positionInRemote = positionInRemote.equals("none") ? "0" : positionInRemote;
        RemotePageManifest manifest = this.getRemoteContentManifest((AbstractPage)page);
        if (manifest != null && (Integer.parseInt(positionInRemote) != page.getParent().getSortedChildren().indexOf(page) || manifest.getParentTitle() != null && !manifest.getParentTitle().equals(page.getParent().getTitle())) && (response = this.restApiAction.httpPostPetition(this.movePageRequestBody(pageToMoveId, lastSortedPageId, "below"), RestApiAction.MOVE_PAGE, true, true)) == null) {
            log.error("There has been an error moving the page " + pageToMoveId);
        }
        return pageToMoveId;
    }

    private RemotePageManifest createRemoteBlogPost(BlogPost blog) {
        String bodyContent = blog.getBodyAsString();
        StringEntity stringEntity = new StringEntity(this.generateBlogForCreation(blog.getTitle(), bodyContent).toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPostPetition(stringEntity, RestApiAction.CREATE_CONTENT, true, false, new String[0]);
        if (!blog.getLabels().isEmpty() && response != null && response.has("id")) {
            try {
                this.addRemoteLabels(response.get("id").getAsString(), blog.getLabels());
            }
            catch (RemotePublishingException e) {
                log.error(e.getMessage(), e.getCause());
            }
        }
        RemotePageManifest manifest = this.createRemoteBlogManifest(response);
        manifest.setLabels(this.filterPersonalLabels(blog.getLabels()));
        return manifest;
    }

    @Override
    public RemotePageManifest updateRemote(AbstractPage absPage, RemotePageManifest manifest) throws RemotePublishingException {
        if (log.isDebugEnabled()) {
            log.debug("Updating: " + absPage);
            log.debug("Current Publishing Info: " + manifest);
        }
        if (absPage instanceof Page) {
            RemotePageManifest updatedManifest = this.updateRemotePage((Page)absPage, manifest);
            if (updatedManifest != null) {
                return updatedManifest;
            }
            throw new RemotePublishingException("update remote page failed");
        }
        if (absPage instanceof BlogPost) {
            RemotePageManifest updatedManifest = this.updateRemoteBlogPost((BlogPost)absPage, manifest);
            if (updatedManifest != null) {
                return updatedManifest;
            }
            throw new RemotePublishingException("update remote blogpost failed");
        }
        return null;
    }

    private RemotePageManifest updateRemotePage(Page page, RemotePageManifest manifest) {
        String remotePageId = manifest.getPageId();
        String remoteParentPageId = "0";
        if (page.getParent() != null) {
            if (!page.getParent().getTitle().equals(manifest.getParentTitle())) {
                long parentId = this.getRemotePageId(page.getParent().getTitle());
                if (parentId != 0L) {
                    remoteParentPageId = String.valueOf(parentId);
                }
            } else {
                remoteParentPageId = manifest.getParentId();
            }
        }
        manifest.setParentId(remoteParentPageId);
        String parentForUpdatingPage = !remoteParentPageId.equals("0") ? remoteParentPageId : manifest.getSpaceId();
        String bodyContent = page.getBodyAsString();
        StringEntity stringEntity = new StringEntity(this.generateUpdate(manifest.getVersion(), page.getTitle(), bodyContent, "page", parentForUpdatingPage).toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPutPetition(stringEntity, RestApiAction.UPDATE_CONTENT, remotePageId);
        if (response != null && response.has("id")) {
            this.updateLabels(manifest.getPageId(), page.getLabels(), manifest.getLabels());
            List<Page> remotePublishedChilds = this.getRemotePublishedChilds(page);
            if (remotePublishedChilds.size() != 0) {
                this.reorderPagesInRemote(page, remotePublishedChilds, manifest.getPageId());
            }
            if (page.getParent() != null) {
                this.reorderParentPagesAfterPageUpdate(page.getParent());
            }
            return this.updateRemotePageManifest(page, manifest);
        }
        return null;
    }

    private void reorderParentPagesAfterPageUpdate(Page page) {
        List<Page> remotePublishedChilds = this.getRemotePublishedChilds(page);
        long parentId = this.getRemotePageId(page.getTitle());
        if (parentId != 0L) {
            this.reorderPagesInRemote(page, remotePublishedChilds, String.valueOf(parentId));
        }
    }

    private RemotePageManifest updateRemoteBlogPost(BlogPost blog, RemotePageManifest manifest) {
        String remotePageId = manifest.getPageId();
        String bodyContent = blog.getBodyAsString();
        StringEntity stringEntity = new StringEntity(this.generateUpdate(manifest.getVersion(), blog.getTitle(), bodyContent, "blogpost", "").toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPutPetition(stringEntity, RestApiAction.UPDATE_CONTENT, remotePageId);
        if (response != null) {
            this.updateLabels(manifest.getPageId(), blog.getLabels(), manifest.getLabels());
            return this.updateRemoteBlogManifest(blog, manifest);
        }
        return null;
    }

    @Override
    public RemotePageManifest getRemoteContentManifest(AbstractPage abstractPage, RemotePageManifest publishHistoryInfo) {
        long remotePageId;
        RemotePageManifest remotePageManifest = null;
        if (!(publishHistoryInfo == null || (remotePageManifest = this.getRemoteContentManifest(publishHistoryInfo.getPageId())) != null && remotePageManifest.getTitle().equals(publishHistoryInfo.getTitle()) || (remotePageId = this.getRemotePageId(publishHistoryInfo.getTitle())) == 0L)) {
            remotePageManifest = this.getRemoteContentManifest(String.valueOf(remotePageId));
        }
        if (remotePageManifest == null) {
            remotePageManifest = this.getRemoteContentManifest(abstractPage);
        }
        return remotePageManifest;
    }

    private RemotePageManifest getRemoteContentManifest(AbstractPage absPage) {
        log.debug("Getting content from '" + absPage.getTitle() + "'(" + absPage.getSpaceKey() + ")");
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_EXIST, true, false, this.credentials.getRemoteSpaceKey(), absPage.getTitle());
        if (response != null) {
            if (!response.has("size") || response.get("size").getAsInt() == 0) {
                return null;
            }
            String contentId = response.get("results").getAsJsonArray().get(0).getAsJsonObject().get("id").getAsString();
            if (absPage instanceof Page) {
                return this.getRemoteContentManifest(contentId);
            }
            if (absPage instanceof BlogPost) {
                RemotePageManifest manifest = this.createRemoteBlogManifest(response);
                this.remoteManifestOperationExecutor.addOperation(new LabelManifestOperation(this.restApiAction, manifest, contentId));
                return manifest;
            }
        }
        return null;
    }

    private RemotePageManifest getRemoteContentManifest(String pageId) {
        log.debug("Getting content from '" + pageId);
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_INFO, true, false, pageId);
        if (response != null && response.has("id")) {
            if (response.get("type").getAsString().equals("page")) {
                RemotePageManifest manifest = this.generatePageManifest(response);
                this.remoteManifestOperationExecutor.addOperation(new AncestorManifestOperation(this.restApiAction, manifest, pageId));
                this.remoteManifestOperationExecutor.addOperation(new LabelManifestOperation(this.restApiAction, manifest, pageId));
                this.remoteManifestOperationExecutor.addOperation(new AttachmentManifestOperation(this.restApiAction, manifest));
                return manifest;
            }
            RemotePageManifest manifest = this.createRemoteBlogManifest(response);
            this.remoteManifestOperationExecutor.addOperation(new LabelManifestOperation(this.restApiAction, manifest, pageId));
            this.remoteManifestOperationExecutor.addOperation(new AttachmentManifestOperation(this.restApiAction, manifest));
            return manifest;
        }
        return null;
    }

    private boolean isPersonalLabel(Label label) {
        return this.isPersonalLabel(label.getNamespace().getPrefix());
    }

    private boolean isPersonalLabel(String prefix) {
        return Namespace.PERSONAL.getPrefix().equals(prefix);
    }

    private void addRemoteLabels(String remoteContentId, List<Label> labelList) {
        log.debug("Adding labels of '" + remoteContentId);
        if (labelList.size() == 0) {
            return;
        }
        JsonArray labelArray = new JsonArray();
        for (Label label : this.filterPersonalLabels(labelList)) {
            labelArray.add((JsonElement)this.generateLabelToAdd(label));
        }
        if (labelArray.size() == 0) {
            return;
        }
        StringEntity stringEntity = new StringEntity(labelArray.toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPostPetition(stringEntity, RestApiAction.ADD_LABEL, true, false, remoteContentId);
        if (response == null) {
            log.error("add labels failed");
        }
    }

    private List<Label> filterPersonalLabels(List<Label> labels) {
        ArrayList<Label> ret = new ArrayList<Label>();
        for (Label label : labels) {
            if (this.isPersonalLabel(label)) continue;
            ret.add(label);
        }
        return ret;
    }

    private void updateLabels(String pageId, List<Label> draftLabels, List<Label> publishedLabels) {
        log.debug("Updating labels of '" + pageId);
        if (draftLabels != null && draftLabels.size() != 0) {
            this.addRemoteLabels(pageId, this.getLabelsToAddList(draftLabels, publishedLabels));
        }
        if (publishedLabels != null && publishedLabels.size() != 0) {
            this.removeRemoteLabels(pageId, this.getLabelsToRemoveList(draftLabels, publishedLabels));
        }
    }

    private void removeRemoteLabels(String remoteContentId, List<Label> labelsToRemove) throws RemotePublishingException {
        log.debug("Removing labels of '" + remoteContentId);
        if (labelsToRemove.size() == 0) {
            return;
        }
        for (Label label : labelsToRemove) {
            JsonObject response = this.restApiAction.httpDeletePetition(RestApiAction.REMOVE_LABEL, false, remoteContentId, label.getName());
            if (response != null) continue;
            throw new RemotePublishingException("remove labels failed");
        }
    }

    private JsonObject generateLabelToAdd(Label label) {
        JsonObject labelJson = new JsonObject();
        labelJson.addProperty("prefix", label.getNamespace().getPrefix());
        labelJson.addProperty("name", label.getName());
        return labelJson;
    }

    private List<Label> getLabelsToAddList(List<Label> draftLabels, List<Label> publishedLabels) {
        ArrayList<Label> labelsToAdd = new ArrayList<Label>();
        for (Label label : draftLabels) {
            if (publishedLabels.contains(label)) continue;
            labelsToAdd.add(label);
        }
        return labelsToAdd;
    }

    private List<Label> getLabelsToRemoveList(List<Label> draftLabels, List<Label> publishedLabels) {
        ArrayList<Label> labelsToRemove = new ArrayList<Label>();
        for (Label label : this.filterPersonalLabels(publishedLabels)) {
            if (draftLabels.contains(label)) continue;
            labelsToRemove.add(label);
        }
        return labelsToRemove;
    }

    private void changeParentForPublishedChilds(List<Page> publishedChildPages, long remoteParentPageId) {
        for (Page child : publishedChildPages) {
            StringEntity stringEntity = new StringEntity(this.generatePageToUpdateAncestors(this.getRemotePageVersion(child.getTitle()) + 1L, remoteParentPageId, child.getTitle()).toString(), ContentType.APPLICATION_JSON);
            String pageId = String.valueOf(this.getRemotePageId(child.getTitle()));
            if (pageId.equals("0")) continue;
            this.restApiAction.httpPutPetition(stringEntity, RestApiAction.UPDATE_CONTENT, pageId);
        }
    }

    @Override
    public void removeRemote(String pageId, Boolean purgeFromTrash) throws RemotePublishingException {
        log.debug("Removing '" + pageId + "'(purge from trash: " + purgeFromTrash + ")");
        JsonObject response = this.restApiAction.httpDeletePetition(RestApiAction.DELETE_CONTENT, false, pageId);
        if (purgeFromTrash.booleanValue() && response != null) {
            response = this.restApiAction.httpDeletePetition(RestApiAction.REMOVE_FROM_TRASH, false, pageId);
        }
        if (response == null) {
            throw new RemotePublishingException("remove remote failed");
        }
    }

    private List<Page> getRemotePublishedChilds(Page page) {
        ArrayList<Page> remotePublishedChilds = new ArrayList<Page>();
        for (Page child : page.getChildren()) {
            if (!this.remotePageExists(child.getTitle()).booleanValue()) continue;
            remotePublishedChilds.add(child);
        }
        return remotePublishedChilds;
    }

    private Boolean remotePageExists(String title) {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_EXIST, true, false, this.credentials.getRemoteSpaceKey(), title);
        return response.get("size").getAsLong() != 0L;
    }

    private long getRemotePageId(String pageTitle) {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_EXIST, true, false, this.credentials.getRemoteSpaceKey(), pageTitle);
        if (response == null) {
            return 0L;
        }
        if (response.get("size").getAsInt() == 0 || !response.has("results")) {
            return 0L;
        }
        return response.get("results").getAsJsonArray().get(0).getAsJsonObject().get("id").getAsLong();
    }

    private long getRemotePageVersion(String pageTitle) {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CONTENT_VERSION, true, false, this.credentials.getRemoteSpaceKey(), pageTitle);
        return response.get("results").getAsJsonArray().get(0).getAsJsonObject().get("version").getAsJsonObject().get("number").getAsLong();
    }

    private JsonObject generatePageForCreation(String pageTitle, String pageContent, long remoteParentPageId) {
        JsonObject newPage = new JsonObject();
        newPage.addProperty("type", "page");
        newPage.addProperty("title", pageTitle);
        JsonArray parentPageArray = new JsonArray();
        JsonObject parentPage = new JsonObject();
        parentPage.addProperty("type", "page");
        parentPage.addProperty("id", (Number)remoteParentPageId);
        parentPageArray.add((JsonElement)parentPage);
        newPage.add("ancestors", (JsonElement)parentPageArray);
        JsonObject spaceObj = new JsonObject();
        spaceObj.addProperty("key", this.credentials.getRemoteSpaceKey());
        newPage.add("space", (JsonElement)spaceObj);
        JsonObject storageObj = new JsonObject();
        storageObj.addProperty("value", pageContent);
        storageObj.addProperty("representation", "storage");
        JsonObject bodyObj = new JsonObject();
        bodyObj.add("storage", (JsonElement)storageObj);
        newPage.add("body", (JsonElement)bodyObj);
        return newPage;
    }

    private JsonObject generateBlogForCreation(String blogTitle, String pageContent) {
        JsonObject newBlog = new JsonObject();
        newBlog.addProperty("type", "blogpost");
        newBlog.addProperty("title", blogTitle);
        JsonObject spaceObj = new JsonObject();
        spaceObj.addProperty("key", this.credentials.getRemoteSpaceKey());
        newBlog.add("space", (JsonElement)spaceObj);
        JsonObject storageObj = new JsonObject();
        storageObj.addProperty("value", pageContent);
        storageObj.addProperty("representation", "storage");
        JsonObject bodyObj = new JsonObject();
        bodyObj.add("storage", (JsonElement)storageObj);
        newBlog.add("body", (JsonElement)bodyObj);
        return newBlog;
    }

    private JsonObject generateUpdate(String version, String pageTitle, String pageContent, String pageType, String parentPageId) {
        JsonObject updatedPage = new JsonObject();
        updatedPage.addProperty("type", pageType);
        updatedPage.addProperty("title", pageTitle);
        JsonObject versionNumber = new JsonObject();
        long newVersion = Integer.parseInt(version) + 1;
        versionNumber.addProperty("number", (Number)newVersion);
        updatedPage.add("version", (JsonElement)versionNumber);
        if (pageType.equals("page")) {
            JsonArray parentPageArray = new JsonArray();
            JsonObject parentPage = new JsonObject();
            parentPage.addProperty("id", parentPageId);
            parentPageArray.add((JsonElement)parentPage);
            updatedPage.add("ancestors", (JsonElement)parentPageArray);
        }
        JsonObject bodyJson = new JsonObject();
        JsonObject storageJson = new JsonObject();
        storageJson.addProperty("value", pageContent);
        storageJson.addProperty("representation", "storage");
        bodyJson.add("storage", (JsonElement)storageJson);
        updatedPage.add("body", (JsonElement)bodyJson);
        return updatedPage;
    }

    private JsonObject generatePageToUpdateAncestors(long version, long parentPageId, String childPageTitle) {
        JsonObject updatedPage = new JsonObject();
        JsonObject versionNumber = new JsonObject();
        versionNumber.addProperty("number", (Number)version);
        updatedPage.add("version", (JsonElement)versionNumber);
        JsonArray parentPageArray = new JsonArray();
        JsonObject parentPage = new JsonObject();
        parentPage.addProperty("id", (Number)parentPageId);
        parentPageArray.add((JsonElement)parentPage);
        updatedPage.add("ancestors", (JsonElement)parentPageArray);
        updatedPage.addProperty("title", childPageTitle);
        updatedPage.addProperty("type", "page");
        return updatedPage;
    }

    private RemotePageManifest createRemotePageManifest(Page page, JsonObject response) {
        String version = response.get("version").getAsJsonObject().get("number").getAsString();
        String title = response.get("title").getAsString();
        String id = response.get("id").getAsString();
        String parentId = "0";
        String parentTitle = null;
        String spaceId = response.getAsJsonObject("space").get("id").getAsString();
        RemotePageManifest manifest = new RemotePageManifest(title, version);
        if (response.getAsJsonArray("ancestors").size() != 0) {
            parentId = response.getAsJsonArray("ancestors").get(0).getAsJsonObject().get("id").getAsString();
            parentTitle = response.getAsJsonArray("ancestors").get(0).getAsJsonObject().get("title").getAsString();
        }
        String url = response.get("_links").getAsJsonObject().get("webui").getAsString();
        manifest.setSpaceId(spaceId);
        manifest.setPageId(id);
        manifest.setParentId(parentId);
        manifest.setParentTitle(parentTitle);
        manifest.setUrl(url);
        manifest.setSpaceKey(this.credentials.getRemoteSpaceKey());
        manifest.setLabels(this.filterPersonalLabels(page.getLabels()));
        return manifest;
    }

    private RemotePageManifest generatePageManifest(JsonObject response) {
        String version = response.get("version").getAsJsonObject().get("number").getAsString();
        String title = response.get("title").getAsString();
        String id = response.get("id").getAsString();
        String spaceId = response.getAsJsonObject("space").get("id").getAsString();
        RemotePageManifest manifest = new RemotePageManifest(title, version);
        String url = response.get("_links").getAsJsonObject().get("webui").getAsString();
        manifest.setSpaceId(spaceId);
        manifest.setPageId(id);
        manifest.setUrl(url);
        manifest.setSpaceKey(this.credentials.getRemoteSpaceKey());
        return manifest;
    }

    private RemotePageManifest updateRemotePageManifest(Page page, RemotePageManifest manifest) {
        manifest.setTitle(page.getTitle());
        String version = String.valueOf(Integer.parseInt(manifest.getVersion()) + 1);
        manifest.setVersion(version);
        if (page.getParent() != null && manifest.getParentId() != null && !manifest.getParentId().equals("0")) {
            manifest.setParentTitle(page.getParent().getTitle());
        } else {
            manifest.setParentTitle(null);
        }
        manifest.setLabels(this.filterPersonalLabels(page.getLabels()));
        return manifest;
    }

    private RemotePageManifest createRemoteBlogManifest(JsonObject response) {
        String version = response.get("version").getAsJsonObject().get("number").getAsString();
        String title = response.get("title").getAsString();
        String id = response.get("id").getAsString();
        String url = this.credentials.getUrl() + response.get("_links").getAsJsonObject().get("webui").getAsString();
        RemotePageManifest manifest = new RemotePageManifest(title, version);
        manifest.setPageId(id);
        manifest.setUrl(url);
        manifest.setSpaceKey(this.credentials.getRemoteSpaceKey());
        return manifest;
    }

    private RemotePageManifest updateRemoteBlogManifest(BlogPost blog, RemotePageManifest manifest) {
        manifest.setTitle(blog.getTitle());
        String version = String.valueOf(Integer.parseInt(manifest.getVersion()) + 1);
        manifest.setVersion(version);
        manifest.setLabels(this.filterPersonalLabels(blog.getLabels()));
        return manifest;
    }

    @Override
    public RemoteAttachmentManifest addAttachment(String pageId, Attachment attachment, byte[] data) {
        log.debug("Adding attachment " + attachment.getFileName() + " to page with id " + pageId);
        MultipartEntityBuilder multipartEntityBuilder = this.generateAttachmentForUpload(attachment, data);
        JsonObject response = this.restApiAction.httpPostPetition(multipartEntityBuilder, RestApiAction.CREATE_ATTACHMENT, true, true, attachment, pageId);
        if (response != null && !response.has("statusCode")) {
            RemoteAttachmentManifest attachmentManifest = this.createRemoteAttachmentManifest(attachment, response);
            this.attachmentFileNameAndCommentUpdate(pageId, attachment, attachmentManifest);
            this.addRemoteLabels(attachmentManifest.getId(), attachment.getLabels());
            return attachmentManifest;
        }
        String message = "Check attachment size limit in Confluence's remote instance.";
        if (response != null && response.has("message")) {
            message = response.get("message").getAsString();
        }
        throw new RemotePublishingException("Adding attachment failed: " + attachment.getFileName() + " (" + attachment.getFileSize() + " bytes). " + message);
    }

    @Override
    public void updateAttachment(String pageId, Attachment attachment, RemoteAttachmentManifest attachmentManifest, byte[] data) {
        JsonObject response;
        log.debug("Updating attachment " + attachment.getFileName() + " to page with id " + pageId);
        if (attachment.getVersion() != attachmentManifest.getVersion() || attachment.getFileSize() != attachmentManifest.getSize()) {
            response = this.attachmentDataUpdate(attachment, data, pageId, attachmentManifest);
            if (response == null) {
                throw new RemotePublishingException("update attachment data failed");
            }
            attachmentManifest.setVersion(attachment.getVersion() + 1);
            attachmentManifest.setSize(attachment.getFileSize());
        }
        if (!attachment.getFileName().equals(attachmentManifest.getFilename()) || attachment.getVersionComment() != null && !attachment.getVersionComment().equals(attachmentManifest.getComment()) || attachment.getVersionComment() == null && attachmentManifest.getComment() != null) {
            response = this.attachmentFileNameAndCommentUpdate(pageId, attachment, attachmentManifest);
            if (response == null) {
                throw new RemotePublishingException("update attachment properties failed");
            }
            attachmentManifest.setComment(attachment.getVersionComment());
            attachmentManifest.setFilename(attachment.getFileName());
        }
        if (!attachment.getLabels().equals(attachmentManifest.getLabels())) {
            this.updateLabels(attachmentManifest.getId(), attachment.getLabels(), attachmentManifest.getLabels());
            attachmentManifest.setLabels(attachment.getLabels());
        }
        if (attachment.getId() != 0L) {
            attachmentManifest.setLocalId(String.valueOf(attachment.getId()));
        }
    }

    @Override
    public void deleteAttachment(String attachmentId) {
        log.debug("Deleting attachment " + attachmentId);
        JsonObject response = this.restApiAction.httpDeletePetition(RestApiAction.DELETE_CONTENT, false, attachmentId);
        if (response == null) {
            throw new RemotePublishingException("delete attachment failed");
        }
    }

    private RemoteAttachmentManifest createRemoteAttachmentManifest(Attachment attachment, JsonObject remoteAttachment) {
        String id = remoteAttachment.get("results").getAsJsonArray().get(0).getAsJsonObject().get("id").getAsString();
        String fileName = attachment.getFileName();
        String fileSize = String.valueOf(attachment.getFileSize());
        RemoteAttachmentManifest remoteAttachmentManifest = new RemoteAttachmentManifest(id, fileName, 1, Integer.parseInt(fileSize), attachment.getCreationDate(), attachment.getVersionComment(), attachment.getLabels());
        remoteAttachmentManifest.setLocalId(String.valueOf(attachment.getId()));
        return remoteAttachmentManifest;
    }

    private MultipartEntityBuilder generateAttachmentForUpload(Attachment attachment, byte[] data) {
        MultipartEntityBuilder multiPartEntityBuilder = MultipartEntityBuilder.create();
        multiPartEntityBuilder.addBinaryBody("file", data, ContentType.DEFAULT_BINARY, attachment.getFileName());
        return multiPartEntityBuilder;
    }

    private List<NameValuePair> movePageRequestBody(String pageId, String targetId, String position) {
        ArrayList<NameValuePair> form = new ArrayList<NameValuePair>();
        form.add((NameValuePair)new BasicNameValuePair("pageId", pageId));
        form.add((NameValuePair)new BasicNameValuePair("targetId", targetId));
        form.add((NameValuePair)new BasicNameValuePair("position", position));
        return form;
    }

    private JsonObject generateUpdatesForAttachment(Attachment attachment, String remoteVersion, String remoteId) {
        JsonObject updatedAttachment = new JsonObject();
        updatedAttachment.addProperty("id", remoteId);
        updatedAttachment.addProperty("title", attachment.getFileName());
        JsonObject version = new JsonObject();
        version.addProperty("number", remoteVersion);
        updatedAttachment.add("version", (JsonElement)version);
        JsonObject metadata = new JsonObject();
        metadata.addProperty("comment", attachment.getVersionComment());
        updatedAttachment.add("metadata", (JsonElement)metadata);
        return updatedAttachment;
    }

    private MultipartEntityBuilder generateAttachmentDataUpdateForUpload(Attachment attachment, byte[] data) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addBinaryBody("file", data, ContentType.DEFAULT_BINARY, attachment.getFileName());
        return multipartEntityBuilder;
    }

    private JsonObject attachmentDataUpdate(Attachment attachment, byte[] data, String pageId, RemoteAttachmentManifest attachmentManifest) {
        return this.restApiAction.httpPostPetition(this.generateAttachmentDataUpdateForUpload(attachment, data), RestApiAction.UPDATE_ATTACHMENT_DATA, true, true, attachment, pageId, attachmentManifest.getId());
    }

    private JsonObject attachmentFileNameAndCommentUpdate(String pageId, Attachment attachment, RemoteAttachmentManifest attachmentManifest) {
        StringEntity stringEntity = new StringEntity(this.generateUpdatesForAttachment(attachment, String.valueOf(attachmentManifest.getVersion()), String.valueOf(attachmentManifest.getId())).toString(), ContentType.APPLICATION_JSON);
        return this.restApiAction.httpPutPetition(stringEntity, RestApiAction.UPDATE_ATTACHMENT_PROPERTIES, pageId, String.valueOf(attachmentManifest.getId()));
    }

    @Override
    public void doLogin() {
        JsonObject response = this.restApiAction.httpPostPetition(RestApiAction.LOGIN, false, false, new String[0]);
        if (response == null) {
            throw new RemotePublishingException("could not login as '" + HtmlUtil.htmlEncode((String)this.credentials.getLoginUserName()) + "' with the given password please check username and password combination");
        }
    }

    @Override
    public void doLogout() {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.LOGOUT, false, false, new String[0]);
        if (response == null) {
            throw new RemotePublishingException("could not do logout");
        }
    }

    @Override
    public void checkRemoteSpace() {
        JsonObject response = this.restApiAction.httpGetPetition(RestApiAction.CHECK_SPACE, false, false, this.credentials.getRemoteSpaceKey());
        if (response == null) {
            throw new RemotePublishingException("space with key '" + HtmlUtil.htmlEncode((String)this.credentials.getRemoteSpaceKey()) + "' does not exist, or user not allowed to view the space");
        }
    }

    @Override
    public void checkRemoteSpacePermissions() {
        StringEntity stringEntity = new StringEntity(this.generatePageForCreation("Remote Publishing Permission Test Page", "", 0L).toString(), ContentType.APPLICATION_JSON);
        JsonObject response = this.restApiAction.httpPostPetition(stringEntity, RestApiAction.CREATE_CONTENT, true, false, new String[0]);
        if (response == null || !response.has("id")) {
            throw new RemotePublishingException("user '" + HtmlUtil.htmlEncode((String)this.credentials.getLoginUserName()) + "' cannot create pages in space '" + HtmlUtil.htmlEncode((String)(this.credentials.getRemoteSpaceKey() + "'")));
        }
        this.restApiAction.httpDeletePetition(RestApiAction.DELETE_CONTENT, false, response.get("id").getAsString());
        this.restApiAction.httpDeletePetition(RestApiAction.REMOVE_FROM_TRASH, false, response.get("id").getAsString());
    }
}

