/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

/**
 * Stuff to handle the instructions in the RTE
 */
var requirejs = require || requirejs;

requirejs(['cp', 'jquery'], function (CP, $) {
    "use strict";
    function loadInstructions() {
        
        
        // Only show message when there is a source space key

                var idPageMessage = "#editor-messages";
                // for confluence 5.10 use #all-messages
                if($("#editor-messages").length <= 0){ 
                    idPageMessage = "#all-messages";
                }
                var msg = {
                    title: CP.I18n.getText('publishing.page.public.edit.page.edit.title'),
                    body: CP.I18n.getText('publishing.page.public.edit.page.body',
                        CP.getParam('baseUrl') + "/display/" + CP.getParam('publishingSourceSpaceKey'),
                        AHP.Templates.renderHtmlSafe({ text: CP.getParam('publishingSourceSpaceName') }) ),
                    closeable: true
                };
                CP.message('warning', idPageMessage, msg);

    }

    CP.toInit(function() {
        if (CP.getParam('publishingSourceSpaceKey')) {
            if ($('#rte').is(':visible')) {
                loadInstructions();
            } else {
                CP.bind("init.rte", function(ev) {
                    console.log("AHP init.rte", ev);
                    if ($('#comments-section').size() === 0) { // only load for page edit, not for comments
                        loadInstructions();
                    }
                });
            }
        }
    });
});