/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;

requirejs(['cp', 'jquery', 'ajs'], function (CP, $, AJS) {
    var baseUrl;

    var getState = function () {
            var pageInfo,
                pageId,
                draft = false;

            // remove old state lozenge
            $('.ahp-state').remove();

            // request current state
        if (CP.getParam('pageId') > 0 && ((CP.getParam('pageIsInPublishedSpace') != null && CP.getParam('pageIsInPublishedSpace'))
                ||  (CP.getParam('pageIsInDraftSpace') != null && CP.getParam('pageIsInDraftSpace')))) {
                ajax('GET', baseUrl + '/rest/adhocpublishing/1/publishing/' + CP.Confluence.getContentId(), function (res) {
                    // DRAFT
                    if (res.draftPageInfo) {
                        draft = true;
                        pageInfo = res.draftPageInfo;
                        pageId = pageInfo.publishedPageId;
                        spaceName = pageInfo.publishSpaceName;
                        spaceKey = pageInfo.publishSpace;
                        pageLabel = CP.I18n.getText("publishing.page-copy.public");

                        // if synced, no need to show publish button
                        if (pageInfo.syncState === 'synchronised') {
                            pageInfo.canPublish = false;
                        }

                        // Only show the status lozenge if configured
                        if(pageInfo.displayLozenge){
                            setState(pageInfo.syncState);
                        }
                    }
                    // PUBLIC
                    else if (res.publishedPageInfo) {
                        pageInfo = res.publishedPageInfo;
                        pageId = pageInfo.draftPageId;
                        spaceName = pageInfo.draftSpaceName;
                        spaceKey = pageInfo.draftSpace;
                        pageLabel = CP.I18n.getText("publishing.page-copy.draft");

                        setState(pageInfo.syncState);
                    }

                    if (pageInfo) {
                        // link options
                        viewOptions({
                            // publish button
                            canPublish: pageInfo.canPublish,
                            // draft/public pageId
                            pageId: pageId,
                            pageLabel: pageLabel,
                            baseUrl: baseUrl,

                            // TODO
                            spaceName: spaceName,
                            spaceKey: spaceKey
                        });
                    }
                });
            }
        };

        var setState = function (state) {
            var target = "#title-text a",
                css = "",
                key = "publishing.page.status.";

            switch (state.toLowerCase()) {
                case 'synchronised':
                    key +="synchronised";
                    css = 'aui-lozenge-success';
                    break;

                case 'unsynchronised':
                    key += "unsynchronised";
                    css = 'aui-lozenge-current';
                    break;

                case 'new':
                    key += "new";
                    // fall through
                default:
                    css = 'aui-lozenge-complete';
                    break;
            }

            // RefinedWiki compatibility hook
            if ($(".rw_page_title").length > 0) {
                target = "#title-text";
            }

            $(CP.template('syncStatus', {
                stateName: CP.I18n.getText(key),
                stateCSS: css
            })).insertAfter(target);
        };


        var viewOptions = function (options) {
            var target = ".page-metadata ul:first";

            $('.ahp-syncoptions').remove();
            $(CP.template('syncOptions', options)).insertBefore(target);

            var daDialog = new CP.InlineDialog({
                trigger: '.ahp-publish',
                id: 'publishInlineDialog',
                alignment: 'bottom right',
                content: $('#publishDialog').html()
            });

            $(document).on('click', '.ahp-confirmpublish', function (e) {
                e.preventDefault();
                $(daDialog.trigger).prop('disabled', true);
                publish(
                    function() {
                        // success callback
                        $(daDialog.trigger).remove();
                    },
                    function() {
                        // error callback
                        $(daDialog.trigger).prop('disabled', false);
                    }
                );
                daDialog.hide();
            });
            $(document).on('click', '.ahp-cancelpublish', function (e) {
                e.preventDefault();
                daDialog.hide();
            });

            $('body').append(daDialog.render());

            // RefinedWiki compatibility hook
            if ($(".rw_page_title").length > 0) {
                $('.page-metadata').css({
                    display: 'block'
                });
            }
        };

        var publish = function (successCallback, errorCallback) {
            // track click button
            CP.Analytics.trackEvent('publishing', 'publish');
            // add container for success / error messages
            if ($('#page > #ahp-publish-message').length === 0) {
                $('#page').prepend($('<div id="ahp-publish-message" class="ahp-message"></div>'));
            }

            function onError() {
                // Show Error Mesage 
                CP.message('error', '#ahp-publish-message', {
                    title:"Comala Publishing",
                    body: "<p>" + CP.I18n.getText("publishing.page.error") + "</p>",
                    fadeout: false
                });
                // Invoke provided error callback
                if (errorCallback) {
                    errorCallback();
                }
            };

            ajax('POST', baseUrl + '/rest/adhocpublishing/1/publishing/' + CP.Confluence.getContentId() + '/publish',
                // success
                function (res) {
                    if (res && res.draftPageInfo && res.draftPageInfo.publishedPageId) {
                        $('.ahp-state').remove();

                        // Message confirm published
                        CP.message('success', '#ahp-publish-message', {
                            title:"Comala Publishing",
                            body: "<p>" +
                                CP.I18n.getText("publishing.page.published"
                                        , baseUrl
                                        , res.draftPageInfo.publishedPageId
                                        , CP.template('renderHtmlSafe', {text : res.draftPageInfo.publishSpaceName} ) ) +
                                "</p>",
                            fadeout: true
                        });

                        // view page link
                        $('.ahp-syncoptions-view').attr('href', baseUrl + '/pages/viewpage.action?pageId=' + res.draftPageInfo.publishedPageId);

                        $('.ahp-syncoptions-view').removeClass('hidden');

                        // update state
                        if(res.draftPageInfo.displayLozenge){
                            setState('synchronised');
                        }
                        // invoke provided success callback
                        if (successCallback) {
                            successCallback();
                        }
                    } else {
                        onError();
                    }
                },
                // error
                onError
            );
            return false;
        };

        var refreshAWPState = function (e, pageStatus) {
            if(pageStatus.stateName.toLowerCase() === "approved") {
                // update state lozenge + publishing options. It might have been published
                getState();
            }
        };

        var ajax = function (type, url, responseHandler) {
            CP.request({
                type: type,
                cache: false,
                contentType: "application/json; charset=utf-8",
                url: url,
                success: responseHandler
            });
        };

        CP.toInit(function ($) {
            if (!CP.isPageGadget() && CP.getParam('remoteUser') != ''){
                baseUrl = CP.getParam('baseUrl');
                // explicitly fetch resources...
                CP.I18n.get("com.comalatech.publishing", function() {
                    // wait response to ensure i18n keys are loaded
                    // and initiate states and all
                    getState();
                });

                // init analytics
                CP.Analytics.init();

                // listen to AWP refreshing event to update the publishing state if it has been approved
                $(document).delegate("iframe.adhoworkflows","awp.refresh", refreshAWPState);
            }
        });
    });
