/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;

requirejs(['cp', 'jquery'], function (CP, $) {
    var setDraftLozenge = function () {
        // Find space logo at the sidebar
        var spaceLogo = '.acs-side-bar .space-logo',
            $logo = $(spaceLogo);

        // Couldnt find Conf sidebar, trying documentation theme
        if($logo.length === 0) {
            spaceLogo = '.space-logo img.logo';
            $logo = $(spaceLogo);
        }

        // Couldnt find Conf sidebar, Refined Wiki v5.x perhaps?
        if($logo.length === 0) {
            spaceLogo = '#rw_menu_bar_icon .space-logo img';
            $logo = $(spaceLogo);
        }

        // Refined Wiki v4.3.x doesnt have space logo
        if($logo.length === 0) {
            spaceLogo = '#rw_space_menu li:first-child';
            $logo = $(spaceLogo);
        }

        if($logo.length > 0) {
            // Insert draft lozenge besides space logo
            $(CP.template('draftSpaceLozenge')).insertBefore(spaceLogo);
            var offsetLogo = $logo.offset();

            // center lozenge on top of the space logo
            var offset = {
                top: offsetLogo.top - 10,
                left: offsetLogo.left + $logo.width()/2 - 16
            };

            $('.ahp-draftspace').offset(offset)
        }
    };

    CP.toInit(function(){
        if (!CP.isPageGadget() && CP.getParam('remoteUser') != '' && CP.getParam('hasWatermark') != null && CP.getParam('hasWatermark')
            && CP.getParam('pageIsInDraftSpace') != null && CP.getParam('pageIsInDraftSpace')){
            setDraftLozenge();
        }
    });
});