/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;

requirejs(['cp', 'jquery'], function (CP, $) {

    var getXmlElementValue = function (response, tagName) {
         return $(response).find("task " + tagName).text();
    };

    var spaceOption = ""; // from attr data-ahp-option

    var dialog,
        wizard,
        copyDialog,
        publishConfirmationDialog;

    var Wizard = function (dialog) {
        var pages = [];
        var index = 0;
        return {
            index: index,
            addPage: function (content, actions, title) {
                pages.push({
                    content: content,
                    actions: actions,
                    title: title
                });
                return this;
            },
            page: function (i) {
                if (typeof i !== 'undefined') {
                    index = i;
                } else {
                    i = index;
                }
                var curPage = pages[i];
                dialog.setContent(curPage.content, curPage.actions, curPage.title);
                dialog.update();
            },
            back: function () {
                index--;
                this.page();
            },
            next: function () {
                index++;
                this.page();
            }
        };
    };


    var initDialog = function() {
        // setup dialog with welcome screen
        dialog = new CP.Dialog({
            size: 'large',
            id: "ahp-wzd-dialog",
            title: CP.I18n.getText("publishing.space-config.wizard.welcome.title"),
            help: '<a href="https://apps.appf.re/cpdc/doc/setuppublisheddraftspaces/BoVfjZ" class="cp-main-help" target="_blank">' +
             CP.I18n.getText("publishing.space-config.wizard.welcome.help") +
            '</a>'    
        });
        wizard = new Wizard(dialog);

        // local methods
        var submitDraftToPublic = function (dialog) {
            var publicSpaceKey = $("#ahp-wzd-dialog #publicSpaceKey").find("option:selected").val();
            var publicName = $("#ahp-wzd-dialog #publicSpaceKey").find("option:selected").html();
            var $form = $("#ahp-wzd-draft-form");

            if (publicSpaceKey.length === 0){
                $("#ahp-wzd-dialog #publicSpaceKey").focus();
                return false;
            }

            $('#ahp-wzd-showdialog').hide();
            wizard.next();

            $.post($form.attr('action'), $form.serialize()).done(function(data){

                CP.Analytics.trackEvent('publishing', 'link', 'draft-to-public');

                viewPublishingStatus(CP.getParam('spaceKey'));
                // enable finish button and show confirmation copy (and hide progress)
                $('#ahp-wzd-dialog .ahp-drafttopublic-finish').removeAttr('disabled');
                $('#ahp-wzd-dialog .ahp-progress').addClass('hidden');
                $('#ahp-wzd-dialog .ahp-confirmDraftToPublic-copy').html(CP.I18n.getText("publishing.space-config.wizard.draft.linked", CP.escapeHtml(CP.getParam('spaceName')), publicName));
                $('#ahp-wzd-dialog .ahp-confirmation').removeClass('hidden');
            });
        };

        var submitPublicToDraft = function (dialog) {
            var draftKey = $("#ahp-wzd-dialog #draftSpaceKey").find("option:selected").val();
            var draftName = $("#ahp-wzd-dialog #draftSpaceKey").find("option:selected").html();
            var $form = $("#ahp-wzd-public-confirm");

            $('#ahp-wzd-showdialog').hide();
            wizard.next();

            // set public key for public space as draft key to publish initially
            $.post($form.attr('action'), $form.serialize()).done(function (data) {

                CP.Analytics.trackEvent('publishing', 'link', 'public-to-draft');

                viewPublishingStatus(CP.getParam('spaceKey'));
                // enable finish button and show confirmation copy (and hide progress)
                $('#ahp-wzd-dialog .ahp-publictodraft-finish').removeAttr('disabled');
                $('#ahp-wzd-dialog .ahp-progress').addClass('hidden');
                $('#ahp-wzd-dialog .ahp-confirmPublicToDraft-copy').html(CP.I18n.getText("publishing.space-config.wizard.public.linked", CP.escapeHtml(CP.getParam('spaceName')), draftName));
                $('#ahp-wzd-dialog .ahp-confirmation').removeClass('hidden');
            });
        };

        // setup dialog options
        var closeButton = {
            id: 'close',
            style: 'link',
            label: CP.I18n.getText("close.name"),
            onClick: function () {
                dialog.hide();
            }
        };

        // page 1: Welcome Screen
        wizard.addPage(
            // content
            $('#ahp-wzd').html(),
            // actions
            [
                {
                    id: 'next',
                    style: 'primary',
                    label: CP.I18n.getText("publishing.space-config.wizard.button.next"),
                    onClick: function () {
                        spaceOption = $('.ahp-templates .selected').attr("data-ahp-option");
                        if(spaceOption === "draft-to-public") {
                            wizard.next();
                        }
                        else {
                            wizard.page(3);
                        }
                    }
                },
                closeButton
            ],
            // title
            CP.I18n.getText("publishing.space-config.wizard.welcome.title")
        );
        $('#ahp-wzd').html('');

        // select options of page 1
        $(document).on('click', '.ahp-template', function() {
            $('.ahp-template').removeClass('selected');
            $(this).addClass('selected');
        });

        $(document).on('dblclick', '#ahp-wzd-dialog .ahp-template', function () {
            spaceOption = $('.ahp-templates .selected').attr("data-ahp-option");

            if (spaceOption === "draft-to-public") {
                wizard.next();
            }
            else {
                wizard.page(3);
            }
        });


        // DRAFT TO PUBLIC OPTION +++++++++++++++++++
        // page 2: draft-to-public
        wizard.addPage(
            // content
            $('#ahp-wzd-selectDraftToPublic').html(),
            // actions
            [
                {
                    id: 'link',
                    style: 'primary',
                    label: CP.I18n.getText("publishing.space-config.wizard.button.link"),
                    onClick: function () {
                        submitDraftToPublic(dialog);
                    }
                },
                {
                    id: 'back',
                    style: 'default',
                    label: CP.I18n.getText("publishing.space-config.wizard.button.back"),
                    onClick: function () {
                        wizard.back();
                    }
                },
                closeButton
            ],
            // title
            CP.I18n.getText("publishing.space-config.wizard.draft.selectpublic")
        );
        $('#ahp-wzd-selectDraftToPublic').html('');

        // select options of welcome screen
        $(document).on('change', '.ahp-select', function() {
            var $btn = $(this).parents('.dialog-components').find('.aui-button-primary');

            if($(this).val() !== "") {
                $btn.removeAttr('disabled');
            }
            else {
                $btn.attr('disabled', 'disabled');
            }
        });


        // page 3: confirm draft-to-public
        wizard.addPage(
            $('#ahp-wzd-confirmDraftToPublic').html(),
            [
                {
                    id: 'finish',
                    style: 'primary',
                    label: CP.I18n.getText("publishing.space-config.wizard.button.finish"),
                    onClick: function () {
                        dialog.hide();
                    }
                }
            ],
            CP.I18n.getText("publishing.space-config.wizard.draft.linked.title")
        );
        $('#ahp-wzd-confirmDraftToPublic').html('');


        // PUBLIC TO DRAFT OPTION +++++++++++++++++++
        // page 4: public-to-draft
        wizard.addPage(
            $('#ahp-wzd-selectPublicToDraft').html(),
            [
                {
                    id: 'link',
                    style: 'primary',
                    label: CP.I18n.getText("publishing.space-config.wizard.button.link"),
                    onClick: function () {
                        submitPublicToDraft(dialog);
                    }
                },
                {
                    id: 'back',
                    style: 'default',
                    label: CP.I18n.getText("publishing.space-config.wizard.button.back"),
                    onClick: function () {
                        wizard.page(0);
                    }
                },
                closeButton
            ],
            CP.I18n.getText("publishing.space-config.wizard.public.selectdraft")
        );
        $('#ahp-wzd-selectPublicToDraft').html('');


        // page 5: confirm public-to-draft
        wizard.addPage(
            $('#ahp-wzd-confirmPublicToDraft').html(),
            [
                {
                    id: 'finish',
                    style: 'primary',
                    label: CP.I18n.getText("publishing.space-config.wizard.button.finish"),
                    onClick: function () {
                        document.location.reload();
                    }
                }
            ],
            CP.I18n.getText("publishing.space-config.wizard.draft.linked.title")
        );

        $('.ahp-wzd-open').click(function() {
            wizard.page(0);
            dialog.show();
        });
    };

    var viewPublishingStatus = function(key, done) {
        $.get("viewpublishspace.action?spaceKey=" + key).done(function (renderedHtml) {
            var $newBody = $(renderedHtml).find(spaceToolsSelector);
            $spaceToolsBody.html($newBody.html());
            if (done !== undefined){
                done();
            }
        });
    };

    // dialog for confirmation step of copy space
    var initCopyDialog = function () {
        copyDialog = new CP.Dialog({
            id: "confirmDialog",
            size: "small",
            title: CP.I18n.getText("publishing.space-copy.confirm.title"),
            content: $('#confirmationBlurb').html(),
            actions: [
                {
                    id: 'confirm',
                    style: 'primary',
                    label: CP.I18n.getText("publishing.space-copy.confirm.title"),
                    onClick: function () {
                        copyDialog.hide();
                        $('form#publishcopyform').submit();
                        $("#copySpace").attr("disabled", "disabled")
                            .html(CP.I18n.getText("publishing.space-copy.copying.name") + "...");
                    }
                },
                {
                    id: 'cancel',
                    style: 'link',
                    label: CP.I18n.getText("cancel.name"),
                    onClick: function () {
                        copyDialog.hide();
                    }
                }
            ],
            onOpen: function() {
                $("#confirmDialog .ahp-selectedspace").html(CP.template('renderHtmlSafe', { text:$('#destinationSpaceKey option:selected').text() }) );
            }
        });
    };



    var spaceToolsSelector,$spaceToolsBody; // used from dialog context and from page context

    function longrunning(taskId, resolve) {

        $.get(CP.getParam('contextPath') + "/longrunningtaskxml.action?taskId=" + taskId).done(function (resp) {
            var percentCompleteText = getXmlElementValue(resp, "percentComplete");
            var progressComplete = parseInt(percentCompleteText, 10);
            var status = getXmlElementValue(resp, "currentStatus");
            var isSuccessful = getXmlElementValue(resp, "isSuccessful");

            if (isNaN(progressComplete)) {
                // This might happen when the long running task has not had enough time to setup itself properly in the backend
                setTimeout(function () {
                    longrunning(taskId, resolve);
                }, 1000);
            } else {
                resolve(progressComplete, isSuccessful, status);
            }
        });
    }

    CP.toInit(function () {
        spaceToolsSelector = $("#space-tools-body").length > 0 ? "#space-tools-body" : "#space-admin-body";
        $spaceToolsBody = $(spaceToolsSelector);


        CP.Analytics.init(
            CP.getParam('publishingAnalyticsDomain'),
            CP.getParam('publishingAnalyticsKey'),
            CP.getParam('userLocale'),
            'space config'
        );

        if ($('#ahp-wzd-showdialog').length > 0) {
            // Create welcome dialog
            initDialog();
           
            // show dialog
            wizard.page(0);
            dialog.show();
        }

        publishConfirmationDialog = new CP.Dialog({
            id: "confirmDialog",
            size: "small",
            title: CP.I18n.getText("publishing.space-config-publishing.confirm.title"),
            content: $('#confirmationBlurb').html(),
            actions: [
                {
                    id: 'confirm',
                    style: 'primary',
                    label: CP.I18n.getText("publishing.space-config-publishing.confirm.publish"),
                    onClick: function (ev) {
                        publishConfirmationDialog.hide();
                        var url = CP.getParam('contextPath') + "/plugins/contentpublishing/changeset.action?key=" + CP.getParam('spaceKey');
                        $spaceToolsBody.load(url);
                    }
                },
                {
                    id: 'cancel',
                    style: 'link',
                    label: CP.I18n.getText("publishing.space-config-publishing.confirm.cancel"),
                    onClick: function () {
                        publishConfirmationDialog.hide();
                        var url = CP.getParam('contextPath') + "/spaces/publishspace.action?key=" + CP.getParam('spaceKey') + "&atl_token=" + CP.getParam('atlToken');
                        doPublish(url);
                    }
                }
            ]
        });

        //publicToDraftSyncRequired
        $("a#ahp-wzd-public-copytodraft-show").click(function(ev){
            ev.preventDefault();
            $("div#ahp-wzd-public-copytodraft-config").removeClass("hidden");
            $(this).hide();
        });

        /**
         *
         * @param actionUrl
         * @param data
         * @param renderResult : soy template that renders the result message
         */
        function doCopy(actionUrl, data, renderResult) {
            $.post(actionUrl, data)
                .done(function (data) {
                    var taskId = data.match('ajs-taskId.*?content="(.*?)"')[1];
                    $spaceToolsBody.empty();
                    var longrunningCallback = function (progressComplete, isSuccessful, statusJson) {
                        var text = '';

                        $spaceToolsBody.html(CP.template('progressScreen', {
                            title: CP.I18n.getText("publishing.copy-space.wizard.progress")
                        }));

                        try {
                            var status = JSON.parse(statusJson);
                            if (!isSuccessful || isSuccessful && isSuccessful === "false") {
                                // ERROR
                                CP.message('error', '#ahp-progress-status', {
                                    title: CP.I18n.getText('publishing.copy-space.wizard.error'),
                                    body: status.status,
                                    closeable: false
                                });
                                return false;
                            }

                            if (status.statusKey && status.statusKey.indexOf(".done") > 0) {
                                // all batches completed
                                CP.message('success', '#ahp-progress-status', {
                                    title: CP.template('copyResultMsgTitle', {isComplete: true}),
                                    closeable: false
                                });
                                $('#ahp-progress-status').append(renderResult({isComplete: true, spaceKey: CP.getParam('spaceKey')}));

                                // This fills progress indicator to 100% (completed)
                                // https://design.atlassian.com/2.0/product/components/progress-indicators/
                                $('.ahp-progress-indicator').attr('data-value', 1);

                                return false;
                            } else {
                                text = status.status;
                            }

                        } catch (e) {
                            console.error("Error parsing status", e);
                        }
                        $('#ahp-progress-status').html(text);

                        // schedule next longrunning task poll
                        setTimeout(function () {
                            longrunning(taskId, longrunningCallback);
                        }, 1000);
                    };
                    // initial longrunning task poll
                    longrunning(taskId, longrunningCallback);
                })
                .fail(function (err) {
                    var $newBody = $(err.responseText).find(spaceToolsSelector);
                    $spaceToolsBody.html($newBody.html());
                });
        }

        // space copy via longrunning task
        $spaceToolsBody.on("submit", "form#publishcopyform", function(ev){
            ev.preventDefault();
            var destSpaceKey = $(this).find("select#destinationSpaceKey option:selected").attr("value");
            var destSaceName = $(this).find("select#destinationSpaceKey option:selected").text();
            window.scrollTo(0, 0);
            var actionUrl = $(this).attr("action");
            var formData = $(this).serialize();
            doCopy(actionUrl, formData, AHP.Templates.copyResultMsgBody);
        });

        // wizard : copy via longrunning task
        $spaceToolsBody.on("submit","form#ahp-wzd-public-confirm", function(ev){
            ev.preventDefault();
            window.scrollTo(0, 0);
            var actionUrl = $(this).attr("action");
            var formData = $(this).serialize();
            doCopy(actionUrl, formData, AHP.Templates.publishResultMsgBody);
        });

        // publish in longrunning task
        function doPublish(actionUrl) {
            $.get(actionUrl).done(function (data) {
                var taskId = data.match('ajs-taskId.*?content="(.*?)"')[1];
                $spaceToolsBody.empty();

                var longrunningCallback = function (progressComplete, isSuccessful, statusJson) {
                    var status = {};
                    var text = '';

                    try {
                        status = JSON.parse(statusJson);

                        if (status.statusKey && status.statusKey.indexOf(".synchronized") > 0) {
                            $spaceToolsBody.html(CP.template('syncSpaces', {
                                status: ""
                            }));

                            // space are already in sync
                            CP.message('success', '#ahp-progress-status', {
                                title: CP.I18n.getText('publishing.space-publishing.progress.synchronized'),
                                closeable: false
                            });

                            return false;
                        } else {
                            $spaceToolsBody.html(CP.template('progressScreen', {
                                title: CP.I18n.getText("publishing.publish-space.progress")
                            }));

                            if (!isSuccessful || isSuccessful && isSuccessful === "false") {
                                // ERROR
                                CP.message('error', '#ahp-progress-status', {
                                    title: CP.I18n.getText('publishing.publish-space.error'),
                                    body: status.status,
                                    closeable: false
                                });
                                return false;
                            }

                            if (status.statusKey && status.statusKey.indexOf(".done") > 0) {
                                // all batches completed
                                CP.message('success', '#ahp-progress-status', {
                                    title: CP.template('publishResultMsgTitle', { isComplete: true }),
                                    closeable: false
                                });
                                $('#ahp-progress-status').append(CP.template('publishResultMsgBody', {isComplete: true, spaceKey: CP.getParam('spaceKey')}));

                                // This fills progress indicator to 100% (completed)
                                // https://design.atlassian.com/2.0/product/components/progress-indicators/
                                $('.ahp-progress-indicator').attr('data-value', 1);

                                return false;
                            } else {
                                text = status.status;
                            }
                        }
                    } catch (e){
                        console.error("Error parsing status", e);
                    }
                    $('#ahp-progress-status').html(text);

                    // schedule next longrunning task poll
                    setTimeout(function(){
                        longrunning(taskId, longrunningCallback);
                    }, 1000);
                };
                // initial longrunning task poll
                longrunning(taskId, longrunningCallback);
            }).fail(function( jqXHR, textStatus, errorThrown ) {
                    var $newBody = $(jqXHR.responseText).find(spaceToolsSelector); // xwork action result for "input"
                    $spaceToolsBody.html($newBody.html());
                });
        }

        // confirm publish action
        $spaceToolsBody.on("click", "#ahp-publish-submit", function(){
            publishConfirmationDialog.show();
        });

        // space publish action
        $spaceToolsBody.on("click", "#ahp-publish-confirm", function(ev){
            ev.preventDefault();
            var actionUrl = $(this).attr("data-action");
            doPublish(actionUrl);
        });

        // edit settings
        $spaceToolsBody.on("click", "#ahp-editspacecfg", function (ev) {
            $.get('viewpublishspaceui.action?key=' + CP.getParam('spaceKey'), function (renderedHtml) {
                var $newBody = $(renderedHtml).find(spaceToolsSelector);
                $spaceToolsBody.html($newBody.html());

                CP.toInit(function () {
                    var NewPublishingConfigIframe = new CP.iframe({
                        id:"new-publishing-config",
                        // url:'/configuration/' + CP.getParam('publishingSourceSpaceKey'),
                        url: "/configuration/publishspace/"+ CP.getParam('spaceKey'),
                        width:'100%',
                        height:'100%'
                    });
                    $('#new-publishing-configuration').html(NewPublishingConfigIframe.render());
                });
            });
        });

        // cancel edit
        $spaceToolsBody.on("click", "form#publishform input[id=cancel]", function(ev){
            ev.preventDefault();
            viewPublishingStatus(CP.getParam('spaceKey'));
            return false;
        });


        // if singlePagePublishing and publishAWPFinalVersion are both selected show warning
        $spaceToolsBody.on("change", "form#publishform", function(ev){
            ev.preventDefault();

            if (ev.target.name == 'singlePagePublishing' || ev.target.name == 'publishAWPFinalVersion')  {

                var singlePageChecked = $('#singlePagePublishing').prop('checked');
                var finalStateChecked = $('#publishAWPFinalVersion').prop('checked');

                if (this.singlePageFinalStateMsg) {
                    $("#warning-final-state-message").toggle();
                }

                if (!this.singlePageFinalStateMsg && singlePageChecked && finalStateChecked) {
                    this.singlePageFinalStateMsg = CP.message('warning', "#ahp-publish-message", {
                        title: CP.I18n.getText('publishing.warning'),
                        id: "warning-final-state-message",
                        body: CP.I18n.getText("publishing.configuration.single-page.final-state"),
                        closeable: false
                    });
                }

            }
            return false;
        });

        //save settings
        $spaceToolsBody.on("submit", "form#publishform", function (ev) {
            ev.preventDefault();
            $.post($(this).attr('action'), $(this).serialize())
                .done(function (actionResult) {
                    viewPublishingStatus(CP.getParam('spaceKey'), function () {
                        if ($(".ahp-wzd-open").length > 0) {
                            if (dialog){ dialog.remove(); }
                            // init dialog just in case user click on the 'configure here' link
                            initDialog();
                            // but not showing the dialog immediately
                        }
                    });
                })
                .fail(function(err) {
                    var $newBody = $(err.responseText).find(spaceToolsSelector);
                    $spaceToolsBody.html($newBody.html());
                  });
        });

        $spaceToolsBody.on("click", "button#viewChanges", function (event) {
            event.preventDefault();
            var $progress = $("div#view-changes-div");
            var $container = $progress.find('.iframe-placeholder');
            if (this.SpaceReport) {
                this.SpaceReport.reload();
            } else {
                this.SpaceReport = new CP.iframe({
                    id: 'space-report-iframe',
                    url: '/space-report/source/' + ($container.find('#draftSpaceKey').text() || CP.getParam('spaceKey')),
                    query: {
                        source: $container.find('#draftSpaceName').text() || CP.getParam('spaceName'),
                        destination: $container.find('#publicSpaceName').text() || CP.getParam('spaceName')
                    },
                    height: '300px',
                    onLoad: function() {
                        $progress.find('div:first-child').hide();
                    }
                });
                $container.replaceWith(this.SpaceReport.render());
                CP.connect('togglePublish', function(disabled) {
                    this.prop("disabled", disabled);
                }, $('#ahp-publish-submit'));
            }
            $progress.show();
            $(this).find('.aui-icon').removeClass('aui-iconfont-view').addClass('aui-iconfont-refresh');
            return false;
        });

        $("#cancelCopy").click(function () {
            history.back();
            return false;
        });

        $(".ahp-wzd-sectn .select").change(function () {
            var selected = $(this).find("option:selected").val();
            if(selected) {
                $(this).siblings("button").removeAttr("disabled");
            }
            else {
                $(this).siblings("button").attr("disabled", "disabled");
            }
        });

        // COPY SPACE
        // Determine if we are at the Copy Space tab,
        // to format the checkbox options and add descriptions below
        if($("#copySpace").length > 0) {
            $("#confirm").addClass("aui-button-primary");
            // mount the confirm copy space dialog
            initCopyDialog();

            // When user selects a target space, enable copy space button
            $("#destinationSpaceKey").change(function () {
                if ($(this).parents("form").attr("data-license").length){
                    return;
                }
                var selected = $(this).find("option:selected");
                if (selected.length === 0 || selected.val() === null || selected.val() === "" || selected.val().length === 0) {
                    $("#copySpace").attr("disabled", "disabled");
                } else {
                    $("#copySpace").removeAttr("disabled");
                }
            });

            // copy space button requires a confirmation step (opens dialog)
            $("#copySpace").click(function (e) {
                e.preventDefault();

                copyDialog.show();

                return false;
            });
        }
    });

});
