/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.utils;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.publishing.awp.StateServiceAccessor;
import com.comalatech.confluence.publishing.awp.StateServiceHolder;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.State;
import org.springframework.context.ApplicationContext;

public class WorkflowsStateDelegate {
    private ApplicationContext context;

    public WorkflowsStateDelegate(ApplicationContext context) {
        this.context = context;
    }

    private StateService getStateService() {
        StateServiceAccessor stateServiceAccessor = (StateServiceAccessor)this.context.getBean("stateServiceAccessor", StateServiceAccessor.class);
        StateServiceHolder stateService = stateServiceAccessor.getStateService();
        return stateService != null ? (StateService)stateService.getStateService() : null;
    }

    public State obtainWorkflowsState(AbstractPage source) {
        if (this.getStateService() == null || this.getStateService().getPublishedState((ContentEntityObject)source) == null) {
            return null;
        }
        return this.getStateService().getPublishedState((ContentEntityObject)source);
    }

    public boolean isComalaWorkFlowsInstalled() {
        return this.getStateService() != null;
    }
}

