/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.utils;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.rest.api.model.RestPageRequest;
import com.comalatech.confluence.publishing.utils.OsgiUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonContentPropertyHelper {
    private static final Logger log = LoggerFactory.getLogger(JsonContentPropertyHelper.class);
    private static final int LIMIT = 100;
    private ContentPropertyService contentPropertyService;

    public JsonContentPropertyHelper(ContentPropertyService contentPropertyService) {
        this.contentPropertyService = contentPropertyService;
    }

    protected ContentPropertyService getContentPropertyService() {
        if (this.contentPropertyService == null) {
            this.contentPropertyService = OsgiUtils.getService(ContentPropertyService.class);
        }
        return this.contentPropertyService;
    }

    public void copyJsonPropertiesToTarget(Map<String, JsonContentProperty> sourceProperties, ContentEntityObject target) {
        this.removeJsonContentProperties(target);
        try {
            this.contentPropertyService = this.getContentPropertyService();
            for (Map.Entry<String, JsonContentProperty> propertyEntry : sourceProperties.entrySet()) {
                JsonContentProperty property = propertyEntry.getValue();
                Reference contentRef = Reference.to((Object)Content.builder().id(target.getContentId()).build());
                JsonContentProperty newProperty = JsonContentProperty.builder().key(property.getKey()).value(property.getValue()).content(contentRef).build();
                this.contentPropertyService.create(newProperty);
            }
        }
        catch (ServiceException e) {
            log.error("not able to copy json content properties to page '" + target.getTitle() + "'(" + target.getId() + "), " + e.getMessage());
        }
    }

    private void removeJsonContentProperties(ContentEntityObject page) {
        if (log.isDebugEnabled()) {
            log.debug("removeJsonContentProperties from page " + page.getTitle() + "(" + page.getId() + ")");
        }
        try {
            this.contentPropertyService = this.getContentPropertyService();
            List<JsonContentProperty> properties = this.getListOfJsonContentProperties(page);
            for (JsonContentProperty property : properties) {
                this.contentPropertyService.delete(property);
            }
        }
        catch (ServiceException e) {
            log.error("not able to remove json content property from '" + page.getTitle() + "'(" + page.getId() + "), " + e.getMessage());
        }
    }

    public List<JsonContentProperty> getListOfJsonContentProperties(ContentEntityObject ceo) {
        ArrayList<JsonContentProperty> results = new ArrayList<JsonContentProperty>();
        if (!ceo.isDeleted() && ceo.isCurrent()) {
            try {
                RestPageRequest pageRequest = new RestPageRequest((UriBuilder)null, 0, 100);
                this.contentPropertyService = this.getContentPropertyService();
                PageResponse pageResponse = this.contentPropertyService.find(new Expansion[0]).withContentId(ceo.getContentId()).fetchMany((PageRequest)pageRequest);
                results.addAll(pageResponse.getResults());
                int i = 1;
                while (pageResponse.hasMore()) {
                    pageRequest = new RestPageRequest((UriBuilder)null, i * 100, 100);
                    pageResponse = this.contentPropertyService.find(new Expansion[0]).withContentId(ceo.getContentId()).fetchMany((PageRequest)pageRequest);
                    results.addAll(pageResponse.getResults());
                    ++i;
                }
            }
            catch (ServiceException e) {
                log.error("not able to find properties for '" + ceo.getTitle() + "'(" + ceo.getId() + "), page current/deleted: " + ceo.isCurrent() + "/" + ceo.isDeleted() + ", " + ceo.getType() + " - " + e.getMessage());
            }
        }
        return results;
    }
}

