/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.utils;

import com.comalatech.confluence.publishing.utils.DateUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.text.ParseException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomXstreamDateConverter
extends DateConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(CustomXstreamDateConverter.class);

    public boolean canConvert(Class type) {
        return type.equals(Date.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        hierarchicalStreamWriter.setValue(DateUtils.parseDate((Date)source));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            return DateUtils.parseDate(reader.getValue());
        }
        catch (ParseException e) {
            log.error(e.getMessage());
            return null;
        }
    }
}

