/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionUtils {
    private static final Logger log = LoggerFactory.getLogger(CompressionUtils.class);
    public static Charset CHARSET_FOR_URL_ENCODING = StandardCharsets.ISO_8859_1;
    public static Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final int IO_BUFFER_SIZE = 4096;

    public byte[] decode(String value) {
        return Base64.getDecoder().decode(value.getBytes(StandardCharsets.ISO_8859_1));
    }

    public byte[] encode(String value) {
        return Base64.getEncoder().encode(value.getBytes(StandardCharsets.ISO_8859_1));
    }

    public byte[] decode(byte[] value) {
        return Base64.getDecoder().decode(value);
    }

    public byte[] encode(byte[] value) {
        return Base64.getEncoder().encode(value);
    }

    public String inflate(byte[] binaryData) throws IOException {
        if (binaryData == null) {
            log.warn("binaryData is null when inflating");
            return null;
        }
        StringBuffer result = new StringBuffer();
        try (InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(binaryData), new Inflater(true));){
            while (((InputStream)in).available() != 0) {
                byte[] buffer = new byte[4096];
                int len = ((InputStream)in).read(buffer, 0, 4096);
                if (len <= 0) {
                    break;
                }
                result.append(new String(buffer, 0, len));
            }
        }
        return result.toString();
    }

    public byte[] deflate(String data) {
        if (data == null) {
            log.warn("In String is is null");
            return new byte[0];
        }
        Deflater deflater = new Deflater(-1, true);
        byte[] inBytes = data.getBytes(DEFAULT_CHARSET);
        deflater.setInput(inBytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(inBytes.length);
        deflater.finish();
        byte[] buffer = new byte[4096];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        return outputStream.toByteArray();
    }
}

