/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.stats;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.comalatech.confluence.publishing.bandana.ComalatechBandanaContext;
import com.comalatech.confluence.publishing.stats.PublishingStatisticsManager;
import org.springframework.beans.factory.InitializingBean;

public class PublishingStatisticsManagerImpl
implements PublishingStatisticsManager,
InitializingBean {
    protected static final String PRODUCTION_UA = "";
    protected static final String DEV_UA = "";
    protected static final String STATS_BANDANA_KEY = "publising.stats.enabled";
    private static final ComalatechBandanaContext bandanaContext = new ComalatechBandanaContext();
    protected final BandanaManager bandanaManager;
    protected String uaKey;

    public PublishingStatisticsManagerImpl(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public String getUAKey() {
        return this.uaKey;
    }

    @Override
    public void enableStats(boolean enable) {
        this.bandanaManager.setValue((BandanaContext)bandanaContext, STATS_BANDANA_KEY, (Object)Boolean.valueOf(enable).toString());
    }

    @Override
    public boolean isStatsEnabled() {
        Object value = this.bandanaManager.getValue((BandanaContext)bandanaContext, STATS_BANDANA_KEY);
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        License confluenceLicense = LicenseManager.getInstance().getLicense("CONF");
        if (confluenceLicense != null) {
            com.atlassian.license.LicenseType licenseType = confluenceLicense.getLicenseType();
            LicenseType type = LicenseType.valueOf((String)licenseType.getNewLicenseTypeName());
            this.uaKey = type.equals((Object)LicenseType.DEVELOPER) || type.equals((Object)LicenseType.TESTING) ? "" : "";
        }
    }
}

