/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.space.configuration.services;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.InternalPublishingManager;
import com.comalatech.confluence.publishing.api.model.PublishingSpaceConfiguration;
import com.comalatech.confluence.publishing.space.configuration.model.PublishSpaceData;
import com.comalatech.confluence.publishing.space.configuration.populator.contracts.PublishingSpaceConfigurationDataPopulator;
import com.comalatech.confluence.publishing.space.configuration.services.PublishingSpaceService;
import com.opensymphony.util.TextUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PublishingSpaceServiceImpl
implements PublishingSpaceService {
    private final PublishingSpaceConfigurationDataPopulator publishSpaceDataPopulator;
    private final InternalPublishingConfigurationManager publishingConfigurationManager;
    private final InternalPublishingManager publishingManager;
    private final SpaceManager spaceManager;

    public PublishingSpaceServiceImpl(PublishingSpaceConfigurationDataPopulator publishSpaceDataPopulator, SpaceManager spaceManager, InternalPublishingConfigurationManager publishingConfigurationManager, InternalPublishingManager publishingManager) {
        this.publishSpaceDataPopulator = publishSpaceDataPopulator;
        this.spaceManager = spaceManager;
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.publishingManager = publishingManager;
    }

    @Override
    public PublishSpaceData getPublishSpaceConfiguration(Space space) {
        PublishSpaceData publishSpaceData = new PublishSpaceData();
        PublishingSpaceConfiguration publishingSpaceConfiguration = (PublishingSpaceConfiguration)this.publishSpaceDataPopulator.populateConfigurationData(space);
        publishSpaceData.setPublishingSpaceConfiguration(publishingSpaceConfiguration);
        List<Space> allSpaces = this.getAllSpaces();
        List<PublishSpaceData.SpaceInfo> allPossiblePublicSpaces = allSpaces.stream().filter(s -> !s.getKey().equals(space.getKey())).map(s -> this.isAlreadyADestinationSpace((Space)s, space) ? null : new PublishSpaceData.SpaceInfo(s.getKey(), s.getName())).filter(Objects::nonNull).collect(Collectors.toList());
        Space configuredPublicSpace = this.publishingConfigurationManager.getPublicSpace(space);
        if (configuredPublicSpace != null) {
            publishSpaceData.setPublicSpace(configuredPublicSpace.getKey());
            allPossiblePublicSpaces.add(0, new PublishSpaceData.SpaceInfo("", ConfluenceActionSupport.getTextStatic((String)"publishing.space.unlink.public", (Object[])new String[]{configuredPublicSpace.getName()})));
        }
        publishSpaceData.setTargetSpaces(allPossiblePublicSpaces);
        Date lastSync = this.publishingManager.getLastSyncDate(configuredPublicSpace);
        publishSpaceData.setLastSync(lastSync);
        publishSpaceData.setContentPropertiesToCopy(Arrays.asList(this.publishingConfigurationManager.getPropertiesPrefixes()));
        publishSpaceData.setScaffoldingApp(this.publishingConfigurationManager.isScaffoldingAppAvailable());
        publishSpaceData.setComalaDocumentManagementApp(this.publishingConfigurationManager.isComalaDocumentManagementAppAvailable());
        publishSpaceData.setSyncLabel(this.publishingConfigurationManager.getPublishingLabel());
        return publishSpaceData;
    }

    @Override
    public void updatePublishSpaceConfiguration(Space sourceSpace, String publicSpaceKey, PublishSpaceData publishSpaceData) throws Exception {
        if (TextUtils.stringSet((String)publicSpaceKey)) {
            this.publishingConfigurationManager.linkSpacesToPublish(sourceSpace.getKey(), publicSpaceKey, publishSpaceData.getPublishingSpaceConfiguration());
        } else {
            this.publishingConfigurationManager.setPublicSpace(sourceSpace, null);
        }
    }

    private List<Space> getAllSpaces() {
        SpacesQuery.Builder queryBuilder = SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL);
        queryBuilder.forUser((User)AuthenticatedUserThreadLocal.get());
        queryBuilder.withPermission("SETSPACEPERMISSIONS");
        ListBuilder allSpacesBuilder = this.spaceManager.getSpaces(queryBuilder.build());
        return allSpacesBuilder.getRange(0, allSpacesBuilder.getAvailableSize());
    }

    private boolean isAlreadyADestinationSpace(Space space, Space currentSpace) {
        String sourceSpaceKey = this.publishingConfigurationManager.getSourceSpaceKey(space);
        return sourceSpaceKey != null && !sourceSpaceKey.equals(currentSpace.getKey());
    }
}

