/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.publishing.model.AttachmentManifest;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PublishManifest {
    private String sourceTitle;
    private String sourceSpace;
    private int sourceVersion;
    private int destinationVersion;
    private AttachmentManifest[] attachmentsManifests;
    private transient int currentDestinationVersion;
    private long sourceId;

    public PublishManifest() {
    }

    public PublishManifest(AbstractPage source, AbstractPage destination) {
        this.sourceSpace = source.getSpaceKey();
        this.sourceTitle = source.getTitle();
        this.sourceId = source.getId();
        this.sourceVersion = source.getVersion();
        this.destinationVersion = destination.getVersion();
        this.attachmentsManifests = new AttachmentManifest[0];
    }

    public void setAttachmentsManifests(AttachmentManifest[] attachmentsManifests) {
        this.attachmentsManifests = attachmentsManifests;
        Arrays.sort(this.attachmentsManifests, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((AttachmentManifest)o1).fileName.compareTo(((AttachmentManifest)o2).fileName);
            }
        });
    }

    public String getSourceSpaceKey() {
        return this.sourceSpace;
    }

    public AttachmentManifest[] getAttachmentsManifests() {
        return this.attachmentsManifests;
    }

    public String getSourceTitle() {
        return this.sourceTitle;
    }

    public int getSourceVersion() {
        return this.sourceVersion;
    }

    public int getDestinationVersion() {
        return this.destinationVersion;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public AttachmentManifest createAttachmentManifest(String filename, int version, int destinationVesion) {
        return new AttachmentManifest(filename, version, destinationVesion);
    }

    public int getCurrentDestinationVersion() {
        return this.currentDestinationVersion;
    }

    public void setCurrentDestinationVersion(int currentDestinationVersion) {
        this.currentDestinationVersion = currentDestinationVersion;
    }

    public long getSourceId() {
        return this.sourceId;
    }
}

