/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.model;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.publishing.model.AbstractPageChange;
import com.comalatech.confluence.publishing.model.AttachmentEntityChange;
import com.comalatech.confluence.publishing.model.PageAttachmentEntityChange;
import com.comalatech.confluence.publishing.model.PublishManifest;
import com.comalatech.confluence.publishing.model.PublishingOption;
import java.text.MessageFormat;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageChange
extends AbstractPageChange {
    private static final Logger log = LoggerFactory.getLogger(PageChange.class);
    private static final String PAGE_NOT_FOUND_MESSAGE = "The page could not be retrieved. If it should exists and the error still persists, this may require to rebuilt Confluence index. Space key is ''{0}'', page name is ''{1}'', page version is ''{2}''";
    private PublishManifest manifest;

    public PageChange(Page source, long destinationId, int type, Map<PublishingOption, Boolean> spacePublishingOptions) {
        super(source.getTitle(), destinationId, source.getVersion(), type, spacePublishingOptions);
    }

    public PageChange(Page source, long destinationId, int type, Map<PublishingOption, Boolean> spacePublishingOptions, PublishManifest manifest) {
        this(source, destinationId, type, spacePublishingOptions);
        this.manifest = manifest;
    }

    @Override
    public ConfluenceEntityObject getEntity(String spaceKey) {
        Page sourcePage = pageManager.getPage(spaceKey, this.name);
        if (sourcePage != null && this.version > 0) {
            sourcePage = pageManager.getPageByVersion((AbstractPage)sourcePage, this.version);
        }
        if (sourcePage == null) {
            log.warn(MessageFormat.format(PAGE_NOT_FOUND_MESSAGE, spaceKey, this.name, this.version));
        }
        return sourcePage;
    }

    @Override
    public ConfluenceEntityObject getDestEntity() {
        return pageManager.getPage(this.destinationId);
    }

    @Override
    public AttachmentEntityChange createAttachmentEntityChange(AbstractPage page, String name, int version, int type) {
        return new PageAttachmentEntityChange(page, name, version, type);
    }

    public boolean isUpdatedInDestination() {
        return this.type == 3 && this.manifest != null && this.manifest.getDestinationVersion() != this.manifest.getCurrentDestinationVersion();
    }

    public PublishManifest getManifest() {
        return this.manifest;
    }
}

