/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.model;

import com.comalatech.confluence.publishing.model.EntityChange;
import java.util.ArrayList;
import java.util.List;

public class EntityChangeSet {
    private List<EntityChange> changes;

    public EntityChangeSet() {
        this.changes = new ArrayList<EntityChange>();
    }

    public EntityChangeSet(List changes) {
        this.setChanges(changes);
    }

    public void setChanges(List changes) {
        this.changes = changes;
    }

    public void addChange(EntityChange change) {
        this.changes.add(change);
    }

    public boolean isChange() {
        for (EntityChange change : this.changes) {
            if (!change.isChange()) continue;
            return true;
        }
        return false;
    }

    public List<EntityChange> getChanges() {
        return this.changes;
    }

    public EntityChangeSet retrieveBatchChanges(int max) {
        EntityChangeSet batchChangeSet = new EntityChangeSet();
        if (max <= 0) {
            return batchChangeSet;
        }
        if (this.changes.size() > max) {
            batchChangeSet.changes = this.changes.subList(0, max);
            this.changes = this.changes.subList(max, this.changes.size());
            return batchChangeSet;
        }
        batchChangeSet.changes = this.changes;
        this.changes = new ArrayList<EntityChange>();
        return batchChangeSet;
    }

    public int size() {
        return this.changes.size();
    }

    public String toString() {
        return this.changes.toString();
    }
}

