/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.model;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.publishing.model.AttachmentEntityChange;
import com.comalatech.confluence.publishing.model.BlogPostChange;
import com.comalatech.confluence.publishing.model.EntityChange;
import com.comalatech.confluence.publishing.model.EntityChangeSet;
import com.comalatech.confluence.publishing.model.PageChange;
import com.comalatech.confluence.publishing.model.PublishManifest;
import com.comalatech.confluence.publishing.model.PublishingOption;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.BooleanUtils;

public abstract class AbstractPageChange
extends EntityChange {
    EntityChangeSet attachmentChanges;
    protected long destinationId;
    private String versionComment;
    private final Map<PublishingOption, Boolean> spacePublishingOptions;

    public AbstractPageChange(String title, long destinationId, int version, int type, Map<PublishingOption, Boolean> spacePublishingOptions) {
        super(title, version, type);
        this.destinationId = destinationId;
        this.spacePublishingOptions = spacePublishingOptions;
        this.attachmentChanges = new EntityChangeSet();
    }

    public static AbstractPageChange create(AbstractPage abstractPageObject, long destinationId, int entityChangeType, Map<PublishingOption, Boolean> spacePublishingOptions, PublishManifest manifest) {
        if (abstractPageObject instanceof Page) {
            return new PageChange((Page)abstractPageObject, destinationId, entityChangeType, spacePublishingOptions, manifest);
        }
        return new BlogPostChange((BlogPost)abstractPageObject, destinationId, entityChangeType, spacePublishingOptions);
    }

    public abstract ConfluenceEntityObject getDestEntity();

    public abstract AttachmentEntityChange createAttachmentEntityChange(AbstractPage var1, String var2, int var3, int var4);

    public boolean isContentChange() {
        return super.isChange();
    }

    @Override
    public boolean isChange() {
        return super.isChange() || this.attachmentChanges.isChange();
    }

    public String getVersionComment() {
        return this.versionComment;
    }

    public void setVersionComment(String versionComment) {
        this.versionComment = versionComment;
    }

    public boolean isUpdateAttachments() {
        return this.attachmentChanges.isChange();
    }

    public void setAttachmentChanges(List changes) {
        this.attachmentChanges.setChanges(changes);
    }

    public EntityChangeSet getAttachmentChanges() {
        return this.attachmentChanges;
    }

    public Map<PublishingOption, Boolean> getSpacePublishingOptions() {
        return this.spacePublishingOptions;
    }

    public boolean isOption(PublishingOption option) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)this.spacePublishingOptions.get((Object)option), (boolean)option.isChecked());
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void setDestinationId(long destinationId) {
        this.destinationId = destinationId;
    }
}

