/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.listeners;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.analytics.AnalyticsDataCollector;
import com.comalatech.confluence.publishing.analytics.collector.PublishingDataCollector;
import com.comalatech.confluence.publishing.api.event.PagePublishedEvent;
import com.comalatech.confluence.publishing.event.CopySpaceActionEvent;
import com.comalatech.confluence.publishing.event.PagePublishMacroActionEvent;
import com.comalatech.confluence.publishing.event.PagePublishedActionEvent;
import com.comalatech.confluence.publishing.event.SpacePublishedActionEvent;
import com.comalatech.confluence.publishing.model.PublishingOption;
import com.comalatech.confluence.publishing.stats.PublishingStatisticsManager;
import com.comalatech.confluence.publishing.utils.WorkflowsStateDelegate;
import com.comalatech.workflow.model.State;
import java.time.Clock;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class PublishingStatsListener
implements DisposableBean,
ApplicationContextAware {
    private final InternalPublishingConfigurationManager publishingConfigurationManager;
    private final AnalyticsDataCollector workflowsIntegrationDataCollector;
    private final PublishingDataCollector publishingDataCollector;
    private final PublishingStatisticsManager publishingStatisticsManager;
    private final EventPublisher eventPublisher;
    private ApplicationContext context;

    public PublishingStatsListener(InternalPublishingConfigurationManager publishingConfigurationManager, @Qualifier(value="workflowsIntegrationDataCollector") AnalyticsDataCollector workflowsIntegrationDataCollector, PublishingStatisticsManager publishingStatisticsManager, @Qualifier(value="publishingDataCollector") PublishingDataCollector publishingDataCollector, EventPublisher eventPublisher) {
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.workflowsIntegrationDataCollector = workflowsIntegrationDataCollector;
        this.publishingStatisticsManager = publishingStatisticsManager;
        this.publishingDataCollector = publishingDataCollector;
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPagePublishedEvent(PagePublishedEvent event) {
        if (this.publishingStatisticsManager.isStatsEnabled()) {
            AbstractPage source = event.getDraftPage();
            this.updateTimeStampWhenFinalPageHasBeenPublished(source);
        }
    }

    @EventListener
    public void onPublishedPageMacroAction(PagePublishMacroActionEvent event) {
        this.setTimestampStat("latestPagePublishedAction");
    }

    @EventListener
    public void onCopySpaceAction(CopySpaceActionEvent event) {
        this.setTimestampStat("latestSpaceCopied");
    }

    @EventListener
    public void onSpacePublishedAction(SpacePublishedActionEvent event) {
        this.setTimestampStat("latestSpacePublished");
    }

    @EventListener
    public void onPagePublishedActionEvent(PagePublishedActionEvent event) {
        this.setTimestampStat("latestPagePublished");
    }

    private void updateTimeStampWhenFinalPageHasBeenPublished(AbstractPage sourcePage) {
        WorkflowsStateDelegate workflowsStateDelegate;
        State finalPublishedState;
        Map<PublishingOption, Boolean> spacePublishingOptions;
        if (sourcePage != null && (spacePublishingOptions = this.publishingConfigurationManager.getSpacePublishingOptions(sourcePage.getSpace())).get((Object)PublishingOption.PUBLISH_AWP_FINAL_STATE).booleanValue() && (finalPublishedState = (workflowsStateDelegate = new WorkflowsStateDelegate(this.context)).obtainWorkflowsState(sourcePage)) != null) {
            this.workflowsIntegrationDataCollector.setTimeStampStat(Clock.systemDefaultZone(), "latestFinalWorkflowVersionPublished");
        }
    }

    private void setTimestampStat(String key) {
        if (this.publishingStatisticsManager.isStatsEnabled()) {
            this.publishingDataCollector.setTimeStampStat(Clock.systemDefaultZone(), key);
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

