/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.ipc;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.PluginAccessor;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import org.randombits.confluence.supplier.Supplier;
import org.randombits.confluence.supplier.SupplierException;
import org.randombits.confluence.supplier.UnsupportedContextException;

public class ContentPublishingSupplier
implements Supplier {
    private final InternalPublishingConfigurationManager publishingConfigurationManager;
    private final PluginAccessor pluginAccessor;
    private Boolean reportingPluginInstalled;

    public ContentPublishingSupplier(InternalPublishingConfigurationManager publishingConfigurationManager, PluginAccessor pluginAccessor) {
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.pluginAccessor = pluginAccessor;
    }

    public boolean supportsPrefix(String prefix) {
        return prefix == null || "publishing".equals(prefix);
    }

    public boolean supportsContext(Object context) {
        return context instanceof SpaceContentEntityObject || context instanceof Space;
    }

    public Object getValue(Object context, String key) throws UnsupportedContextException, SupplierException {
        if (context instanceof SpaceContentEntityObject) {
            return this.getValue(((SpaceContentEntityObject)context).getSpace(), key);
        }
        if (context instanceof Space) {
            Space space = (Space)context;
            if ("source".equals(key) || "draft".equals(key)) {
                return this.publishingConfigurationManager.getSourceSpace(space);
            }
            if ("destination".equals(key) || "public".equals(key)) {
                return this.publishingConfigurationManager.getPublicSpace(space);
            }
            if ("key".equalsIgnoreCase(key) && !this.isReportingPluginInstalled()) {
                return space.getKey();
            }
            if ("name".equalsIgnoreCase(key) && !this.isReportingPluginInstalled()) {
                return space.getName();
            }
        }
        return null;
    }

    private boolean isReportingPluginInstalled() {
        if (this.reportingPluginInstalled != null) {
            return this.reportingPluginInstalled;
        }
        this.reportingPluginInstalled = this.pluginAccessor.isPluginEnabled("net.customware.confluence.plugin.reporting");
        return this.reportingPluginInstalled;
    }

    public void resetReportingPluginInstalledFlag() {
        this.reportingPluginInstalled = null;
    }
}

