/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.diagrams;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.publishing.InternalPublishingManager;
import com.comalatech.confluence.publishing.utils.CompressionUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrawIoXmlTransformer {
    private static final Logger log = LoggerFactory.getLogger(DrawIoXmlTransformer.class);
    private final PageManager pageManager;
    private final InternalPublishingManager internalPublishingManager;

    DrawIoXmlTransformer(PageManager pageManager, InternalPublishingManager internalPublishingManager) {
        this.pageManager = pageManager;
        this.internalPublishingManager = internalPublishingManager;
    }

    String updateLinksToDestinationSpace(String drawIoXml, AbstractPage destinationKey) {
        Validate.notBlank((CharSequence)drawIoXml, (String)"Draw Io xml String cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)destinationKey, (String)"Published space key cannot be null", (Object[])new Object[0]);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        ByteArrayInputStream stream = new ByteArrayInputStream(drawIoXml.getBytes(CompressionUtils.DEFAULT_CHARSET));
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            XMLEventReader xmlEventReader = factory.createXMLEventReader(stream);
            XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(result);
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.getEventType() == 7) continue;
                event = this.processElement(destinationKey, event);
                writer.add(event);
            }
        }
        catch (XMLStreamException e) {
            log.error("Cannot process  xGraph xml {}, {}", (Object)drawIoXml, (Object)e);
            return drawIoXml;
        }
        return new String(result.toByteArray(), CompressionUtils.DEFAULT_CHARSET);
    }

    private XMLEvent processElement(AbstractPage spaceKey, XMLEvent event) {
        Pattern idPattern = Pattern.compile("pageId=[0-9]+");
        Optional<XMLEvent> updatedStartElement = Optional.empty();
        HashMap<QName, String> updatedAttributeMap = new HashMap<QName, String>();
        if (event.getEventType() == 1) {
            StartElement startElement = event.asStartElement();
            Iterator<Attribute> attributes = startElement.getAttributes();
            while (attributes.hasNext()) {
                Attribute currentAttribute = attributes.next();
                String data = currentAttribute.getValue();
                Matcher matcher = idPattern.matcher(data);
                if (!matcher.find()) continue;
                String updatedLink = this.updatePageLink(spaceKey, currentAttribute);
                updatedAttributeMap.put(currentAttribute.getName(), updatedLink);
            }
            if (!updatedAttributeMap.isEmpty()) {
                updatedStartElement = Optional.of(this.updateStartElement(startElement, updatedAttributeMap));
            }
        }
        return updatedStartElement.orElse(event);
    }

    private String updatePageLink(AbstractPage destinationPage, Attribute updatableAttribute) {
        if (StringUtils.isBlank((CharSequence)updatableAttribute.getValue())) {
            return null;
        }
        Optional<Long> pageId = this.extractPageIdFromString(updatableAttribute.getValue());
        String destinationUrl = "";
        if (pageId.isPresent()) {
            Page page = this.pageManager.getPage(pageId.get().longValue());
            long publishedPageId = this.internalPublishingManager.getPublishedPageId((AbstractPage)page, destinationPage.getSpaceKey());
            if (publishedPageId != 0L) {
                Optional<Page> publishedPage = Optional.ofNullable(this.pageManager.getPage(publishedPageId));
                destinationUrl = publishedPage.map(AbstractPage::getUrlPath).orElse("");
            } else if (page != null && StringUtils.contains((CharSequence)page.getUrlPath(), (CharSequence)"display")) {
                try {
                    destinationUrl = "/display/" + destinationPage.getSpaceKey() + "/" + URLEncoder.encode(page.getTitle(), StandardCharsets.UTF_8.toString());
                }
                catch (UnsupportedEncodingException | NullPointerException ex) {
                    log.warn("Could not generate destination page link destination page {} , generated page {}", (Object)destinationPage, (Object)page);
                }
            }
        }
        return this.replaceLink(destinationUrl, updatableAttribute.getValue());
    }

    private StartElement updateStartElement(StartElement startElement, Map<QName, String> updatedAttributeMap) {
        XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Iterator<Attribute> startElementAttributes = startElement.getAttributes();
        while (startElementAttributes.hasNext()) {
            Attribute elementAttribute = startElementAttributes.next();
            String updatedLink = updatedAttributeMap.get(elementAttribute.getName());
            if (StringUtils.isNotBlank((CharSequence)updatedLink)) {
                Attribute updatedAttribute = xmlEventFactory.createAttribute(elementAttribute.getName(), updatedLink);
                list.add(updatedAttribute);
                continue;
            }
            list.add(elementAttribute);
        }
        return xmlEventFactory.createStartElement(startElement.getName(), list.iterator(), startElement.getNamespaces());
    }

    private String replaceLink(String replacement, String attributeTextValue) {
        return StringUtils.replacePattern((String)attributeTextValue, (String)"\\/pages.\\w+.\\w+\\?\\w+=[0-9]+|\\/?viewpage.\\w+.\\w+\\?\\w+=[0-9]+", (String)replacement);
    }

    private Optional<Long> extractPageIdFromString(String attributeTexValue) {
        Pattern idPattern = Pattern.compile("pageId=([0-9]*)");
        Matcher matcher = idPattern.matcher(attributeTexValue);
        String idAsString = "";
        if (matcher.find()) {
            idAsString = matcher.group(1);
        }
        Long pageId = null;
        try {
            pageId = Long.parseLong(idAsString);
        }
        catch (NumberFormatException e) {
            log.warn("Could not convert string  {} to Long ", (Object)pageId, (Object)e);
        }
        return Optional.ofNullable(pageId);
    }
}

