/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.diagrams;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DiagramProcessor {
    public ByteArrayOutputStream processGraphLinks(Attachment var1, AbstractPage var2);

    public void setAttachmentMacroVersion(AbstractPage var1, AbstractPage var2, MacroDefinition var3, AttachmentManager var4);

    default public void setAttachmentMacroVersion(AbstractPage source, AbstractPage destination, String macroAttachmentName, String versionParamName, MacroDefinition macroDefinition, AttachmentManager attachmentManager) {
        Logger log = LoggerFactory.getLogger(DiagramProcessor.class);
        Map typedParameters = macroDefinition.getTypedParameters();
        Map parameters = macroDefinition.getParameters();
        try {
            String attachmentName = (String)typedParameters.get(macroAttachmentName);
            Attachment sourceAttachment = attachmentManager.getAttachment((ContentEntityObject)source, attachmentName);
            Attachment destAttachment = attachmentManager.getAttachment((ContentEntityObject)destination, attachmentName);
            if (null == destAttachment) {
                typedParameters.put(versionParamName, 1);
                parameters.put(versionParamName, "1");
            } else if (sourceAttachment.getVersion() != destAttachment.getVersion()) {
                typedParameters.put(versionParamName, destAttachment.getVersion());
                parameters.put(versionParamName, destAttachment.getVersion() + "");
            }
        }
        catch (Exception e) {
            log.debug("Something wrong with attachment related macro:{}", (Object)parameters);
            log.debug("{}", (Object)e.getMessage());
        }
        macroDefinition.setTypedParameters(typedParameters);
        macroDefinition.setParameters(parameters);
    }
}

