/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.analytics.collector;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.comalatech.confluence.analytics.StatField;
import com.comalatech.confluence.publishing.analytics.AnalyticsDataCollector;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WorkflowsIntegrationDataCollector
implements AnalyticsDataCollector {
    public static final String LATEST_PAGE_PUBLISHED_ACTION = "latestPagePublishedAction";
    public static final String LATEST_FINAL_WORKFLOW_VERSION_PUBLISHED = "latestFinalWorkflowVersionPublished";
    private final BandanaManager bandanaManager;
    private final List<String> allStats;

    public WorkflowsIntegrationDataCollector(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        this.allStats = Arrays.asList(LATEST_PAGE_PUBLISHED_ACTION, LATEST_FINAL_WORKFLOW_VERSION_PUBLISHED);
    }

    private StatField obtainLastTimePublishPageMacroWasInvoked() {
        Optional latestTimestamp = this.getTimeStampStack(LATEST_PAGE_PUBLISHED_ACTION);
        return new StatField(LATEST_PAGE_PUBLISHED_ACTION, () -> latestTimestamp.orElse(0L));
    }

    private StatField obtainLastTimeFinalPageWasPublished() {
        Optional latestTimestamp = this.getTimeStampStack(LATEST_FINAL_WORKFLOW_VERSION_PUBLISHED);
        return new StatField(LATEST_FINAL_WORKFLOW_VERSION_PUBLISHED, () -> latestTimestamp.orElse(0L));
    }

    @Override
    public void setTimeStampStat(Clock time, String key) {
        Objects.requireNonNull(time, "Time cannot be null");
        Objects.requireNonNull(key, "Bandana Key cannot be null");
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), key, (Object)time.millis());
    }

    @Override
    public List<StatField> getAnalyticsFields(List<String> filterNames) {
        ArrayList<StatField> fields = new ArrayList<StatField>();
        if (filterNames == null || filterNames.isEmpty()) {
            filterNames = this.allStats;
        }
        for (String name : filterNames) {
            this.when(name, LATEST_PAGE_PUBLISHED_ACTION::equals, () -> fields.add(this.obtainLastTimePublishPageMacroWasInvoked()));
            this.when(name, LATEST_FINAL_WORKFLOW_VERSION_PUBLISHED::equals, () -> fields.add(this.obtainLastTimeFinalPageWasPublished()));
        }
        return fields;
    }

    private <T> Optional<T> getTimeStampStack(String bandanaKey) {
        Object bandanaEntry = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), bandanaKey);
        return Optional.ofNullable(bandanaEntry);
    }
}

