/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.analytics.collector;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.comalatech.confluence.analytics.StatField;
import com.comalatech.confluence.publishing.analytics.AnalyticsDataCollector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingDataCollector
implements AnalyticsDataCollector {
    private static final Logger log = LoggerFactory.getLogger(PublishingDataCollector.class);
    public static final String LATEST_SPACE_PUBLISHED = "latestSpacePublished";
    public static final String LATEST_SPACE_COPIED = "latestSpaceCopied";
    public static final String LATEST_PAGE_PUBLISHED = "latestPagePublished";
    public static final String LINKED_SPACES = "linkedSpaces";
    private final BandanaManager bandanaManager;
    private final EntityManagerProvider entityManagerProvider;
    private final TransactionalExecutorFactory transactionalExecutorFactory;
    private final List<String> allStats;

    public PublishingDataCollector(BandanaManager bandanaManager, EntityManagerProvider entityManagerProvider, TransactionalExecutorFactory transactionalExecutorFactory) {
        this.bandanaManager = bandanaManager;
        this.entityManagerProvider = entityManagerProvider;
        this.transactionalExecutorFactory = transactionalExecutorFactory;
        this.allStats = Arrays.asList(LATEST_SPACE_PUBLISHED, LATEST_SPACE_COPIED, LATEST_PAGE_PUBLISHED, LINKED_SPACES);
    }

    private StatField obtainLastTimeSpacePublishWasInvoked() {
        Optional latestTimestamp = this.getTimeStampStack(LATEST_SPACE_PUBLISHED);
        return new StatField(LATEST_SPACE_PUBLISHED, () -> latestTimestamp.orElse(0L));
    }

    private StatField obtainLastTimeCopySpaceWasInvoked() {
        Optional latestTimestamp = this.getTimeStampStack(LATEST_SPACE_COPIED);
        return new StatField(LATEST_SPACE_COPIED, () -> latestTimestamp.orElse(0L));
    }

    private StatField obtainLastTimeIndividualPageHasBeenPublishInUi() {
        Optional latestTimestamp = this.getTimeStampStack(LATEST_PAGE_PUBLISHED);
        return new StatField(LATEST_PAGE_PUBLISHED, () -> latestTimestamp.orElse(0L));
    }

    private StatField obtainNumberOfLinkedSpaces() {
        int size = (Integer)this.transactionalExecutorFactory.create().execute(connection -> this.countLinkedSpaces(connection));
        return new StatField(LINKED_SPACES, () -> size);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int countLinkedSpaces(Connection conn) {
        if (conn == null) return 0;
        try (PreparedStatement s = conn.prepareStatement("SELECT COUNT(BANDANAKEY) as size from BANDANA where bandanakey = ? and BANDANAVALUE <> ?");){
            s.setString(1, "com.comalatech.space-config.publishing.destination");
            s.setString(2, "<null/>");
            try (ResultSet resultSet = s.executeQuery();){
                if (!resultSet.next()) return 0;
                int n = resultSet.getInt("size");
                return n;
            }
        }
        catch (SQLException e) {
            log.warn("Could not count the number of linked spaces", (Throwable)e);
        }
        return 0;
    }

    @Override
    public List<StatField> getAnalyticsFields(List<String> filterNames) {
        ArrayList<StatField> fields = new ArrayList<StatField>();
        if (filterNames == null || filterNames.isEmpty()) {
            filterNames = this.allStats;
        }
        for (String name : filterNames) {
            this.when(name, LATEST_SPACE_PUBLISHED::equals, () -> fields.add(this.obtainLastTimeSpacePublishWasInvoked()));
            this.when(name, LATEST_SPACE_COPIED::equals, () -> fields.add(this.obtainLastTimeCopySpaceWasInvoked()));
            this.when(name, LATEST_PAGE_PUBLISHED::equals, () -> fields.add(this.obtainLastTimeIndividualPageHasBeenPublishInUi()));
            this.when(name, LINKED_SPACES::equals, () -> fields.add(this.obtainNumberOfLinkedSpaces()));
        }
        return fields;
    }

    @Override
    public void setTimeStampStat(Clock time, String key) {
        Objects.requireNonNull(time, "Time cannot be null");
        Objects.requireNonNull(key, "Bandana Key cannot be null");
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), key, (Object)time.millis());
    }

    private <T> Optional<T> getTimeStampStack(String bandanaKey) {
        Object bandanaEntry = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), bandanaKey);
        return Optional.ofNullable(bandanaEntry);
    }
}

