/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.action.condition;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.comalatech.confluence.publishing.InternalPublishingManager;
import com.comalatech.confluence.publishing.PublishingUserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanPublishSpaceCondition
extends BaseConfluenceCondition {
    private static final Logger log = LoggerFactory.getLogger(CanPublishSpaceCondition.class);
    private final InternalPublishingManager publishingManager;

    public CanPublishSpaceCondition(InternalPublishingManager publishingManager) {
        this.publishingManager = publishingManager;
    }

    protected boolean shouldDisplay(WebInterfaceContext context) {
        try {
            if (!this.publishingManager.isSpacePublishable(context.getSpace())) {
                return false;
            }
            this.publishingManager.checkSpacePublishingOrCopyPermissions(context.getSpace(), null, false);
            return true;
        }
        catch (PublishingUserException e) {
            return false;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
    }
}

