/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.action;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.AbstractLongRunningTask;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.DefaultPublishingConfigurationManager;
import com.comalatech.confluence.publishing.PublishingUserException;
import com.comalatech.confluence.publishing.action.model.PageReorder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReorderSpacePagesSupportAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final Logger log = LoggerFactory.getLogger(ReorderSpacePagesSupportAction.class);
    private LongRunningTaskManager longRunningTaskManager;
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private DefaultPublishingConfigurationManager publishingConfigurationManager;
    private ContentPermissionManager contentPermissionManager;
    private TransactionTemplate transactionTemplate;
    private String errorMessage;
    private LongRunningTaskId taskId;
    private int totalPages = 0;
    private int totalPhantomPermissionPages = 0;
    private int processedPhantomPermissionPages = 0;

    public String view() {
        return "success";
    }

    public String reorderSpace() {
        try {
            if (this.isPermitted()) {
                if (this.publishingConfigurationManager.getSourceSpace(this.getSpace()) == null || this.publishingConfigurationManager.getPublicSpace(this.getSpace()) != null) {
                    throw new PublishingUserException("publishing.task.reorder.error.notpublic");
                }
            } else {
                throw new PublishingUserException("publishing.task.reorder.error.notallowed");
            }
            ReorderSpacePagesTask task = new ReorderSpacePagesTask("publishing.task.reorder.name", this.getSpace(), AuthenticatedUserThreadLocal.get());
            this.taskId = this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
        }
        catch (PublishingUserException pue) {
            this.errorMessage = pue.getMessage();
            return "error";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.errorMessage = e.getMessage();
            return "error";
        }
        return "success";
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)this.getSpace());
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getTaskId() {
        return this.taskId.toString();
    }

    public void setLongRunningTaskManager(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setPublishingConfigurationManager(DefaultPublishingConfigurationManager publishingConfigurationManager) {
        this.publishingConfigurationManager = publishingConfigurationManager;
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public class ReorderSpacePagesTask
    extends ConfluenceAbstractLongRunningTask {
        private String taskNameKey;
        private Space space;
        private ConfluenceUser currentUser;

        public ReorderSpacePagesTask(String taskNameKey, Space space, ConfluenceUser currentUser) {
            this.taskNameKey = taskNameKey;
            this.space = space;
            this.currentUser = currentUser;
        }

        protected void runInternal() {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)this.currentUser);
            this.progress.setStatus(ReorderSpacePagesSupportAction.this.getText("publishing.task.reorder.status.retrieving"));
            List pagesToBeReordered = (List)ReorderSpacePagesSupportAction.this.transactionTemplate.execute((TransactionCallback)new PagesToBeReorderedTransactionCallBack(this.space));
            this.progress.setStatus(ReorderSpacePagesSupportAction.this.getText("publishing.task.reorder.status.reordering"));
            log.trace("The number of pages with phantom permissions identified in spaceKey '{}' is:{} from a total of {} pages in the space.", new Object[]{ReorderSpacePagesSupportAction.this.getSpaceKey(), ReorderSpacePagesSupportAction.this.totalPhantomPermissionPages, ReorderSpacePagesSupportAction.this.totalPages});
            int count = 1;
            for (Long pageId : pagesToBeReordered) {
                log.trace("Page with id '{}' identified with Phantom Permissions", (Object)pageId);
                boolean successOnReordering = (Boolean)ReorderSpacePagesSupportAction.this.transactionTemplate.execute((TransactionCallback)new ReorderTransactionCallBack(pageId));
                this.progress.setPercentage(count, ReorderSpacePagesSupportAction.this.totalPhantomPermissionPages);
                ++count;
                if (successOnReordering) {
                    log.trace("Page with id '{}' successfully  reordered", (Object)pageId);
                    continue;
                }
                log.trace("Page with id '{}' not reordered (no children found for parent)", (Object)pageId);
            }
            this.progress.setStatus(ReorderSpacePagesSupportAction.this.getText("publishing.task.reorder.status.completed", new Object[]{ReorderSpacePagesSupportAction.this.processedPhantomPermissionPages, ReorderSpacePagesSupportAction.this.totalPhantomPermissionPages, ReorderSpacePagesSupportAction.this.totalPages}));
            this.progress.setPercentage(100);
            this.progress.setCompletedSuccessfully(true);
        }

        public String getName() {
            return ReorderSpacePagesSupportAction.this.getText(this.taskNameKey);
        }

        private boolean hasPageNeverPermittedPermissions(Page page) {
            List contentPermissionSets = ReorderSpacePagesSupportAction.this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)page, "View");
            for (ContentPermissionSet contentPermissionSet : contentPermissionSets) {
                if (!contentPermissionSet.getClass().getSimpleName().equalsIgnoreCase("NeverPermittedContentPermissionSet")) continue;
                return true;
            }
            return false;
        }

        class ReorderTransactionCallBack
        implements TransactionCallback<Boolean> {
            Long pageId;

            ReorderTransactionCallBack(Long pageId) {
                this.pageId = pageId;
            }

            public Boolean doInTransaction() {
                try {
                    new PageReorder(this.pageId, ReorderSpacePagesSupportAction.this.pageManager).reorderPage();
                    ReorderSpacePagesSupportAction.this.processedPhantomPermissionPages++;
                    return true;
                }
                catch (Exception e) {
                    ReorderSpacePagesTask.this.progress.setPercentage(100);
                    if (e.getMessage() != null) {
                        ReorderSpacePagesTask.this.progress.setStatus(e.getMessage());
                    } else {
                        ReorderSpacePagesTask.this.progress.setStatus("ERROR Check logs");
                    }
                    AbstractLongRunningTask.log.error("", (Throwable)e);
                    ReorderSpacePagesTask.this.progress.setCompletedSuccessfully(false);
                    return false;
                }
            }
        }

        class PagesToBeReorderedTransactionCallBack
        implements TransactionCallback<List<Long>> {
            Space space;

            public PagesToBeReorderedTransactionCallBack(Space space) {
                this.space = space;
            }

            public List<Long> doInTransaction() {
                List pages = ReorderSpacePagesSupportAction.this.pageManager.getPages(this.space, true);
                ReorderSpacePagesSupportAction.this.totalPages = pages.size();
                ArrayList<Long> pagesToBeReordered = new ArrayList<Long>();
                for (Page page : pages) {
                    if (page.isRootLevel() || !ReorderSpacePagesTask.this.hasPageNeverPermittedPermissions(page)) continue;
                    pagesToBeReordered.add(page.getId());
                }
                ReorderSpacePagesSupportAction.this.totalPhantomPermissionPages = pagesToBeReordered.size();
                return pagesToBeReordered;
            }
        }
    }
}

