/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.PublishingUserException;
import com.comalatech.confluence.publishing.analytics.ExtendedAnalyticsManager;
import com.comalatech.confluence.publishing.analytics.web.WebAnalyticsManager;
import com.comalatech.confluence.publishing.license.AdhocPublishingLicenseManager;
import com.comalatech.confluence.publishing.stats.PublishingStatisticsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingConfigurationAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(PublishingConfigurationAction.class);
    private static final String SPACE_DISPLAY_PATH = "/display/";
    private InternalPublishingConfigurationManager publishingConfigurationManager;
    private PublishingStatisticsManager publishingStatisticsManager;
    private SpaceManager spaceManager;
    private AdhocPublishingLicenseManager licenseManager;
    private ExtendedAnalyticsManager extendedAnalyticsManager;
    private WebAnalyticsManager webAnalyticsManager;
    private String publishersGroup;
    private String copiersGroup;
    private String publishingSpacesAsString;
    private String errorMessage;
    private boolean editMode;
    private String propertiesPrefixes;
    private String publishingSpacesAsLinks;
    private String propertiesLabel;
    private boolean statsEnabled;

    public String view() {
        this.checkPermissions();
        this.propertiesPrefixes = this.publishingConfigurationManager.getPropertiesPrefixesAsString();
        this.copiersGroup = this.publishingConfigurationManager.getCopiersGroup();
        this.publishersGroup = this.publishingConfigurationManager.getPublishersGroup();
        this.publishingSpacesAsString = this.publishingConfigurationManager.getPublishingSpacesAsString();
        this.publishingSpacesAsLinks = this.makeSpacesList(this.publishingConfigurationManager.getPublishingSpaces());
        this.propertiesLabel = this.publishingConfigurationManager.getPublishingLabel();
        return "success";
    }

    private void checkPermissions() {
        if (!this.permissionManager.isConfluenceAdministrator((User)this.getAuthenticatedUser())) {
            throw new RuntimeException("cannot access configuration");
        }
    }

    public String edit() {
        this.editMode = true;
        return this.view();
    }

    public String save() {
        this.checkPermissions();
        this.editMode = true;
        try {
            this.publishingConfigurationManager.setPropertiesPrefixes(this.propertiesPrefixes);
            this.publishingConfigurationManager.setPublishersGroup(this.publishersGroup);
            this.publishingConfigurationManager.setCopiersGroup(this.copiersGroup);
            this.publishingConfigurationManager.setPublishingSpaces(this.publishingSpacesAsString);
            this.publishingConfigurationManager.setPublishingLabel(this.propertiesLabel);
            this.publishingStatisticsManager.enableStats(this.statsEnabled);
            this.extendedAnalyticsManager.setEnabled(this.statsEnabled);
            this.editMode = false;
        }
        catch (PublishingUserException e) {
            this.addActionError(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return this.view();
    }

    public String getPublishingSpacesAsLinksHtml() {
        return this.publishingSpacesAsLinks;
    }

    private String makeSpacesList(String[] spaceKeys) {
        String spaceLinkPrefix = this.getBootstrapManager().getWebAppContextPath() + SPACE_DISPLAY_PATH;
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < spaceKeys.length; ++i) {
            String spaceKey = spaceKeys[i];
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space == null) continue;
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append("<a href='").append(spaceLinkPrefix).append(space.getKey()).append("'>");
            sb.append(space.getName()).append("</a>");
        }
        return sb.toString();
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getPublishersGroup() {
        return this.publishersGroup;
    }

    public void setPublishersGroup(String publishersGroup) {
        this.publishersGroup = publishersGroup;
    }

    public String getPublishingSpacesAsString() {
        return this.publishingSpacesAsString;
    }

    public void setPublishingSpacesAsString(String publishingSpacesAsString) {
        this.publishingSpacesAsString = publishingSpacesAsString;
    }

    public String getPropertiesPrefixes() {
        return this.propertiesPrefixes;
    }

    public void setPropertiesPrefixes(String propertiesPrefixes) {
        this.propertiesPrefixes = propertiesPrefixes;
    }

    public String getPropertiesLabel() {
        return this.propertiesLabel;
    }

    public void setPropertiesLabel(String propertiesLabel) {
        this.propertiesLabel = propertiesLabel;
    }

    public boolean isPublishAnySpace() {
        return this.publishingConfigurationManager.isPublishAnySpace();
    }

    public boolean isNoPublishingSpaces() {
        return this.publishingConfigurationManager.getPublishingSpaces().length == 0;
    }

    public void setPublishingConfigurationManager(InternalPublishingConfigurationManager publishingConfigurationManager) {
        this.publishingConfigurationManager = publishingConfigurationManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public String getCopiersGroup() {
        return this.copiersGroup;
    }

    public void setCopiersGroup(String copiersGroup) {
        this.copiersGroup = copiersGroup;
    }

    public boolean isStatsEnabled() {
        return this.publishingStatisticsManager.isStatsEnabled();
    }

    public void setStatsEnabled(boolean statsEnabled) {
        this.statsEnabled = statsEnabled;
    }

    public void setLicenseManager(AdhocPublishingLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public AdhocPublishingLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setPublishingStatisticsManager(PublishingStatisticsManager publishingStatisticsManager) {
        this.publishingStatisticsManager = publishingStatisticsManager;
    }

    public void setExtendedAnalyticsManager(ExtendedAnalyticsManager extendedAnalyticsManager) {
        this.extendedAnalyticsManager = extendedAnalyticsManager;
    }

    public PublishingStatisticsManager getPublishingStatisticsManager() {
        return this.publishingStatisticsManager;
    }

    public void setWebAnalyticsManager(WebAnalyticsManager webAnalyticsManager) {
        this.webAnalyticsManager = webAnalyticsManager;
    }

    public WebAnalyticsManager getWebAnalyticsManager() {
        return this.webAnalyticsManager;
    }
}

