/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingSettingsVelocityProvider
implements ContextProvider {
    private static final Logger log = LoggerFactory.getLogger(PublishingSettingsVelocityProvider.class);
    private final InternalPublishingConfigurationManager publishingConfigurationManager;
    private final SpaceManager spaceManager;

    public PublishingSettingsVelocityProvider(InternalPublishingConfigurationManager publishingConfigurationManager, SpaceManager spaceManager) {
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.spaceManager = spaceManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ConfluenceActionSupport action = (ConfluenceActionSupport)context.get("action");
        if (action == null) {
            return null;
        }
        WebInterfaceContext webInterfaceContext = action.getWebInterfaceContext();
        Space space = webInterfaceContext.getSpace();
        boolean hasWatermark = false;
        boolean pageIsInDraftSpace = false;
        String destSpaceKey = this.publishingConfigurationManager.getPublicSpaceKey(space);
        boolean existDestSpace = StringUtils.isNotBlank((String)destSpaceKey);
        if (existDestSpace) {
            hasWatermark = this.publishingConfigurationManager.isDraftWatermark(space);
            pageIsInDraftSpace = true;
        }
        boolean pageIsInPublishedSpace = false;
        String sourceSpaceKey = this.publishingConfigurationManager.getSourceSpaceKey(space);
        boolean existSourceSpace = StringUtils.isNotBlank((String)sourceSpaceKey);
        if (existSourceSpace) {
            pageIsInPublishedSpace = true;
        }
        HashMap<String, Object> fragmentContext = new HashMap<String, Object>();
        fragmentContext.put("hasWatermark", hasWatermark);
        fragmentContext.put("pageIsInPublishedSpace", pageIsInPublishedSpace);
        fragmentContext.put("pageIsInDraftSpace", pageIsInDraftSpace);
        return fragmentContext;
    }
}

